/*
 * Decompiled with CFR 0.152.
 */
package com.yyon.grapplinghook.client;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.yyon.grapplinghook.client.ClientControllerManager;
import com.yyon.grapplinghook.common.CommonSetup;
import com.yyon.grapplinghook.items.GrapplehookItem;
import com.yyon.grapplinghook.utils.GrappleCustomization;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.gui.ForgeIngameGui;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class CrosshairRenderer {
    public Minecraft mc;
    float zLevel = -90.0f;

    public CrosshairRenderer() {
        MinecraftForge.EVENT_BUS.register((Object)this);
        this.mc = Minecraft.m_91087_();
    }

    @SubscribeEvent
    public void onRenderGameOverlayPost(RenderGameOverlayEvent.PostLayer event) {
        PoseStack mStack = event.getMatrixStack();
        Options gamesettings = this.mc.f_91066_;
        if (!gamesettings.m_92176_().m_90612_()) {
            return;
        }
        if (this.mc.f_91074_.m_5833_()) {
            return;
        }
        if (gamesettings.f_92063_ && !gamesettings.f_92062_ && !this.mc.f_91074_.m_36330_() && !gamesettings.f_92047_) {
            return;
        }
        if (event.getOverlay() == ForgeIngameGui.CROSSHAIR_ELEMENT) {
            double rocketFuel;
            LocalPlayer player = this.mc.f_91074_;
            ItemStack grapplehookItemStack = null;
            if (player.m_21120_(InteractionHand.MAIN_HAND) != null && player.m_21120_(InteractionHand.MAIN_HAND).m_41720_() instanceof GrapplehookItem) {
                grapplehookItemStack = player.m_21120_(InteractionHand.MAIN_HAND);
            } else if (player.m_21120_(InteractionHand.OFF_HAND) != null && player.m_21120_(InteractionHand.OFF_HAND).m_41720_() instanceof GrapplehookItem) {
                grapplehookItemStack = player.m_21120_(InteractionHand.OFF_HAND);
            }
            if (grapplehookItemStack != null) {
                GrappleCustomization custom = CommonSetup.grapplingHookItem.getCustomization(grapplehookItemStack);
                double angle = Math.toRadians(custom.angle);
                double verticalangle = Math.toRadians(custom.verticalthrowangle);
                if (player.m_6047_()) {
                    angle = Math.toRadians(custom.sneakingangle);
                    verticalangle = Math.toRadians(custom.sneakingverticalthrowangle);
                }
                if (!custom.doublehook) {
                    angle = 0.0;
                }
                Window resolution = event.getWindow();
                int w = resolution.m_85445_();
                int h = resolution.m_85446_();
                double fov = Math.toRadians(gamesettings.f_92068_);
                double l = (double)h / 2.0 / Math.tan((fov *= (double)player.m_108565_()) / 2.0);
                if (verticalangle != 0.0 || custom.doublehook && angle != 0.0) {
                    int offset = (int)(Math.tan(angle) * l);
                    int verticaloffset = (int)(-Math.tan(verticalangle) * l);
                    this.drawCrosshair(mStack, w / 2 + offset, h / 2 + verticaloffset);
                    if (angle != 0.0) {
                        this.drawCrosshair(mStack, w / 2 - offset, h / 2 + verticaloffset);
                    }
                }
                if (custom.rocket && custom.rocket_vertical_angle != 0.0) {
                    int verticaloffset = (int)(-Math.tan(Math.toRadians(custom.rocket_vertical_angle)) * l);
                    this.drawCrosshair(mStack, w / 2, h / 2 + verticaloffset);
                }
            }
            if ((rocketFuel = ClientControllerManager.instance.rocketFuel) < 1.0) {
                Window resolution = event.getWindow();
                int w = resolution.m_85445_();
                int h = resolution.m_85446_();
                int totalbarlength = w / 8;
                RenderSystem.m_157191_().m_85836_();
                this.drawRect(w / 2 - totalbarlength / 2, h * 3 / 4, totalbarlength, 2, 50, 100);
                this.drawRect(w / 2 - totalbarlength / 2, h * 3 / 4, (int)((double)totalbarlength * rocketFuel), 2, 200, 255);
                RenderSystem.m_157191_().m_85849_();
            }
        }
    }

    private void drawCrosshair(PoseStack mStack, int x, int y) {
        RenderSystem.m_69416_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE_MINUS_DST_COLOR, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_COLOR, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        Minecraft.m_91087_().f_91065_.m_93228_(mStack, (int)((float)x - 7.5f), (int)((float)y - 7.5f), 0, 0, 15, 15);
        RenderSystem.m_69453_();
    }

    public void drawTexturedModalRect(int x, int y, int textureX, int textureY, int width, int height) {
        float f = 0.00390625f;
        float f1 = 0.00390625f;
        Tesselator tessellator = RenderSystem.m_69883_();
        BufferBuilder bufferbuilder = tessellator.m_85915_();
        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        bufferbuilder.m_5483_((double)(x + 0), (double)(y + height), (double)this.zLevel).m_7421_((float)(textureX + 0) * f, (float)(textureY + height) * f1).m_5752_();
        bufferbuilder.m_5483_((double)(x + width), (double)(y + height), (double)this.zLevel).m_7421_((float)(textureX + width) * f, (float)(textureY + height) * f1).m_5752_();
        bufferbuilder.m_5483_((double)(x + width), (double)(y + 0), (double)this.zLevel).m_7421_((float)(textureX + width) * f, (float)(textureY + 0) * f1).m_5752_();
        bufferbuilder.m_5483_((double)(x + 0), (double)(y + 0), (double)this.zLevel).m_7421_((float)(textureX + 0) * f, (float)(textureY + 0) * f1).m_5752_();
        tessellator.m_85914_();
    }

    public void drawRect(int x, int y, int width, int height, int g, int a) {
        RenderSystem.m_157427_(GameRenderer::m_172811_);
        BufferBuilder bufferbuilder = Tesselator.m_85913_().m_85915_();
        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        bufferbuilder.m_5483_((double)(x + 0), (double)(y + height), (double)this.zLevel).m_6122_(g, g, g, a).m_5752_();
        bufferbuilder.m_5483_((double)(x + width), (double)(y + height), (double)this.zLevel).m_6122_(g, g, g, a).m_5752_();
        bufferbuilder.m_5483_((double)(x + width), (double)(y + 0), (double)this.zLevel).m_6122_(g, g, g, a).m_5752_();
        bufferbuilder.m_5483_((double)(x + 0), (double)(y + 0), (double)this.zLevel).m_6122_(g, g, g, a).m_5752_();
        bufferbuilder.m_85721_();
        BufferUploader.m_85761_((BufferBuilder)bufferbuilder);
    }
}

