/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.world.capabilities.skill;

import com.google.common.collect.HashMultimap;
import java.util.Collection;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import yesman.epicfight.gameasset.Skills;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillCategory;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;

public class CapabilitySkill {
    public static final CapabilitySkill EMPTY = new CapabilitySkill(null);
    public final SkillContainer[] skillContainers;
    private final HashMultimap<SkillCategory, Skill> learnedSkills = HashMultimap.create();

    public CapabilitySkill(PlayerPatch<?> playerpatch) {
        Collection<SkillCategory> categories = SkillCategory.ENUM_MANAGER.universalValues();
        this.skillContainers = new SkillContainer[categories.size()];
        for (SkillCategory slot : categories) {
            this.skillContainers[slot.universalOrdinal()] = new SkillContainer(playerpatch, slot.universalOrdinal());
        }
    }

    public void clear() {
        int i = 0;
        for (SkillContainer container : this.skillContainers) {
            if (SkillCategory.ENUM_MANAGER.get(i).learnable()) {
                container.setSkill(null);
            }
            ++i;
        }
        this.learnedSkills.clear();
    }

    public void addLearnedSkill(Skill skill) {
        SkillCategory category = skill.getCategory();
        if (!this.learnedSkills.containsKey((Object)category) || !this.learnedSkills.get((Object)category).contains(skill)) {
            this.learnedSkills.put((Object)category, (Object)skill);
        }
    }

    public boolean removeLearnedSkill(Skill skill) {
        SkillCategory category = skill.getCategory();
        if (this.learnedSkills.containsKey((Object)category) && this.learnedSkills.remove((Object)category, (Object)skill)) {
            if (this.learnedSkills.get((Object)category).size() == 0) {
                this.learnedSkills.removeAll((Object)category);
            }
            return true;
        }
        return false;
    }

    public Collection<Skill> getLearnedSkills(SkillCategory skillCategory) {
        return this.learnedSkills.get((Object)skillCategory);
    }

    public boolean hasCategory(SkillCategory skillCategory) {
        return this.learnedSkills.containsKey((Object)skillCategory);
    }

    public CompoundTag toNBT() {
        CompoundTag nbt = new CompoundTag();
        for (SkillContainer container : this.skillContainers) {
            if (container.getSkill() == null || !container.getSkill().getCategory().shouldSaved()) continue;
            nbt.m_128359_(String.valueOf(container.getSkill().getCategory().universalOrdinal()), container.getSkill().toString());
        }
        for (Map.Entry entry : this.learnedSkills.asMap().entrySet()) {
            CompoundTag learnedNBT = new CompoundTag();
            int i = 0;
            for (Skill skill : (Collection)entry.getValue()) {
                learnedNBT.m_128359_(String.valueOf(i++), skill.toString());
            }
            nbt.m_128365_(String.valueOf("learned" + ((SkillCategory)entry.getKey()).universalOrdinal()), (Tag)learnedNBT);
        }
        return nbt;
    }

    public void fromNBT(CompoundTag nbt) {
        int i = 0;
        for (SkillContainer container : this.skillContainers) {
            if (nbt.m_128441_(String.valueOf(i))) {
                Skill skill = Skills.getSkill(nbt.m_128461_(String.valueOf(i)));
                container.setSkill(skill);
                this.addLearnedSkill(skill);
            }
            ++i;
        }
        for (SkillCategory category : SkillCategory.ENUM_MANAGER.universalValues()) {
            if (!nbt.m_128441_("learned" + String.valueOf(category.universalOrdinal()))) continue;
            CompoundTag learnedNBT = nbt.m_128469_("learned" + String.valueOf(category.universalOrdinal()));
            for (String key : learnedNBT.m_128431_()) {
                this.addLearnedSkill(Skills.getSkill(learnedNBT.m_128461_(key)));
            }
        }
    }
}

