/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.world.capabilities.provider;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.player.RemotePlayer;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.common.util.NonNullSupplier;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.ModLoader;
import net.minecraftforge.registries.ForgeRegistries;
import yesman.epicfight.api.forgeevent.EntityPatchRegistryEvent;
import yesman.epicfight.client.world.capabilites.entitypatch.player.AbstractClientPlayerPatch;
import yesman.epicfight.client.world.capabilites.entitypatch.player.LocalPlayerPatch;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.EntityPatch;
import yesman.epicfight.world.capabilities.entitypatch.boss.WitherGhostPatch;
import yesman.epicfight.world.capabilities.entitypatch.boss.WitherPatch;
import yesman.epicfight.world.capabilities.entitypatch.boss.enderdragon.EnderDragonPatch;
import yesman.epicfight.world.capabilities.entitypatch.mob.CaveSpiderPatch;
import yesman.epicfight.world.capabilities.entitypatch.mob.CreeperPatch;
import yesman.epicfight.world.capabilities.entitypatch.mob.DrownedPatch;
import yesman.epicfight.world.capabilities.entitypatch.mob.EndermanPatch;
import yesman.epicfight.world.capabilities.entitypatch.mob.EvokerPatch;
import yesman.epicfight.world.capabilities.entitypatch.mob.HoglinPatch;
import yesman.epicfight.world.capabilities.entitypatch.mob.IronGolemPatch;
import yesman.epicfight.world.capabilities.entitypatch.mob.PiglinBrutePatch;
import yesman.epicfight.world.capabilities.entitypatch.mob.PiglinPatch;
import yesman.epicfight.world.capabilities.entitypatch.mob.PillagerPatch;
import yesman.epicfight.world.capabilities.entitypatch.mob.RavagerPatch;
import yesman.epicfight.world.capabilities.entitypatch.mob.SkeletonPatch;
import yesman.epicfight.world.capabilities.entitypatch.mob.SpiderPatch;
import yesman.epicfight.world.capabilities.entitypatch.mob.StrayPatch;
import yesman.epicfight.world.capabilities.entitypatch.mob.VexPatch;
import yesman.epicfight.world.capabilities.entitypatch.mob.VindicatorPatch;
import yesman.epicfight.world.capabilities.entitypatch.mob.WitchPatch;
import yesman.epicfight.world.capabilities.entitypatch.mob.WitherSkeletonPatch;
import yesman.epicfight.world.capabilities.entitypatch.mob.ZoglinPatch;
import yesman.epicfight.world.capabilities.entitypatch.mob.ZombiePatch;
import yesman.epicfight.world.capabilities.entitypatch.mob.ZombieVillagerPatch;
import yesman.epicfight.world.capabilities.entitypatch.mob.ZombifiedPiglinPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;
import yesman.epicfight.world.entity.EpicFightEntities;

public class ProviderEntity
implements ICapabilityProvider,
NonNullSupplier<EntityPatch<?>> {
    private static final Map<EntityType<?>, Function<Entity, Supplier<EntityPatch<?>>>> CAPABILITIES = Maps.newHashMap();
    private static final Map<EntityType<?>, Function<Entity, Supplier<EntityPatch<?>>>> CUSTOM_CAPABILITIES = Maps.newHashMap();
    private EntityPatch<?> capability;
    private LazyOptional<EntityPatch<?>> optional = LazyOptional.of((NonNullSupplier)this);

    public static void registerEntityPatches() {
        HashMap registry = Maps.newHashMap();
        registry.put(EntityType.f_20532_, entityIn -> ServerPlayerPatch::new);
        registry.put(EntityType.f_20501_, entityIn -> ZombiePatch::new);
        registry.put(EntityType.f_20558_, entityIn -> CreeperPatch::new);
        registry.put(EntityType.f_20566_, entityIn -> EndermanPatch::new);
        registry.put(EntityType.f_20524_, entityIn -> SkeletonPatch::new);
        registry.put(EntityType.f_20497_, entityIn -> WitherSkeletonPatch::new);
        registry.put(EntityType.f_20481_, entityIn -> StrayPatch::new);
        registry.put(EntityType.f_20531_, entityIn -> ZombifiedPiglinPatch::new);
        registry.put(EntityType.f_20530_, entityIn -> ZombieVillagerPatch::new);
        registry.put(EntityType.f_20458_, entityIn -> ZombiePatch::new);
        registry.put(EntityType.f_20479_, entityIn -> SpiderPatch::new);
        registry.put(EntityType.f_20554_, entityIn -> CaveSpiderPatch::new);
        registry.put(EntityType.f_20460_, entityIn -> IronGolemPatch::new);
        registry.put(EntityType.f_20493_, entityIn -> VindicatorPatch::new);
        registry.put(EntityType.f_20568_, entityIn -> EvokerPatch::new);
        registry.put(EntityType.f_20495_, entityIn -> WitchPatch::new);
        registry.put(EntityType.f_20562_, entityIn -> DrownedPatch::new);
        registry.put(EntityType.f_20513_, entityIn -> PillagerPatch::new);
        registry.put(EntityType.f_20518_, entityIn -> RavagerPatch::new);
        registry.put(EntityType.f_20491_, entityIn -> VexPatch::new);
        registry.put(EntityType.f_20511_, entityIn -> PiglinPatch::new);
        registry.put(EntityType.f_20512_, entityIn -> PiglinBrutePatch::new);
        registry.put(EntityType.f_20456_, entityIn -> HoglinPatch::new);
        registry.put(EntityType.f_20500_, entityIn -> ZoglinPatch::new);
        registry.put(EntityType.f_20565_, entityIn -> {
            if (entityIn instanceof EnderDragon) {
                return EnderDragonPatch::new;
            }
            return () -> null;
        });
        registry.put(EntityType.f_20496_, entityIn -> WitherPatch::new);
        registry.put((EntityType)EpicFightEntities.WITHER_SKELETON_MINION.get(), entityIn -> WitherSkeletonPatch::new);
        registry.put((EntityType)EpicFightEntities.WITHER_GHOST_CLONE.get(), entityIn -> WitherGhostPatch::new);
        EntityPatchRegistryEvent entitypatchRegistryEvent = new EntityPatchRegistryEvent(registry);
        ModLoader.get().postEvent((Event)entitypatchRegistryEvent);
        registry.forEach(CAPABILITIES::put);
    }

    public static void registerEntityPatchesClient() {
        CAPABILITIES.put(EntityType.f_20532_, entityIn -> {
            if (entityIn instanceof LocalPlayer) {
                return LocalPlayerPatch::new;
            }
            if (entityIn instanceof RemotePlayer) {
                return AbstractClientPlayerPatch::new;
            }
            if (entityIn instanceof ServerPlayer) {
                return ServerPlayerPatch::new;
            }
            return () -> null;
        });
    }

    public static void clear() {
        CUSTOM_CAPABILITIES.clear();
    }

    public static void putCustomEntityPatch(EntityType<?> entityType, Function<Entity, Supplier<EntityPatch<?>>> entitypatchProvider) {
        CUSTOM_CAPABILITIES.put(entityType, entitypatchProvider);
    }

    public static Function<Entity, Supplier<EntityPatch<?>>> get(String registryName) {
        ResourceLocation rl = new ResourceLocation(registryName);
        EntityType entityType = (EntityType)ForgeRegistries.ENTITIES.getValue(rl);
        return CAPABILITIES.get(entityType);
    }

    public ProviderEntity(Entity entity) {
        Function<Entity, Supplier<EntityPatch<?>>> provider = CUSTOM_CAPABILITIES.getOrDefault(entity.m_6095_(), CAPABILITIES.get(entity.m_6095_()));
        if (provider != null) {
            this.capability = provider.apply(entity).get();
        }
    }

    public boolean hasCapability() {
        return this.capability != null;
    }

    public EntityPatch<?> get() {
        return this.capability;
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        return cap == EpicFightCapabilities.CAPABILITY_ENTITY ? this.optional.cast() : LazyOptional.empty();
    }
}

