/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.world.capabilities.entitypatch.mob;

import java.util.Set;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MoveTowardsTargetGoal;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.entity.living.LivingEvent;
import yesman.epicfight.api.animation.LivingMotions;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.api.client.animation.ClientAnimator;
import yesman.epicfight.api.model.Model;
import yesman.epicfight.api.utils.ExtendedDamageSource;
import yesman.epicfight.gameasset.Animations;
import yesman.epicfight.gameasset.EpicFightSounds;
import yesman.epicfight.gameasset.MobCombatBehaviors;
import yesman.epicfight.gameasset.Models;
import yesman.epicfight.world.capabilities.entitypatch.Faction;
import yesman.epicfight.world.capabilities.entitypatch.MobPatch;
import yesman.epicfight.world.entity.ai.attribute.EpicFightAttributes;
import yesman.epicfight.world.entity.ai.goal.AnimatedAttackGoal;
import yesman.epicfight.world.entity.ai.goal.TargetChasingGoal;

public class IronGolemPatch
extends MobPatch<IronGolem> {
    private int deathTimerExt;

    public IronGolemPatch() {
        super(Faction.VILLAGER);
    }

    @Override
    protected void initAI() {
        super.initAI();
        ((IronGolem)this.original).f_21345_.m_25352_(0, new AnimatedAttackGoal<IronGolemPatch>(this, MobCombatBehaviors.IRON_GOLEM.build(this)));
        ((IronGolem)this.original).f_21345_.m_25352_(1, (Goal)new TargetChasingGoal(this, (PathfinderMob)this.original, 1.0, false));
    }

    @Override
    protected void selectGoalToRemove(Set<Goal> toRemove) {
        super.selectGoalToRemove(toRemove);
        for (WrappedGoal wrappedGoal : ((IronGolem)this.original).f_21345_.m_148105_()) {
            Goal goal = wrappedGoal.m_26015_();
            if (!(goal instanceof MoveTowardsTargetGoal)) continue;
            toRemove.add(goal);
        }
    }

    @Override
    protected void initAttributes() {
        super.initAttributes();
        ((IronGolem)this.original).m_21051_((Attribute)EpicFightAttributes.MAX_STRIKES.get()).m_22100_(4.0);
        ((IronGolem)this.original).m_21051_((Attribute)EpicFightAttributes.IMPACT.get()).m_22100_(6.0);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void initAnimator(ClientAnimator clientAnimator) {
        clientAnimator.addLivingAnimation(LivingMotions.IDLE, Animations.GOLEM_IDLE);
        clientAnimator.addLivingAnimation(LivingMotions.WALK, Animations.GOLEM_WALK);
        clientAnimator.addLivingAnimation(LivingMotions.DEATH, Animations.GOLEM_DEATH);
        clientAnimator.setCurrentMotionsAsDefault();
    }

    @Override
    public void updateMotion(boolean considerInaction) {
        super.commonMobUpdateMotion(considerInaction);
    }

    @Override
    public void tick(LivingEvent.LivingUpdateEvent event) {
        if (((IronGolem)this.original).m_21223_() <= 0.0f) {
            ((IronGolem)this.original).m_146926_(0.0f);
            if (((IronGolem)this.original).f_20919_ > 1 && this.deathTimerExt < 20) {
                ++this.deathTimerExt;
                --((IronGolem)this.original).f_20919_;
            }
        }
        super.tick(event);
    }

    @Override
    public SoundEvent getWeaponHitSound(InteractionHand hand) {
        return EpicFightSounds.BLUNT_HIT_HARD;
    }

    @Override
    public SoundEvent getSwingSound(InteractionHand hand) {
        return EpicFightSounds.WHOOSH_BIG;
    }

    @Override
    public float getDamageTo(Entity targetEntity, ExtendedDamageSource source, InteractionHand hand) {
        float damage = super.getDamageTo(targetEntity, source, hand);
        return (int)damage > 0 ? damage / 2.0f + (float)((IronGolem)this.original).m_21187_().nextInt((int)damage) : damage;
    }

    @Override
    public StaticAnimation getHitAnimation(ExtendedDamageSource.StunType stunType) {
        return null;
    }

    @Override
    public <M extends Model> M getEntityModel(Models<M> modelDB) {
        return (M)modelDB.ironGolem;
    }
}

