/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.world.capabilities.entitypatch.boss.enderdragon;

import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.boss.enderdragon.phases.DragonPhaseInstance;
import net.minecraft.world.entity.boss.enderdragon.phases.EnderDragonPhase;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.entity.PartEntity;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import yesman.epicfight.api.animation.LivingMotion;
import yesman.epicfight.api.animation.LivingMotions;
import yesman.epicfight.api.animation.TransformSheet;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.api.animation.types.procedural.IKInfo;
import yesman.epicfight.api.animation.types.procedural.TipPointAnimation;
import yesman.epicfight.api.client.animation.ClientAnimator;
import yesman.epicfight.api.model.Model;
import yesman.epicfight.api.utils.AttackResult;
import yesman.epicfight.api.utils.ExtendedDamageSource;
import yesman.epicfight.api.utils.math.MathUtils;
import yesman.epicfight.api.utils.math.OpenMatrix4f;
import yesman.epicfight.api.utils.math.Vec3f;
import yesman.epicfight.gameasset.Animations;
import yesman.epicfight.gameasset.EpicFightSounds;
import yesman.epicfight.gameasset.Models;
import yesman.epicfight.world.capabilities.entitypatch.MobPatch;
import yesman.epicfight.world.capabilities.entitypatch.boss.enderdragon.DragonAirstrikePhase;
import yesman.epicfight.world.capabilities.entitypatch.boss.enderdragon.DragonCrystalLinkPhase;
import yesman.epicfight.world.capabilities.entitypatch.boss.enderdragon.PatchedDragonPhase;
import yesman.epicfight.world.capabilities.entitypatch.boss.enderdragon.PatchedPhases;
import yesman.epicfight.world.capabilities.entitypatch.boss.enderdragon.PhaseManagerPatch;
import yesman.epicfight.world.entity.ai.attribute.EpicFightAttributes;

public class EnderDragonPatch
extends MobPatch<EnderDragon> {
    public static final TargetingConditions DRAGON_TARGETING = TargetingConditions.m_148352_().m_148355_();
    public static EnderDragonPatch INSTANCE_CLIENT;
    public static EnderDragonPatch INSTANCE_SERVER;
    private Map<String, TipPointAnimation> tipPointAnimations = Maps.newHashMap();
    private Map<LivingMotions, StaticAnimation> livingMotions = Maps.newHashMap();
    private boolean groundPhase;
    public float xRoot;
    public float xRootO;
    public float zRoot;
    public float zRootO;
    public LivingMotion prevMotion = LivingMotions.FLY;

    @Override
    public void onConstructed(EnderDragon entityIn) {
        this.livingMotions.put(LivingMotions.IDLE, Animations.DRAGON_IDLE);
        this.livingMotions.put(LivingMotions.WALK, Animations.DRAGON_WALK);
        this.livingMotions.put(LivingMotions.FLY, Animations.DRAGON_FLY);
        this.livingMotions.put(LivingMotions.CHASE, Animations.DRAGON_AIRSTRIKE);
        this.livingMotions.put(LivingMotions.DEATH, Animations.DRAGON_DEATH);
        super.onConstructed(entityIn);
        this.currentLivingMotion = LivingMotions.FLY;
    }

    @Override
    public void onJoinWorld(EnderDragon entityIn, EntityJoinWorldEvent event) {
        super.onJoinWorld(entityIn, event);
        DragonPhaseInstance currentPhase = ((EnderDragon)this.original).f_31074_.m_31415_();
        EnderDragonPhase startPhase = currentPhase == null || !(currentPhase instanceof PatchedDragonPhase) ? PatchedPhases.FLYING : ((EnderDragon)this.original).f_31074_.m_31415_().m_7309_();
        ((EnderDragon)this.original).f_31074_ = new PhaseManagerPatch((EnderDragon)this.original, this);
        ((EnderDragon)this.original).f_31074_.m_31416_(startPhase);
        entityIn.f_19793_ = 1.0f;
        if (entityIn.f_19853_.m_5776_()) {
            INSTANCE_CLIENT = this;
        } else {
            INSTANCE_SERVER = this;
        }
    }

    @Override
    protected void initAttributes() {
        super.initAttributes();
        ((EnderDragon)this.original).m_21051_((Attribute)EpicFightAttributes.IMPACT.get()).m_22100_(8.0);
        ((EnderDragon)this.original).m_21051_((Attribute)EpicFightAttributes.MAX_STRIKES.get()).m_22100_(Double.MAX_VALUE);
        ((EnderDragon)this.original).m_21051_(Attributes.f_22281_).m_22100_(10.0);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void initAnimator(ClientAnimator clientAnimator) {
        for (Map.Entry<LivingMotions, StaticAnimation> livingmotionEntry : this.livingMotions.entrySet()) {
            clientAnimator.addLivingAnimation(livingmotionEntry.getKey(), livingmotionEntry.getValue());
        }
        clientAnimator.setCurrentMotionsAsDefault();
    }

    @Override
    public void updateMotion(boolean considerInaction) {
        if (((EnderDragon)this.original).m_21223_() <= 0.0f) {
            this.currentLivingMotion = LivingMotions.DEATH;
        } else if (this.state.inaction() && considerInaction) {
            this.currentLivingMotion = LivingMotions.IDLE;
        } else {
            DragonPhaseInstance phase = ((EnderDragon)this.original).m_31157_().m_31415_();
            this.currentLivingMotion = !this.groundPhase ? (phase.m_7309_() == PatchedPhases.AIRSTRIKE && ((DragonAirstrikePhase)phase).isActuallyAttacking() ? LivingMotions.CHASE : LivingMotions.FLY) : (phase.m_7309_() == PatchedPhases.GROUND_BATTLE ? (((EnderDragon)this.original).m_5448_() != null ? LivingMotions.WALK : LivingMotions.IDLE) : LivingMotions.IDLE);
        }
    }

    @Override
    public void tick(LivingEvent.LivingUpdateEvent event) {
        super.tick(event);
        if (((EnderDragon)this.original).m_31157_().m_31415_().m_7080_()) {
            ((EnderDragon)this.original).f_31086_ = null;
        }
    }

    @Override
    public void serverTick(LivingEvent.LivingUpdateEvent event) {
        super.serverTick(event);
        ((EnderDragon)this.original).f_20916_ = 2;
        ((EnderDragon)this.original).m_21574_().m_26789_();
        this.updateMotion(true);
        if (this.prevMotion != this.currentLivingMotion && !this.animator.getEntityState().inaction()) {
            if (this.livingMotions.containsKey(this.currentLivingMotion)) {
                this.animator.playAnimation(this.livingMotions.get(this.currentLivingMotion), 0.0f);
            }
            this.prevMotion = this.currentLivingMotion;
        }
        this.updateTipPoints();
        PartEntity bodyPart = ((EnderDragon)this.original).getParts()[2];
        AABB bodyBoundingBox = bodyPart.m_142469_();
        List list = ((EnderDragon)this.original).f_19853_.m_6249_(this.original, bodyBoundingBox, EntitySelector.m_20421_((Entity)this.original));
        if (!list.isEmpty()) {
            for (int l = 0; l < list.size(); ++l) {
                double d1;
                Entity entity = (Entity)list.get(l);
                double d0 = entity.m_20185_() - ((EnderDragon)this.original).m_20185_();
                double d2 = Mth.m_14005_((double)d0, (double)(d1 = entity.m_20189_() - ((EnderDragon)this.original).m_20189_()));
                if (!(d2 >= 0.01)) continue;
                d2 = Math.sqrt(d2);
                d0 /= d2;
                d1 /= d2;
                double d3 = 1.0 / d2;
                if (d3 > 1.0) {
                    d3 = 1.0;
                }
                d0 = d0 * d3 * 0.2;
                d1 = d1 * d3 * 0.2;
                if (entity.m_20160_()) continue;
                entity.m_5997_(d0, 0.0, d1);
                entity.f_19864_ = true;
            }
        }
    }

    @Override
    public void clientTick(LivingEvent.LivingUpdateEvent event) {
        this.xRootO = this.xRoot;
        this.zRootO = this.zRoot;
        super.clientTick(event);
        this.updateTipPoints();
    }

    @Override
    public void setStunShield(float value) {
        DragonPhaseInstance currentPhase;
        super.setStunShield(value);
        if (value <= 0.0f && (currentPhase = ((EnderDragon)this.original).m_31157_().m_31415_()).m_7309_() == PatchedPhases.CRYSTAL_LINK && ((DragonCrystalLinkPhase)currentPhase).getChargingCount() > 0) {
            ((EnderDragon)this.original).m_5496_(EpicFightSounds.NEUTRALIZE_BOSSES, 5.0f, 1.0f);
            ((EnderDragon)this.original).m_31157_().m_31416_(PatchedPhases.NEUTRALIZED);
        }
    }

    @Override
    public AttackResult tryHurt(DamageSource damageSource, float amount) {
        return super.tryHurt(damageSource, ((EnderDragon)this.original).m_31157_().m_31415_().m_7309_() == PatchedPhases.CRYSTAL_LINK ? 0.0f : amount);
    }

    @Override
    public void rotateTo(Entity target, float limit, boolean partialSync) {
        double d0 = target.m_20185_() - ((EnderDragon)this.original).m_20185_();
        double d1 = target.m_20189_() - ((EnderDragon)this.original).m_20189_();
        float degree = 180.0f - (float)Math.toDegrees(Mth.m_14136_((double)d0, (double)d1));
        this.rotateTo(degree, limit, partialSync);
    }

    public void updateTipPoints() {
        for (Map.Entry<String, TipPointAnimation> entry : this.tipPointAnimations.entrySet()) {
            if (!entry.getValue().isOnWorking()) continue;
            entry.getValue().tick();
        }
        if (this.tipPointAnimations.size() > 0) {
            TipPointAnimation frontL = this.getTipPointAnimation("Leg_Front_L3");
            TipPointAnimation frontR = this.getTipPointAnimation("Leg_Front_R3");
            TipPointAnimation backL = this.getTipPointAnimation("Leg_Back_L3");
            TipPointAnimation backR = this.getTipPointAnimation("Leg_Back_R3");
            float entityPosY = (float)((EnderDragon)this.original).m_20182_().f_82480_;
            float yFrontL = frontL != null && frontL.isTouchingGround() ? frontL.getTargetPosition().y : entityPosY;
            float yFrontR = frontR != null && frontR.isTouchingGround() ? frontR.getTargetPosition().y : entityPosY;
            float yBackL = backL != null && backL.isTouchingGround() ? backL.getTargetPosition().y : entityPosY;
            float yBackR = backR != null && backR.isTouchingGround() ? backR.getTargetPosition().y : entityPosY;
            float xdiff = (yFrontL + yBackL) * 0.5f - (yFrontR + yBackR) * 0.5f;
            float zdiff = (yFrontL + yFrontR) * 0.5f - (yBackL + yBackR) * 0.5f;
            float xdistance = 4.0f;
            float zdistance = 5.7f;
            this.xRoot += Mth.m_14036_((float)((float)Math.toDegrees(Math.atan2(zdiff, zdistance)) - this.xRoot), (float)-1.0f, (float)1.0f);
            this.zRoot += Mth.m_14036_((float)((float)Math.toDegrees(Math.atan2(xdiff, xdistance)) - this.zRoot), (float)-1.0f, (float)1.0f);
            float averageY = (yFrontL + yFrontR + yBackL + yBackR) * 0.25f;
            if (!this.isLogicalClient()) {
                float dy = averageY - entityPosY;
                ((EnderDragon)this.original).m_6478_(MoverType.SELF, new Vec3(0.0, (double)dy, 0.0));
            }
        }
    }

    public void resetTipAnimations() {
        this.tipPointAnimations.clear();
    }

    public void setFlyingPhase() {
        this.groundPhase = false;
        ((EnderDragon)this.original).f_19862_ = false;
        ((EnderDragon)this.original).f_19863_ = false;
    }

    public void setGroundPhase() {
        this.groundPhase = true;
    }

    public boolean isGroundPhase() {
        return this.groundPhase;
    }

    @Override
    public SoundEvent getSwingSound(InteractionHand hand) {
        return EpicFightSounds.WHOOSH_BIG;
    }

    @Override
    public <M extends Model> M getEntityModel(Models<M> modelDB) {
        return (M)modelDB.dragon;
    }

    @Override
    public StaticAnimation getHitAnimation(ExtendedDamageSource.StunType stunType) {
        return null;
    }

    @Override
    public OpenMatrix4f getModelMatrix(float partialTicks) {
        return MathUtils.getModelMatrixIntegral(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, ((EnderDragon)this.original).f_19859_, ((EnderDragon)this.original).m_146908_(), partialTicks, -1.0f, 1.0f, -1.0f);
    }

    @Override
    public double getAngleTo(Entity entityIn) {
        Vec3 a = ((EnderDragon)this.original).m_20154_().m_82490_(-1.0);
        Vec3 b = new Vec3(entityIn.m_20185_() - ((EnderDragon)this.original).m_20185_(), entityIn.m_20186_() - ((EnderDragon)this.original).m_20186_(), entityIn.m_20189_() - ((EnderDragon)this.original).m_20189_()).m_82541_();
        double cosTheta = a.f_82479_ * b.f_82479_ + a.f_82480_ * b.f_82480_ + a.f_82481_ * b.f_82481_;
        return Math.toDegrees(Math.acos(cosTheta));
    }

    @Override
    public double getAngleToHorizontal(Entity entityIn) {
        Vec3 a = ((EnderDragon)this.original).m_20154_().m_82490_(-1.0);
        Vec3 b = new Vec3(entityIn.m_20185_() - ((EnderDragon)this.original).m_20185_(), 0.0, entityIn.m_20189_() - ((EnderDragon)this.original).m_20189_()).m_82541_();
        double cos = a.f_82479_ * b.f_82479_ + a.f_82480_ * b.f_82480_ + a.f_82481_ * b.f_82481_;
        return Math.toDegrees(Math.acos(cos));
    }

    public TipPointAnimation getTipPointAnimation(String jointName) {
        return this.tipPointAnimations.get(jointName);
    }

    public void addTipPointAnimation(String jointName, Vec3f initpos, TransformSheet transformSheet, IKInfo ikSetter) {
        this.tipPointAnimations.put(jointName, new TipPointAnimation(transformSheet, initpos, ikSetter));
    }

    public Collection<TipPointAnimation> getTipPointAnimations() {
        return this.tipPointAnimations.values();
    }
}

