/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.world.capabilities.entitypatch.boss.enderdragon;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.EntityDamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.boss.enderdragon.phases.DragonPhaseInstance;
import net.minecraft.world.entity.boss.enderdragon.phases.EnderDragonPhase;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.level.PathNavigationRegion;
import net.minecraft.world.level.pathfinder.NodeEvaluator;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.level.pathfinder.PathFinder;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;
import net.minecraft.world.phys.Vec3;
import yesman.epicfight.api.animation.types.EntityState;
import yesman.epicfight.api.utils.ExtendedDamageSource;
import yesman.epicfight.api.utils.math.MathUtils;
import yesman.epicfight.gameasset.Animations;
import yesman.epicfight.gameasset.MobCombatBehaviors;
import yesman.epicfight.world.capabilities.entitypatch.boss.enderdragon.DragonFlyingPhase;
import yesman.epicfight.world.capabilities.entitypatch.boss.enderdragon.EnderDragonPatch;
import yesman.epicfight.world.capabilities.entitypatch.boss.enderdragon.PatchedDragonPhase;
import yesman.epicfight.world.capabilities.entitypatch.boss.enderdragon.PatchedPhases;
import yesman.epicfight.world.entity.ai.goal.CombatBehaviors;

public class DragonGroundBattlePhase
extends PatchedDragonPhase {
    private List<Player> recognizedPlayers = Lists.newArrayList();
    private PathFinder pathFinder;
    private int aggroCounter;
    private int noPathWarningCounter;
    CombatBehaviors<EnderDragonPatch> combatBehaviors;

    public DragonGroundBattlePhase(EnderDragon dragon) {
        super(dragon);
        if (!dragon.f_19853_.m_5776_()) {
            this.combatBehaviors = MobCombatBehaviors.ENDER_DRAGON.build(this.dragonpatch);
            WalkNodeEvaluator nodeEvaluator = new WalkNodeEvaluator();
            nodeEvaluator.m_77351_(true);
            this.pathFinder = new PathFinder((NodeEvaluator)nodeEvaluator, 100);
        }
    }

    public void m_7083_() {
        this.dragonpatch.setGroundPhase();
    }

    public void m_6989_() {
        LivingEntity target = this.f_31176_.m_5448_();
        if (target != null) {
            if (DragonGroundBattlePhase.isValidTarget(target) && DragonGroundBattlePhase.isInEndSpikes(target)) {
                EntityState state = this.dragonpatch.getEntityState();
                this.combatBehaviors.tick();
                --this.aggroCounter;
                if (this.combatBehaviors.hasActivatedMove()) {
                    CombatBehaviors.Behavior<EnderDragonPatch> result;
                    if (state.canBasicAttack() && (result = this.combatBehaviors.tryProceed()) != null) {
                        result.execute(this.dragonpatch);
                    }
                } else if (!state.inaction()) {
                    CombatBehaviors.Behavior<EnderDragonPatch> result = this.combatBehaviors.selectRandomBehaviorSeries();
                    if (result != null) {
                        result.execute(this.dragonpatch);
                    } else {
                        if (this.f_31176_.f_19797_ % 20 == 0) {
                            if (!this.checkTargetPath(target)) {
                                if (this.noPathWarningCounter++ >= 3) {
                                    this.fly();
                                }
                            } else {
                                this.noPathWarningCounter = 0;
                            }
                        }
                        double dx = target.m_20185_() - this.f_31176_.m_20185_();
                        double dz = target.m_20189_() - this.f_31176_.m_20189_();
                        float yRot = 180.0f - (float)Math.toDegrees(Mth.m_14136_((double)dx, (double)dz));
                        this.f_31176_.m_146922_(MathUtils.rotlerp(this.f_31176_.m_146908_(), yRot, 6.0f));
                        Vec3 forward = this.f_31176_.m_20156_().m_82490_(-0.25);
                        this.f_31176_.m_6478_(MoverType.SELF, forward);
                    }
                } else if (this.aggroCounter < 0) {
                    this.aggroCounter = 200;
                    this.searchNearestTarget();
                }
            } else if (!this.dragonpatch.getEntityState().inaction()) {
                this.searchNearestTarget();
            }
        } else {
            this.searchNearestTarget();
            if (this.f_31176_.m_5448_() == null && !this.dragonpatch.getEntityState().inaction()) {
                this.dragonpatch.playAnimationSynchronized(Animations.DRAGON_GROUND_TO_FLY, 0.0f);
                this.f_31176_.m_31157_().m_31416_(PatchedPhases.FLYING);
                ((DragonFlyingPhase)this.f_31176_.m_31157_().m_31415_()).enableAirstrike();
            }
        }
    }

    public float m_7584_(DamageSource damagesource, float amount) {
        if (damagesource.m_19360_()) {
            if (damagesource.m_7640_() instanceof AbstractArrow) {
                damagesource.m_7640_().m_20254_(1);
            }
            return 0.0f;
        }
        if (damagesource instanceof EntityDamageSource && !(damagesource instanceof ExtendedDamageSource)) {
            return 0.0f;
        }
        return super.m_7584_(damagesource, amount);
    }

    private void refreshNearbyPlayers(double within) {
        this.recognizedPlayers.clear();
        this.recognizedPlayers.addAll(this.getPlayersNearbyWithin(within));
    }

    private boolean checkTargetPath(LivingEntity target) {
        BlockPos blockpos = this.f_31176_.m_142538_();
        while (this.f_31176_.f_19853_.m_8055_(blockpos).m_60767_().m_76334_()) {
            blockpos = blockpos.m_7494_();
        }
        while (!this.f_31176_.f_19853_.m_8055_(blockpos.m_7495_()).m_60767_().m_76334_()) {
            blockpos = blockpos.m_7495_();
        }
        int sight = 60;
        PathNavigationRegion pathnavigationregion = new PathNavigationRegion(this.f_31176_.f_19853_, blockpos.m_142082_(-sight, -sight, -sight), blockpos.m_142082_(sight, sight, sight));
        Path path = this.pathFinder.m_77427_(pathnavigationregion, (Mob)this.f_31176_, (Set)ImmutableSet.of((Object)target.m_142538_()), (float)sight, 0, 1.0f);
        BlockPos pathEnd = path.m_77375_(path.m_77398_() - 1).m_77288_();
        BlockPos targetPos = path.m_77406_();
        double xd = Math.abs(pathEnd.m_123341_() - targetPos.m_123341_());
        double yd = Math.abs(pathEnd.m_123342_() - targetPos.m_123342_());
        double zd = Math.abs(pathEnd.m_123343_() - targetPos.m_123343_());
        return xd < (double)this.f_31176_.m_20205_() && yd < (double)this.f_31176_.m_20206_() && zd < (double)this.f_31176_.m_20205_();
    }

    private void searchNearestTarget() {
        this.refreshNearbyPlayers(60.0);
        if (this.recognizedPlayers.size() > 0) {
            int nearestPlayerIndex = 0;
            double nearestDistance = this.recognizedPlayers.get(0).m_20280_((Entity)this.f_31176_);
            for (int i = 1; i < this.recognizedPlayers.size(); ++i) {
                double distance = this.recognizedPlayers.get(i).m_20280_((Entity)this.f_31176_);
                if (!(distance < nearestDistance)) continue;
                nearestPlayerIndex = i;
                nearestDistance = distance;
            }
            Player nearestPlayer = this.recognizedPlayers.get(nearestPlayerIndex);
            if (DragonGroundBattlePhase.isValidTarget((LivingEntity)nearestPlayer) && DragonGroundBattlePhase.isInEndSpikes((LivingEntity)nearestPlayer)) {
                this.dragonpatch.setAttakTargetSync((LivingEntity)nearestPlayer);
                return;
            }
        }
        this.dragonpatch.setAttakTargetSync(null);
    }

    public void fly() {
        this.combatBehaviors.execute(6);
    }

    public void resetFlyCooldown() {
        this.combatBehaviors.resetCooldown(6, false);
    }

    public boolean m_7080_() {
        return true;
    }

    public EnderDragonPhase<? extends DragonPhaseInstance> m_7309_() {
        return PatchedPhases.GROUND_BATTLE;
    }
}

