/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.world.capabilities.entitypatch.boss;

import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import yesman.epicfight.api.animation.Animator;
import yesman.epicfight.api.animation.LivingMotions;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.api.client.animation.ClientAnimator;
import yesman.epicfight.api.model.Model;
import yesman.epicfight.api.utils.ExtendedDamageSource;
import yesman.epicfight.gameasset.Animations;
import yesman.epicfight.gameasset.Models;
import yesman.epicfight.world.capabilities.entitypatch.MobPatch;
import yesman.epicfight.world.entity.WitherGhostClone;
import yesman.epicfight.world.entity.ai.attribute.EpicFightAttributes;

public class WitherGhostPatch
extends MobPatch<WitherGhostClone> {
    @Override
    public void onJoinWorld(WitherGhostClone original, EntityJoinWorldEvent event) {
        super.onJoinWorld(original, event);
        ((Animator)this.getAnimator()).playAnimation(Animations.WITHER_CHARGE, 0.0f);
        if (this.isLogicalClient()) {
            this.playSound(SoundEvents.f_12554_, -0.1f, 0.1f);
        }
    }

    @Override
    public void initAnimator(ClientAnimator clientAnimator) {
        clientAnimator.addLivingAnimation(LivingMotions.IDLE, Animations.WITHER_IDLE);
        clientAnimator.addLivingAnimation(LivingMotions.DEATH, Animations.WITHER_IDLE);
        clientAnimator.setCurrentMotionsAsDefault();
    }

    @Override
    protected void initAttributes() {
        super.initAttributes();
        ((WitherGhostClone)this.original).m_21051_((Attribute)EpicFightAttributes.IMPACT.get()).m_22100_(3.0);
    }

    @Override
    public void updateMotion(boolean considerInaction) {
        this.currentLivingMotion = LivingMotions.IDLE;
    }

    @Override
    public <M extends Model> M getEntityModel(Models<M> modelDB) {
        return (M)modelDB.wither;
    }

    @Override
    public StaticAnimation getHitAnimation(ExtendedDamageSource.StunType stunType) {
        return null;
    }
}

