/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.world.capabilities.entitypatch;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import yesman.epicfight.api.animation.Animator;
import yesman.epicfight.api.animation.LivingMotion;
import yesman.epicfight.api.animation.LivingMotions;
import yesman.epicfight.api.animation.ServerAnimator;
import yesman.epicfight.api.animation.types.EntityState;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.api.client.animation.ClientAnimator;
import yesman.epicfight.api.collider.Collider;
import yesman.epicfight.api.model.Model;
import yesman.epicfight.api.utils.AttackResult;
import yesman.epicfight.api.utils.ExtendedDamageSource;
import yesman.epicfight.api.utils.math.MathUtils;
import yesman.epicfight.api.utils.math.OpenMatrix4f;
import yesman.epicfight.gameasset.Models;
import yesman.epicfight.main.EpicFightMod;
import yesman.epicfight.network.EpicFightNetworkManager;
import yesman.epicfight.network.server.SPPlayAnimation;
import yesman.epicfight.particle.HitParticleType;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.EntityPatch;
import yesman.epicfight.world.capabilities.item.CapabilityItem;
import yesman.epicfight.world.entity.ai.attribute.EpicFightAttributeSupplier;
import yesman.epicfight.world.entity.ai.attribute.EpicFightAttributes;
import yesman.epicfight.world.entity.eventlistener.HurtEvent;

public abstract class LivingEntityPatch<T extends LivingEntity>
extends EntityPatch<T> {
    public static final EntityDataAccessor<Float> STUN_SHIELD = new EntityDataAccessor(251, EntityDataSerializers.f_135029_);
    public static final EntityDataAccessor<Float> MAX_STUN_SHIELD = new EntityDataAccessor(252, EntityDataSerializers.f_135029_);
    private float stunTimeReduction;
    protected EntityState state = EntityState.DEFAULT;
    protected Animator animator;
    public LivingMotion currentLivingMotion = LivingMotions.IDLE;
    public LivingMotion currentCompositeMotion = LivingMotions.IDLE;
    public List<LivingEntity> currentlyAttackedEntity;
    protected Vec3 lastAttackPosition;

    @Override
    public void onConstructed(T entityIn) {
        super.onConstructed(entityIn);
        this.animator = EpicFightMod.getAnimator(this);
        this.animator.init();
        this.currentlyAttackedEntity = new ArrayList<LivingEntity>();
        ((LivingEntity)this.original).m_20088_().m_135372_(STUN_SHIELD, (Object)Float.valueOf(0.0f));
        ((LivingEntity)this.original).m_20088_().m_135372_(MAX_STUN_SHIELD, (Object)Float.valueOf(0.0f));
    }

    @Override
    public void onJoinWorld(T entityIn, EntityJoinWorldEvent event) {
        super.onJoinWorld(entityIn, event);
        ((LivingEntity)this.original).m_21204_().f_22141_ = new EpicFightAttributeSupplier(((LivingEntity)this.original).m_21204_().f_22141_);
        this.initAttributes();
    }

    @OnlyIn(value=Dist.CLIENT)
    public abstract void initAnimator(ClientAnimator var1);

    public abstract void updateMotion(boolean var1);

    public abstract <M extends Model> M getEntityModel(Models<M> var1);

    protected void initAttributes() {
        ((LivingEntity)this.original).m_21051_((Attribute)EpicFightAttributes.WEIGHT.get()).m_22100_(((LivingEntity)this.original).m_21051_(Attributes.f_22276_).m_22115_() * 2.0);
        ((LivingEntity)this.original).m_21051_((Attribute)EpicFightAttributes.MAX_STRIKES.get()).m_22100_(1.0);
        ((LivingEntity)this.original).m_21051_((Attribute)EpicFightAttributes.ARMOR_NEGATION.get()).m_22100_(0.0);
        ((LivingEntity)this.original).m_21051_((Attribute)EpicFightAttributes.IMPACT.get()).m_22100_(0.5);
    }

    @Override
    protected void clientTick(LivingEvent.LivingUpdateEvent event) {
    }

    @Override
    protected void serverTick(LivingEvent.LivingUpdateEvent event) {
        if (this.stunTimeReduction > 0.0f) {
            float stunArmor = this.getStunArmor();
            this.stunTimeReduction -= 0.05f * (1.1f - this.stunTimeReduction * this.stunTimeReduction) * (1.0f - stunArmor / (7.5f + stunArmor));
            this.stunTimeReduction = Math.max(0.0f, this.stunTimeReduction);
        }
    }

    @Override
    public void tick(LivingEvent.LivingUpdateEvent event) {
        this.animator.tick();
        if (this.isLogicalClient()) {
            this.clientTick(event);
        } else {
            this.serverTick(event);
        }
        if (((LivingEntity)this.original).f_20919_ == 19) {
            this.aboutToDeath();
        }
    }

    public void onDeath() {
        ((Animator)this.getAnimator()).playDeathAnimation();
        this.currentLivingMotion = LivingMotions.DEATH;
    }

    public void updateEntityState() {
        this.state = this.animator.getEntityState();
    }

    public void cancelUsingItem() {
        ((LivingEntity)this.original).m_5810_();
        ForgeEventFactory.onUseItemStop((LivingEntity)((LivingEntity)this.original), (ItemStack)((LivingEntity)this.original).m_21211_(), (int)((LivingEntity)this.original).m_21212_());
    }

    public CapabilityItem getHoldingItemCapability(InteractionHand hand) {
        return EpicFightCapabilities.getItemStackCapability(((LivingEntity)this.original).m_21120_(hand));
    }

    public CapabilityItem getAdvancedHoldingItemCapability(InteractionHand hand) {
        if (hand == InteractionHand.MAIN_HAND) {
            return this.getHoldingItemCapability(hand);
        }
        return this.isOffhandItemValid() ? this.getHoldingItemCapability(hand) : CapabilityItem.EMPTY;
    }

    public ExtendedDamageSource getDamageSource(ExtendedDamageSource.StunType stunType, StaticAnimation animation, InteractionHand hand) {
        return ExtendedDamageSource.causeMobDamage((LivingEntity)this.original, stunType, animation);
    }

    public float getDamageTo(@Nullable Entity targetEntity, @Nullable ExtendedDamageSource source, InteractionHand hand) {
        float damage = 0.0f;
        damage = hand == InteractionHand.MAIN_HAND ? (float)((LivingEntity)this.original).m_21133_(Attributes.f_22281_) : (this.isOffhandItemValid() ? (float)((LivingEntity)this.original).m_21133_((Attribute)EpicFightAttributes.OFFHAND_ATTACK_DAMAGE.get()) : (float)((LivingEntity)this.original).m_21051_(Attributes.f_22281_).m_22115_());
        return damage += EnchantmentHelper.m_44833_((ItemStack)this.getValidItemInHand(hand), (MobType)(targetEntity instanceof LivingEntity ? ((LivingEntity)targetEntity).m_6336_() : MobType.f_21640_));
    }

    public AttackResult tryHurt(DamageSource damageSource, float amount) {
        if (this.getEntityState().invulnerableTo(damageSource)) {
            return new AttackResult(AttackResult.ResultType.FAILED, amount);
        }
        return new AttackResult(AttackResult.ResultType.SUCCESS, amount);
    }

    public AttackResult tryHarm(Entity target, ExtendedDamageSource damagesource, float amount) {
        LivingEntityPatch entitypatch = (LivingEntityPatch)target.getCapability(EpicFightCapabilities.CAPABILITY_ENTITY).orElse(null);
        AttackResult result = entitypatch != null ? entitypatch.tryHurt((DamageSource)damagesource, amount) : new AttackResult(AttackResult.ResultType.SUCCESS, amount);
        return result;
    }

    public void onHurtSomeone(Entity target, InteractionHand handIn, ExtendedDamageSource damagesource, float amount, boolean succeed) {
        int j = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44981_, (ItemStack)this.getValidItemInHand(handIn));
        if (target instanceof LivingEntity) {
            ((LivingEntity)this.getOriginal()).m_19970_((LivingEntity)this.getOriginal(), target);
            if (j > 0 && !target.m_6060_()) {
                target.m_20254_(j * 4);
            }
        }
    }

    public boolean onDrop(LivingDropsEvent event) {
        return false;
    }

    public void gatherDamageDealt(ExtendedDamageSource source, float amount) {
    }

    public void setStunReductionOnHit() {
        this.stunTimeReduction += Math.max((1.0f - this.stunTimeReduction) * 0.8f, 0.5f);
        this.stunTimeReduction = Math.min(1.0f, this.stunTimeReduction);
    }

    public float getStunTimeTimeReduction() {
        return this.stunTimeReduction;
    }

    public void knockBackEntity(Vec3 sourceLocation, float power) {
        double d1 = sourceLocation.m_7096_() - ((LivingEntity)this.original).m_20185_();
        double d0 = sourceLocation.m_7094_() - ((LivingEntity)this.original).m_20189_();
        while (d1 * d1 + d0 * d0 < 1.0E-4) {
            d1 = (Math.random() - Math.random()) * 0.01;
            d0 = (Math.random() - Math.random()) * 0.01;
        }
        if (((LivingEntity)this.original).m_21187_().nextDouble() >= ((LivingEntity)this.original).m_21133_(Attributes.f_22278_)) {
            Vec3 vec = ((LivingEntity)this.original).m_20184_();
            ((LivingEntity)this.original).f_19812_ = true;
            float f = (float)Math.sqrt(d1 * d1 + d0 * d0);
            double x = vec.f_82479_;
            double y = vec.f_82480_;
            double z = vec.f_82481_;
            x /= 2.0;
            z /= 2.0;
            x -= d1 / (double)f * (double)power;
            z -= d0 / (double)f * (double)power;
            if (!((LivingEntity)this.original).m_20096_()) {
                y /= 2.0;
                if ((y += (double)power) > (double)0.4f) {
                    y = 0.4f;
                }
            }
            ((LivingEntity)this.original).m_20334_(x, y, z);
            ((LivingEntity)this.original).f_19864_ = true;
        }
    }

    public float getStunArmor() {
        AttributeInstance stunArmor = ((LivingEntity)this.original).m_21051_((Attribute)EpicFightAttributes.STUN_ARMOR.get());
        return (float)(stunArmor == null ? 0.0 : stunArmor.m_22135_());
    }

    public float getStunShield() {
        return ((Float)((LivingEntity)this.original).m_20088_().m_135370_(STUN_SHIELD)).floatValue();
    }

    public void setStunShield(float value) {
        value = Math.max(value, 0.0f);
        ((LivingEntity)this.original).m_20088_().m_135381_(STUN_SHIELD, (Object)Float.valueOf(value));
    }

    public float getMaxStunShield() {
        return ((Float)((LivingEntity)this.original).m_20088_().m_135370_(MAX_STUN_SHIELD)).floatValue();
    }

    public void setMaxStunShield(float value) {
        value = Math.max(value, 0.0f);
        ((LivingEntity)this.original).m_20088_().m_135381_(MAX_STUN_SHIELD, (Object)Float.valueOf(value));
    }

    public float getWeight() {
        return (float)((LivingEntity)this.original).m_21133_((Attribute)EpicFightAttributes.WEIGHT.get());
    }

    public void rotateTo(float degree, float limit, boolean synchronizeOld) {
        float amount;
        LivingEntity entity = (LivingEntity)this.getOriginal();
        for (amount = degree - entity.m_146908_(); amount < -180.0f; amount += 360.0f) {
        }
        while (amount > 180.0f) {
            amount -= 360.0f;
        }
        amount = Mth.m_14036_((float)amount, (float)(-limit), (float)limit);
        float f1 = entity.m_146908_() + amount;
        if (synchronizeOld) {
            entity.f_19859_ = f1;
            entity.f_20886_ = f1;
            entity.f_20884_ = f1;
        }
        entity.m_146922_(f1);
        entity.f_20885_ = f1;
        entity.f_20883_ = f1;
    }

    public void rotateTo(Entity target, float limit, boolean partialSync) {
        double d0 = target.m_20185_() - ((LivingEntity)this.original).m_20185_();
        double d1 = target.m_20189_() - ((LivingEntity)this.original).m_20189_();
        float degree = -((float)Math.toDegrees(Mth.m_14136_((double)d0, (double)d1)));
        this.rotateTo(degree, limit, partialSync);
    }

    public void playSound(SoundEvent sound, float pitchModifierMin, float pitchModifierMax) {
        this.playSound(sound, 1.0f, pitchModifierMin, pitchModifierMax);
    }

    public void playSound(SoundEvent sound, float volume, float pitchModifierMin, float pitchModifierMax) {
        float pitch = (((LivingEntity)this.original).m_21187_().nextFloat() * 2.0f - 1.0f) * (pitchModifierMax - pitchModifierMin);
        if (!this.isLogicalClient()) {
            ((LivingEntity)this.original).f_19853_.m_6263_(null, ((LivingEntity)this.original).m_20185_(), ((LivingEntity)this.original).m_20186_(), ((LivingEntity)this.original).m_20189_(), sound, ((LivingEntity)this.original).m_5720_(), volume, 1.0f + pitch);
        } else {
            ((LivingEntity)this.original).f_19853_.m_7785_(((LivingEntity)this.original).m_20185_(), ((LivingEntity)this.original).m_20186_(), ((LivingEntity)this.original).m_20189_(), sound, ((LivingEntity)this.original).m_5720_(), volume, 1.0f + pitch, false);
        }
    }

    public LivingEntity getTarget() {
        return ((LivingEntity)this.original).m_21214_();
    }

    public float getAttackDirectionPitch() {
        float partialTicks = EpicFightMod.isPhysicalClient() ? Minecraft.m_91087_().m_91296_() : 1.0f;
        float pitch = -((LivingEntity)this.getOriginal()).m_5686_(partialTicks);
        float correct = pitch > 0.0f ? 0.03333f * (float)Math.pow(pitch, 2.0) : -0.03333f * (float)Math.pow(pitch, 2.0);
        return Mth.m_14036_((float)correct, (float)-30.0f, (float)30.0f);
    }

    @OnlyIn(value=Dist.CLIENT)
    public OpenMatrix4f getHeadMatrix(float partialTicks) {
        float f2;
        if (this.state.inaction()) {
            f2 = 0.0f;
        } else {
            float f = MathUtils.lerpBetween(((LivingEntity)this.original).f_20884_, ((LivingEntity)this.original).f_20883_, partialTicks);
            float f1 = MathUtils.lerpBetween(((LivingEntity)this.original).f_20886_, ((LivingEntity)this.original).f_20885_, partialTicks);
            f2 = f1 - f;
            if (((LivingEntity)this.original).m_20202_() != null) {
                if (f2 > 45.0f) {
                    f2 = 45.0f;
                } else if (f2 < -45.0f) {
                    f2 = -45.0f;
                }
            }
        }
        return MathUtils.getModelMatrixIntegral(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, ((LivingEntity)this.original).f_19860_, ((LivingEntity)this.original).m_146909_(), f2, f2, partialTicks, 1.0f, 1.0f, 1.0f);
    }

    @Override
    public OpenMatrix4f getModelMatrix(float partialTicks) {
        float yRot;
        float prevYRot;
        float scale;
        float f = scale = ((LivingEntity)this.original).m_6162_() ? 0.5f : 1.0f;
        if (((LivingEntity)this.original).m_20202_() instanceof LivingEntity) {
            LivingEntity ridingEntity = (LivingEntity)((LivingEntity)this.original).m_20202_();
            prevYRot = ridingEntity.f_20884_;
            yRot = ridingEntity.f_20883_;
        } else {
            prevYRot = this.isLogicalClient() ? ((LivingEntity)this.original).f_20884_ : ((LivingEntity)this.original).m_146908_();
            yRot = this.isLogicalClient() ? ((LivingEntity)this.original).f_20883_ : ((LivingEntity)this.original).m_146908_();
        }
        return MathUtils.getModelMatrixIntegral(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, prevYRot, yRot, partialTicks, scale, scale, scale);
    }

    public void reserveAnimation(StaticAnimation animation) {
        this.animator.reserveAnimation(animation);
        EpicFightNetworkManager.sendToAllPlayerTrackingThisEntity(new SPPlayAnimation(animation, ((LivingEntity)this.original).m_142049_(), 0.0f), this.original);
    }

    public void playAnimationSynchronized(StaticAnimation animation, float convertTimeModifier) {
        this.playAnimationSynchronized(animation, convertTimeModifier, SPPlayAnimation::new);
    }

    public void playAnimationSynchronized(StaticAnimation animation, float convertTimeModifier, AnimationPacketProvider packetProvider) {
        this.animator.playAnimation(animation, convertTimeModifier);
        EpicFightNetworkManager.sendToAllPlayerTrackingThisEntity(packetProvider.get(animation, convertTimeModifier, this), this.original);
    }

    protected void playReboundAnimation() {
        this.getClientAnimator().playReboundAnimation();
    }

    public void resetSize(EntityDimensions size) {
        EntityDimensions entitysize1;
        EntityDimensions entitysize = ((LivingEntity)this.original).f_19815_;
        ((LivingEntity)this.original).f_19815_ = entitysize1 = size;
        if (entitysize1.f_20377_ < entitysize.f_20377_) {
            double d0 = (double)entitysize1.f_20377_ / 2.0;
            ((LivingEntity)this.original).m_20011_(new AABB(((LivingEntity)this.original).m_20185_() - d0, ((LivingEntity)this.original).m_20186_(), ((LivingEntity)this.original).m_20189_() - d0, ((LivingEntity)this.original).m_20185_() + d0, ((LivingEntity)this.original).m_20186_() + (double)entitysize1.f_20378_, ((LivingEntity)this.original).m_20189_() + d0));
        } else {
            AABB axisalignedbb = ((LivingEntity)this.original).m_142469_();
            ((LivingEntity)this.original).m_20011_(new AABB(axisalignedbb.f_82288_, axisalignedbb.f_82289_, axisalignedbb.f_82290_, axisalignedbb.f_82288_ + (double)entitysize1.f_20377_, axisalignedbb.f_82289_ + (double)entitysize1.f_20378_, axisalignedbb.f_82290_ + (double)entitysize1.f_20377_));
            if (entitysize1.f_20377_ > entitysize.f_20377_ && !((LivingEntity)this.original).f_19853_.m_5776_()) {
                float f = entitysize.f_20377_ - entitysize1.f_20377_;
                ((LivingEntity)this.original).m_6478_(MoverType.SELF, new Vec3((double)f, 0.0, (double)f));
            }
        }
    }

    public void updateHeldItem(CapabilityItem fromCap, CapabilityItem toCap, ItemStack from, ItemStack to, InteractionHand hand) {
    }

    public void updateArmor(CapabilityItem fromCap, CapabilityItem toCap, EquipmentSlot slotType) {
    }

    public void onAttackBlocked(HurtEvent.Pre hurtEvent, LivingEntityPatch<?> opponent) {
    }

    public void onMount(boolean isMountOrDismount, Entity ridingEntity) {
    }

    public <A extends Animator> A getAnimator() {
        return (A)this.animator;
    }

    public ClientAnimator getClientAnimator() {
        return (ClientAnimator)this.getAnimator();
    }

    public ServerAnimator getServerAnimator() {
        return (ServerAnimator)this.getAnimator();
    }

    public abstract StaticAnimation getHitAnimation(ExtendedDamageSource.StunType var1);

    public void aboutToDeath() {
    }

    public SoundEvent getWeaponHitSound(InteractionHand hand) {
        return this.getAdvancedHoldingItemCapability(hand).getHitSound();
    }

    public SoundEvent getSwingSound(InteractionHand hand) {
        return this.getAdvancedHoldingItemCapability(hand).getSmashingSound();
    }

    public HitParticleType getWeaponHitParticle(InteractionHand hand) {
        return this.getAdvancedHoldingItemCapability(hand).getHitParticle();
    }

    public Collider getColliderMatching(InteractionHand hand) {
        return this.getAdvancedHoldingItemCapability(hand).getWeaponCollider();
    }

    public int getMaxStrikes(InteractionHand hand) {
        return (int)(hand == InteractionHand.MAIN_HAND ? ((LivingEntity)this.original).m_21133_((Attribute)EpicFightAttributes.MAX_STRIKES.get()) : (this.isOffhandItemValid() ? ((LivingEntity)this.original).m_21133_((Attribute)EpicFightAttributes.OFFHAND_MAX_STRIKES.get()) : ((LivingEntity)this.original).m_21051_((Attribute)EpicFightAttributes.MAX_STRIKES.get()).m_22115_()));
    }

    public float getArmorNegation(InteractionHand hand) {
        return (float)(hand == InteractionHand.MAIN_HAND ? ((LivingEntity)this.original).m_21133_((Attribute)EpicFightAttributes.ARMOR_NEGATION.get()) : (this.isOffhandItemValid() ? ((LivingEntity)this.original).m_21133_((Attribute)EpicFightAttributes.OFFHAND_ARMOR_NEGATION.get()) : ((LivingEntity)this.original).m_21051_((Attribute)EpicFightAttributes.ARMOR_NEGATION.get()).m_22115_()));
    }

    public float getImpact(InteractionHand hand) {
        float impact;
        int i = 0;
        if (hand == InteractionHand.MAIN_HAND) {
            impact = (float)((LivingEntity)this.original).m_21133_((Attribute)EpicFightAttributes.IMPACT.get());
            i = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44980_, (ItemStack)((LivingEntity)this.getOriginal()).m_21205_());
        } else if (this.isOffhandItemValid()) {
            impact = (float)((LivingEntity)this.original).m_21133_((Attribute)EpicFightAttributes.OFFHAND_IMPACT.get());
            i = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44980_, (ItemStack)((LivingEntity)this.getOriginal()).m_21206_());
        } else {
            impact = (float)((LivingEntity)this.original).m_21051_((Attribute)EpicFightAttributes.IMPACT.get()).m_22115_();
        }
        return impact * (1.0f + (float)i * 0.12f);
    }

    public ItemStack getValidItemInHand(InteractionHand hand) {
        if (hand == InteractionHand.MAIN_HAND) {
            return ((LivingEntity)this.original).m_21120_(hand);
        }
        return this.isOffhandItemValid() ? ((LivingEntity)this.original).m_21120_(hand) : ItemStack.f_41583_;
    }

    public boolean isOffhandItemValid() {
        return this.getHoldingItemCapability(InteractionHand.MAIN_HAND).checkOffhandValid(this);
    }

    public boolean isTeammate(Entity entityIn) {
        if (((LivingEntity)this.original).m_20202_() != null && ((LivingEntity)this.original).m_20202_().equals((Object)entityIn)) {
            return true;
        }
        if (this.isRideOrBeingRidden(entityIn)) {
            return true;
        }
        return ((LivingEntity)this.original).m_7307_(entityIn) && ((LivingEntity)this.original).m_5647_() != null && !((LivingEntity)this.original).m_5647_().m_6260_();
    }

    public Vec3 getLastAttackPosition() {
        return this.lastAttackPosition;
    }

    public void setLastAttackPosition() {
        this.lastAttackPosition = ((LivingEntity)this.original).m_20182_();
    }

    private boolean isRideOrBeingRidden(Entity entityIn) {
        LivingEntity orgEntity = (LivingEntity)this.getOriginal();
        for (Entity passanger : orgEntity.m_20197_()) {
            if (!passanger.equals((Object)entityIn)) continue;
            return true;
        }
        for (Entity passanger : entityIn.m_20197_()) {
            if (!passanger.equals((Object)orgEntity)) continue;
            return true;
        }
        return false;
    }

    public boolean isFirstPerson() {
        return false;
    }

    public boolean shouldSkipRender() {
        return false;
    }

    public boolean shouldBlockMoving() {
        return false;
    }

    public float getYRotLimit() {
        return 20.0f;
    }

    public EntityState getEntityState() {
        return this.state;
    }

    public LivingMotion getCurrentLivingMotion() {
        return this.currentLivingMotion;
    }

    @FunctionalInterface
    public static interface AnimationPacketProvider {
        public SPPlayAnimation get(StaticAnimation var1, float var2, LivingEntityPatch<?> var3);
    }
}

