/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.world.capabilities.entitypatch;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.datafixers.util.Pair;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.GoalSelector;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.TridentItem;
import yesman.epicfight.api.animation.Animator;
import yesman.epicfight.api.animation.LivingMotion;
import yesman.epicfight.api.animation.LivingMotions;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.api.client.animation.ClientAnimator;
import yesman.epicfight.api.utils.ExtendedDamageSource;
import yesman.epicfight.gameasset.Animations;
import yesman.epicfight.gameasset.MobCombatBehaviors;
import yesman.epicfight.network.EpicFightNetworkManager;
import yesman.epicfight.network.server.SPChangeLivingMotion;
import yesman.epicfight.world.capabilities.entitypatch.Faction;
import yesman.epicfight.world.capabilities.entitypatch.MobPatch;
import yesman.epicfight.world.capabilities.item.CapabilityItem;
import yesman.epicfight.world.capabilities.item.Style;
import yesman.epicfight.world.capabilities.item.WeaponCategory;
import yesman.epicfight.world.entity.ai.attribute.EpicFightAttributes;
import yesman.epicfight.world.entity.ai.goal.AnimatedAttackGoal;
import yesman.epicfight.world.entity.ai.goal.CombatBehaviors;
import yesman.epicfight.world.entity.ai.goal.TargetChasingGoal;

public abstract class HumanoidMobPatch<T extends PathfinderMob>
extends MobPatch<T> {
    protected Map<WeaponCategory, Map<Style, Set<Pair<LivingMotion, StaticAnimation>>>> weaponLivingMotions;
    protected Map<WeaponCategory, Map<Style, CombatBehaviors.Builder<HumanoidMobPatch<?>>>> weaponAttackMotions;

    public HumanoidMobPatch(Faction faction) {
        super(faction);
        this.setWeaponMotions();
    }

    @Override
    protected void initAI() {
        super.initAI();
        if (((PathfinderMob)this.original).m_20202_() != null && ((PathfinderMob)this.original).m_20202_() instanceof Mob) {
            this.setAIAsMounted(((PathfinderMob)this.original).m_20202_());
        } else {
            this.setAIAsInfantry(((PathfinderMob)this.original).m_21205_().m_41720_() instanceof ProjectileWeaponItem);
        }
    }

    @Override
    public void onStartTracking(ServerPlayer trackingPlayer) {
        this.modifyLivingMotionByCurrentItem();
    }

    protected void setWeaponMotions() {
        this.weaponLivingMotions = Maps.newHashMap();
        this.weaponLivingMotions.put(CapabilityItem.WeaponCategories.GREATSWORD, (Map<Style, Set<Pair<LivingMotion, StaticAnimation>>>)ImmutableMap.of((Object)CapabilityItem.Styles.TWO_HAND, Set.of(Pair.of((Object)LivingMotions.WALK, (Object)Animations.BIPED_WALK_TWOHAND), Pair.of((Object)LivingMotions.CHASE, (Object)Animations.BIPED_WALK_TWOHAND))));
        this.weaponAttackMotions = Maps.newHashMap();
        this.weaponAttackMotions.put(CapabilityItem.WeaponCategories.AXE, (Map<Style, CombatBehaviors.Builder<HumanoidMobPatch<?>>>)ImmutableMap.of((Object)CapabilityItem.Styles.COMMON, MobCombatBehaviors.HUMANOID_ONEHAND_TOOLS));
        this.weaponAttackMotions.put(CapabilityItem.WeaponCategories.HOE, (Map<Style, CombatBehaviors.Builder<HumanoidMobPatch<?>>>)ImmutableMap.of((Object)CapabilityItem.Styles.COMMON, MobCombatBehaviors.HUMANOID_ONEHAND_TOOLS));
        this.weaponAttackMotions.put(CapabilityItem.WeaponCategories.PICKAXE, (Map<Style, CombatBehaviors.Builder<HumanoidMobPatch<?>>>)ImmutableMap.of((Object)CapabilityItem.Styles.COMMON, MobCombatBehaviors.HUMANOID_ONEHAND_TOOLS));
        this.weaponAttackMotions.put(CapabilityItem.WeaponCategories.SHOVEL, (Map<Style, CombatBehaviors.Builder<HumanoidMobPatch<?>>>)ImmutableMap.of((Object)CapabilityItem.Styles.COMMON, MobCombatBehaviors.HUMANOID_ONEHAND_TOOLS));
        this.weaponAttackMotions.put(CapabilityItem.WeaponCategories.SWORD, (Map<Style, CombatBehaviors.Builder<HumanoidMobPatch<?>>>)ImmutableMap.of((Object)CapabilityItem.Styles.ONE_HAND, MobCombatBehaviors.HUMANOID_ONEHAND_TOOLS, (Object)CapabilityItem.Styles.TWO_HAND, MobCombatBehaviors.HUMANOID_DUAL_SWORD));
        this.weaponAttackMotions.put(CapabilityItem.WeaponCategories.GREATSWORD, (Map<Style, CombatBehaviors.Builder<HumanoidMobPatch<?>>>)ImmutableMap.of((Object)CapabilityItem.Styles.TWO_HAND, MobCombatBehaviors.HUMANOID_GREATSWORD));
        this.weaponAttackMotions.put(CapabilityItem.WeaponCategories.KATANA, (Map<Style, CombatBehaviors.Builder<HumanoidMobPatch<?>>>)ImmutableMap.of((Object)CapabilityItem.Styles.TWO_HAND, MobCombatBehaviors.HUMANOID_KATANA));
        this.weaponAttackMotions.put(CapabilityItem.WeaponCategories.LONGSWORD, (Map<Style, CombatBehaviors.Builder<HumanoidMobPatch<?>>>)ImmutableMap.of((Object)CapabilityItem.Styles.TWO_HAND, MobCombatBehaviors.HUMANOID_LONGSWORD));
        this.weaponAttackMotions.put(CapabilityItem.WeaponCategories.TACHI, (Map<Style, CombatBehaviors.Builder<HumanoidMobPatch<?>>>)ImmutableMap.of((Object)CapabilityItem.Styles.TWO_HAND, MobCombatBehaviors.HUMANOID_TACHI));
        this.weaponAttackMotions.put(CapabilityItem.WeaponCategories.SPEAR, (Map<Style, CombatBehaviors.Builder<HumanoidMobPatch<?>>>)ImmutableMap.of((Object)CapabilityItem.Styles.ONE_HAND, MobCombatBehaviors.HUMANOID_SPEAR_ONEHAND, (Object)CapabilityItem.Styles.TWO_HAND, MobCombatBehaviors.HUMANOID_SPEAR_TWOHAND));
        this.weaponAttackMotions.put(CapabilityItem.WeaponCategories.FIST, (Map<Style, CombatBehaviors.Builder<HumanoidMobPatch<?>>>)ImmutableMap.of((Object)CapabilityItem.Styles.COMMON, MobCombatBehaviors.HUMANOID_FIST));
        this.weaponAttackMotions.put(CapabilityItem.WeaponCategories.DAGGER, (Map<Style, CombatBehaviors.Builder<HumanoidMobPatch<?>>>)ImmutableMap.of((Object)CapabilityItem.Styles.ONE_HAND, MobCombatBehaviors.HUMANOID_ONEHAND_DAGGER, (Object)CapabilityItem.Styles.TWO_HAND, MobCombatBehaviors.HUMANOID_TWOHAND_DAGGER));
        this.weaponAttackMotions.put(CapabilityItem.WeaponCategories.RANGED, (Map<Style, CombatBehaviors.Builder<HumanoidMobPatch<?>>>)ImmutableMap.of((Object)CapabilityItem.Styles.COMMON, MobCombatBehaviors.HUMANOID_FIST));
        this.weaponAttackMotions.put(CapabilityItem.WeaponCategories.TRIDENT, (Map<Style, CombatBehaviors.Builder<HumanoidMobPatch<?>>>)ImmutableMap.of((Object)CapabilityItem.Styles.COMMON, MobCombatBehaviors.HUMANOID_SPEAR_ONEHAND));
    }

    protected CombatBehaviors.Builder<HumanoidMobPatch<?>> getHoldingItemWeaponMotionBuilder() {
        Style style;
        Map<Style, CombatBehaviors.Builder<HumanoidMobPatch<?>>> motionByStyle;
        CapabilityItem itemCap = this.getHoldingItemCapability(InteractionHand.MAIN_HAND);
        if (this.weaponAttackMotions.containsKey(itemCap.getWeaponCategory()) && ((motionByStyle = this.weaponAttackMotions.get(itemCap.getWeaponCategory())).containsKey(style = itemCap.getStyle(this)) || motionByStyle.containsKey(CapabilityItem.Styles.COMMON))) {
            return motionByStyle.getOrDefault(style, motionByStyle.get(CapabilityItem.Styles.COMMON));
        }
        return null;
    }

    public void setAIAsInfantry(boolean holdingRanedWeapon) {
        CombatBehaviors.Builder<HumanoidMobPatch<?>> builder = this.getHoldingItemWeaponMotionBuilder();
        if (builder != null) {
            ((PathfinderMob)this.original).f_21345_.m_25352_(0, new AnimatedAttackGoal<HumanoidMobPatch>(this, builder.build(this)));
            ((PathfinderMob)this.original).f_21345_.m_25352_(1, (Goal)new TargetChasingGoal(this, (PathfinderMob)this.getOriginal(), 1.0, true));
        }
    }

    public void setAIAsMounted(Entity ridingEntity) {
        if (this.isArmed() && ridingEntity instanceof AbstractHorse) {
            ((PathfinderMob)this.original).f_21345_.m_25352_(0, new AnimatedAttackGoal<HumanoidMobPatch>(this, MobCombatBehaviors.MOUNT_HUMANOID_BEHAVIORS.build(this)));
            ((PathfinderMob)this.original).f_21345_.m_25352_(1, (Goal)new TargetChasingGoal(this, (PathfinderMob)this.getOriginal(), 1.0, true));
        }
    }

    protected final void commonMobAnimatorInit(ClientAnimator clientAnimator) {
        clientAnimator.addLivingAnimation(LivingMotions.IDLE, Animations.BIPED_IDLE);
        clientAnimator.addLivingAnimation(LivingMotions.WALK, Animations.BIPED_WALK);
        clientAnimator.addLivingAnimation(LivingMotions.FALL, Animations.BIPED_FALL);
        clientAnimator.addLivingAnimation(LivingMotions.MOUNT, Animations.BIPED_MOUNT);
        clientAnimator.addLivingAnimation(LivingMotions.DEATH, Animations.BIPED_DEATH);
        clientAnimator.setCurrentMotionsAsDefault();
    }

    protected final void commonAggresiveMobAnimatorInit(ClientAnimator clientAnimator) {
        clientAnimator.addLivingAnimation(LivingMotions.IDLE, Animations.BIPED_IDLE);
        clientAnimator.addLivingAnimation(LivingMotions.WALK, Animations.BIPED_WALK);
        clientAnimator.addLivingAnimation(LivingMotions.CHASE, Animations.BIPED_WALK);
        clientAnimator.addLivingAnimation(LivingMotions.FALL, Animations.BIPED_FALL);
        clientAnimator.addLivingAnimation(LivingMotions.MOUNT, Animations.BIPED_MOUNT);
        clientAnimator.addLivingAnimation(LivingMotions.DEATH, Animations.BIPED_DEATH);
        clientAnimator.setCurrentMotionsAsDefault();
    }

    @Override
    public void updateHeldItem(CapabilityItem fromCap, CapabilityItem toCap, ItemStack from, ItemStack to, InteractionHand hand) {
        this.initAI();
        if (hand == InteractionHand.OFF_HAND) {
            if (!from.m_41619_()) {
                from.m_41638_(EquipmentSlot.MAINHAND).get((Object)Attributes.f_22281_).forEach(arg_0 -> ((AttributeInstance)((PathfinderMob)this.original).m_21051_((Attribute)EpicFightAttributes.OFFHAND_ATTACK_DAMAGE.get())).m_22130_(arg_0));
                from.m_41638_(EquipmentSlot.MAINHAND).get((Object)Attributes.f_22283_).forEach(arg_0 -> ((AttributeInstance)((PathfinderMob)this.original).m_21051_((Attribute)EpicFightAttributes.OFFHAND_ATTACK_SPEED.get())).m_22130_(arg_0));
            }
            if (!fromCap.isEmpty()) {
                fromCap.getAttributeModifiers(EquipmentSlot.MAINHAND, this).get((Object)((Attribute)EpicFightAttributes.ARMOR_NEGATION.get())).forEach(arg_0 -> ((AttributeInstance)((PathfinderMob)this.original).m_21051_((Attribute)EpicFightAttributes.OFFHAND_ARMOR_NEGATION.get())).m_22130_(arg_0));
                fromCap.getAttributeModifiers(EquipmentSlot.MAINHAND, this).get((Object)((Attribute)EpicFightAttributes.IMPACT.get())).forEach(arg_0 -> ((AttributeInstance)((PathfinderMob)this.original).m_21051_((Attribute)EpicFightAttributes.OFFHAND_IMPACT.get())).m_22130_(arg_0));
                fromCap.getAttributeModifiers(EquipmentSlot.MAINHAND, this).get((Object)((Attribute)EpicFightAttributes.MAX_STRIKES.get())).forEach(arg_0 -> ((AttributeInstance)((PathfinderMob)this.original).m_21051_((Attribute)EpicFightAttributes.OFFHAND_MAX_STRIKES.get())).m_22130_(arg_0));
            }
            if (!to.m_41619_()) {
                to.m_41638_(EquipmentSlot.MAINHAND).get((Object)Attributes.f_22281_).forEach(arg_0 -> ((AttributeInstance)((PathfinderMob)this.original).m_21051_((Attribute)EpicFightAttributes.OFFHAND_ATTACK_DAMAGE.get())).m_22118_(arg_0));
                to.m_41638_(EquipmentSlot.MAINHAND).get((Object)Attributes.f_22283_).forEach(arg_0 -> ((AttributeInstance)((PathfinderMob)this.original).m_21051_((Attribute)EpicFightAttributes.OFFHAND_ATTACK_SPEED.get())).m_22118_(arg_0));
            }
            if (!toCap.isEmpty()) {
                toCap.getAttributeModifiers(EquipmentSlot.MAINHAND, this).get((Object)((Attribute)EpicFightAttributes.ARMOR_NEGATION.get())).forEach(arg_0 -> ((AttributeInstance)((PathfinderMob)this.original).m_21051_((Attribute)EpicFightAttributes.OFFHAND_ARMOR_NEGATION.get())).m_22118_(arg_0));
                toCap.getAttributeModifiers(EquipmentSlot.MAINHAND, this).get((Object)((Attribute)EpicFightAttributes.IMPACT.get())).forEach(arg_0 -> ((AttributeInstance)((PathfinderMob)this.original).m_21051_((Attribute)EpicFightAttributes.OFFHAND_IMPACT.get())).m_22118_(arg_0));
                toCap.getAttributeModifiers(EquipmentSlot.MAINHAND, this).get((Object)((Attribute)EpicFightAttributes.MAX_STRIKES.get())).forEach(arg_0 -> ((AttributeInstance)((PathfinderMob)this.original).m_21051_((Attribute)EpicFightAttributes.OFFHAND_MAX_STRIKES.get())).m_22118_(arg_0));
            }
        }
        this.modifyLivingMotionByCurrentItem();
    }

    public void modifyLivingMotionByCurrentItem() {
        Style style;
        Map<Style, Set<Pair<LivingMotion, StaticAnimation>>> mapByStyle;
        ((Animator)this.getAnimator()).resetMotions();
        CapabilityItem mainhandCap = this.getHoldingItemCapability(InteractionHand.MAIN_HAND);
        CapabilityItem offhandCap = this.getAdvancedHoldingItemCapability(InteractionHand.OFF_HAND);
        HashMap motionModifier = Maps.newHashMap();
        offhandCap.getLivingMotionModifier(this, InteractionHand.OFF_HAND).forEach(motionModifier::put);
        mainhandCap.getLivingMotionModifier(this, InteractionHand.MAIN_HAND).forEach(motionModifier::put);
        for (Map.Entry entry : motionModifier.entrySet()) {
            ((Animator)this.getAnimator()).addLivingAnimation((LivingMotion)entry.getKey(), (StaticAnimation)entry.getValue());
        }
        if (this.weaponLivingMotions != null && this.weaponLivingMotions.containsKey(mainhandCap.getWeaponCategory()) && ((mapByStyle = this.weaponLivingMotions.get(mainhandCap.getWeaponCategory())).containsKey(style = mainhandCap.getStyle(this)) || mapByStyle.containsKey(CapabilityItem.Styles.COMMON))) {
            Set<Pair<LivingMotion, StaticAnimation>> animModifierSet = mapByStyle.getOrDefault(style, mapByStyle.get(CapabilityItem.Styles.COMMON));
            for (Pair<LivingMotion, StaticAnimation> pair : animModifierSet) {
                this.animator.addLivingAnimation((LivingMotion)pair.getFirst(), (StaticAnimation)pair.getSecond());
            }
        }
        SPChangeLivingMotion msg = new SPChangeLivingMotion(((PathfinderMob)this.original).m_142049_());
        msg.putEntries(((Animator)this.getAnimator()).getLivingAnimationEntrySet());
        EpicFightNetworkManager.sendToAllPlayerTrackingThisEntity(msg, this.original);
    }

    public boolean isArmed() {
        Item heldItem = ((PathfinderMob)this.original).m_21205_().m_41720_();
        return heldItem instanceof SwordItem || heldItem instanceof DiggerItem || heldItem instanceof TridentItem;
    }

    @Override
    public void onMount(boolean isMountOrDismount, Entity ridingEntity) {
        if (this.original == null) {
            return;
        }
        if (!((PathfinderMob)this.original).f_19853_.m_5776_() && !((PathfinderMob)this.original).m_21525_()) {
            HashSet toRemove = Sets.newHashSet();
            this.selectGoalToRemove(toRemove);
            toRemove.forEach(arg_0 -> ((GoalSelector)((PathfinderMob)this.original).f_21345_).m_25363_(arg_0));
            if (isMountOrDismount) {
                this.setAIAsMounted(ridingEntity);
            } else {
                this.setAIAsInfantry(((PathfinderMob)this.original).m_21205_().m_41720_() instanceof ProjectileWeaponItem);
            }
        }
    }

    @Override
    public StaticAnimation getHitAnimation(ExtendedDamageSource.StunType stunType) {
        if (((PathfinderMob)this.original).m_20202_() != null) {
            return Animations.BIPED_HIT_ON_MOUNT;
        }
        switch (stunType) {
            case LONG: {
                return Animations.BIPED_HIT_LONG;
            }
            case SHORT: {
                return Animations.BIPED_HIT_SHORT;
            }
            case HOLD: {
                return Animations.BIPED_HIT_SHORT;
            }
            case KNOCKDOWN: {
                return Animations.BIPED_KNOCKDOWN;
            }
            case FALL: {
                return Animations.BIPED_LANDING;
            }
            case NONE: {
                return null;
            }
        }
        return null;
    }
}

