/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.skill;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import yesman.epicfight.api.utils.AttackResult;
import yesman.epicfight.api.utils.ExtendedDamageSource;
import yesman.epicfight.gameasset.Animations;
import yesman.epicfight.gameasset.Skills;
import yesman.epicfight.skill.GuardSkill;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.capabilities.item.CapabilityItem;
import yesman.epicfight.world.entity.eventlistener.HurtEvent;

public class EnergizingGuardSkill
extends GuardSkill {
    public static GuardSkill.Builder createBuilder(ResourceLocation resourceLocation) {
        return GuardSkill.createBuilder(resourceLocation).addAdvancedGuardMotion(CapabilityItem.WeaponCategories.LONGSWORD, (item, player) -> Animations.LONGSWORD_GUARD_HIT).addAdvancedGuardMotion(CapabilityItem.WeaponCategories.SPEAR, (item, player) -> item.getStyle((LivingEntityPatch<?>)player) == CapabilityItem.Styles.TWO_HAND ? Animations.SPEAR_GUARD_HIT : null).addAdvancedGuardMotion(CapabilityItem.WeaponCategories.TACHI, (item, player) -> Animations.LONGSWORD_GUARD_HIT).addAdvancedGuardMotion(CapabilityItem.WeaponCategories.GREATSWORD, (item, player) -> Animations.GREATSWORD_GUARD_HIT);
    }

    public EnergizingGuardSkill(GuardSkill.Builder builder) {
        super(builder);
    }

    @Override
    public void guard(SkillContainer container, CapabilityItem itemCapapbility, HurtEvent.Pre event, float knockback, float impact, boolean advanced) {
        boolean canUse = this.isHoldingWeaponAvailable((PlayerPatch<?>)event.getPlayerPatch(), itemCapapbility, GuardSkill.BlockType.ADVANCED_GUARD);
        if (((DamageSource)event.getDamageSource()).m_19372_()) {
            impact = event.getAmount();
        }
        super.guard(container, itemCapapbility, event, knockback, impact, canUse);
    }

    @Override
    public void dealEvent(PlayerPatch<?> playerpatch, HurtEvent.Pre event) {
        boolean isSpecialSource = EnergizingGuardSkill.isSpecialDamageSource((DamageSource)event.getDamageSource());
        event.setAmount(isSpecialSource ? event.getAmount() * 0.2f : 0.0f);
        event.setResult(isSpecialSource ? AttackResult.ResultType.SUCCESS : AttackResult.ResultType.BLOCKED);
        if (event.getDamageSource() instanceof ExtendedDamageSource) {
            ((ExtendedDamageSource)event.getDamageSource()).setStunType(ExtendedDamageSource.StunType.NONE);
        }
        event.setCanceled(true);
        Entity directEntity = ((DamageSource)event.getDamageSource()).m_7640_();
        LivingEntityPatch entitypatch = (LivingEntityPatch)directEntity.getCapability(EpicFightCapabilities.CAPABILITY_ENTITY).orElse(null);
        if (entitypatch != null) {
            entitypatch.onAttackBlocked(event, playerpatch);
        }
    }

    @Override
    protected boolean isBlockableSource(DamageSource damageSource, boolean advanced) {
        return !(damageSource.m_19376_() && !damageSource.f_19326_.equals("indirectMagic") || !advanced && !super.isBlockableSource(damageSource, false) || damageSource.m_19378_());
    }

    @Override
    public float getPenaltyMultiplier(CapabilityItem itemCap) {
        return this.advancedGuardMotions.containsKey(itemCap.getWeaponCategory()) ? 0.2f : 0.6f;
    }

    private static boolean isSpecialDamageSource(DamageSource damageSource) {
        return !(!damageSource.m_19372_() && !damageSource.m_19387_() && !damageSource.m_19384_() && !damageSource.m_19360_() || damageSource.m_19376_() && !damageSource.f_19326_.equals("indirectMagic"));
    }

    @Override
    public Skill getPriorSkill() {
        return Skills.GUARD;
    }

    @Override
    protected boolean isAdvancedGuard() {
        return true;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public List<Object> getTooltipArgs() {
        ArrayList list = Lists.newArrayList();
        list.add(String.format("%s, %s, %s, %s", CapabilityItem.WeaponCategories.GREATSWORD, CapabilityItem.WeaponCategories.LONGSWORD, CapabilityItem.WeaponCategories.SPEAR, CapabilityItem.WeaponCategories.TACHI).toLowerCase());
        return list;
    }
}

