/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.skill;

import java.util.UUID;
import net.minecraft.resources.ResourceLocation;
import yesman.epicfight.client.world.capabilites.entitypatch.player.LocalPlayerPatch;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillCategories;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.SkillDataManager;
import yesman.epicfight.world.entity.eventlistener.PlayerEventListener;

public class ChargingJumpSkill
extends Skill {
    private static final SkillDataManager.SkillDataKey<Integer> CHARGE_TICKS = SkillDataManager.SkillDataKey.createDataKey(SkillDataManager.ValueType.INTEGER);
    private static final UUID EVENT_UUID = UUID.fromString("0bbe389a-1622-11ed-861d-0242ac120002");
    private static final int LEAST_REQUIRED_TICKS = 10;

    public static Skill.Builder<ChargingJumpSkill> createBuilder() {
        return new Skill.Builder(new ResourceLocation("epicfight", "charging_jump")).setCategory(SkillCategories.CHARGING_JUMP).setConsumption(1.0f).setActivateType(Skill.ActivateType.ONE_SHOT).setResource(Skill.Resource.STAMINA);
    }

    public ChargingJumpSkill(Skill.Builder<? extends Skill> builder) {
        super(builder);
    }

    @Override
    public void onInitiate(SkillContainer container) {
        container.getDataManager().registerData(CHARGE_TICKS);
        container.getExecuter().getEventListener().addEventListener(PlayerEventListener.EventType.MOVEMENT_INPUT_EVENT, EVENT_UUID, event -> {
            if (event.getMovementInput().f_108572_) {
                int chargeTicks = container.getDataManager().getDataValue(CHARGE_TICKS);
                if (event.getMovementInput().f_108573_ || chargeTicks > 0) {
                    container.getDataManager().setData(CHARGE_TICKS, chargeTicks + 1);
                    System.out.println("up charge tick " + (chargeTicks + 1));
                    event.getMovementInput().f_108572_ = false;
                    event.getMovementInput().f_108567_ = 0.0f;
                }
            } else {
                int chargeTicks = container.getDataManager().getDataValue(CHARGE_TICKS);
                if (chargeTicks > 10) {
                    System.out.println("super jump !");
                    double amount = Math.floor((double)chargeTicks * 0.1);
                    Object entity = ((LocalPlayerPatch)event.getPlayerPatch()).getOriginal();
                    entity.m_20256_(entity.m_20184_().m_82520_(0.0, amount, 0.0));
                }
                container.getDataManager().setData(CHARGE_TICKS, 0);
            }
        });
    }

    @Override
    public void onRemoved(SkillContainer container) {
        container.getExecuter().getEventListener().removeListener(PlayerEventListener.EventType.MOVEMENT_INPUT_EVENT, EVENT_UUID);
    }
}

