/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.skill;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.UUID;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import yesman.epicfight.client.gui.BattleModeGui;
import yesman.epicfight.skill.PassiveSkill;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.world.capabilities.entitypatch.EntityPatch;
import yesman.epicfight.world.entity.eventlistener.PlayerEventListener;

public class BerserkerSkill
extends PassiveSkill {
    private static final UUID EVENT_UUID = UUID.fromString("fdc09ee8-fcfc-11eb-9a03-0242ac130003");

    public BerserkerSkill(Skill.Builder<? extends Skill> builder) {
        super(builder);
    }

    @Override
    public void onInitiate(SkillContainer container) {
        PlayerEventListener listener = container.getExecuter().getEventListener();
        listener.addEventListener(PlayerEventListener.EventType.ATTACK_SPEED_MODIFY_EVENT, EVENT_UUID, event -> {
            Player player = (Player)((EntityPatch)event.getPlayerPatch()).getOriginal();
            float health = player.m_21223_();
            float maxHealth = player.m_21233_();
            float lostHealthPercentage = (maxHealth - health) / maxHealth;
            lostHealthPercentage = (float)Math.floor(lostHealthPercentage * 100.0f) * 0.005f;
            float attackSpeed = event.getAttackSpeed();
            event.setAttackSpeed(Math.min(5.0f, attackSpeed * (1.0f + lostHealthPercentage)));
        });
        listener.addEventListener(PlayerEventListener.EventType.DEALT_DAMAGE_EVENT_PRE, EVENT_UUID, event -> {
            Player player = (Player)((EntityPatch)event.getPlayerPatch()).getOriginal();
            float health = player.m_21223_();
            float maxHealth = player.m_21233_();
            float lostHealthPercentage = (maxHealth - health) / maxHealth;
            lostHealthPercentage = (float)Math.floor(lostHealthPercentage * 100.0f) * 0.003f;
            float attackDamage = event.getAttackDamage();
            event.setAttackDamage(attackDamage * (1.0f + lostHealthPercentage));
        });
    }

    @Override
    public void onRemoved(SkillContainer container) {
        container.getExecuter().getEventListener().removeListener(PlayerEventListener.EventType.ATTACK_SPEED_MODIFY_EVENT, EVENT_UUID);
        container.getExecuter().getEventListener().removeListener(PlayerEventListener.EventType.DEALT_DAMAGE_EVENT_PRE, EVENT_UUID);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean shouldDraw(SkillContainer container) {
        Player player = (Player)container.getExecuter().getOriginal();
        float health = player.m_21223_();
        float maxHealth = player.m_21233_();
        return maxHealth - health > 0.0f;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void drawOnGui(BattleModeGui gui, SkillContainer container, PoseStack matStackIn, float x, float y, float scale, int width, int height) {
        matStackIn.m_85836_();
        matStackIn.m_85841_(scale, scale, 1.0f);
        matStackIn.m_85837_(0.0, (double)((float)gui.getSlidingProgression() * 1.0f / scale), 0.0);
        RenderSystem.m_157456_((int)0, (ResourceLocation)this.getSkillTexture());
        float scaleMultiply = 1.0f / scale;
        gui.drawTexturedModalRectFixCoord(matStackIn.m_85850_().m_85861_(), ((float)width - x) * scaleMultiply, ((float)height - y) * scaleMultiply, 0, 0, 255, 255);
        matStackIn.m_85841_(scaleMultiply, scaleMultiply, 1.0f);
        Player player = (Player)container.getExecuter().getOriginal();
        float health = player.m_21223_();
        float maxHealth = player.m_21233_();
        float lostHealthPercentage = (maxHealth - health) / maxHealth;
        lostHealthPercentage = (float)Math.floor(lostHealthPercentage * 100.0f);
        gui.font.m_92750_(matStackIn, String.format("%.0f%%", Float.valueOf(lostHealthPercentage)), (float)width - x + 4.0f, (float)height - y + 6.0f, 0xFFFFFF);
        matStackIn.m_85849_();
    }
}

