/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.Collection;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import yesman.epicfight.network.EpicFightNetworkManager;
import yesman.epicfight.network.server.SPChangeSkill;
import yesman.epicfight.network.server.SPClearSkills;
import yesman.epicfight.network.server.SPRemoveSkill;
import yesman.epicfight.server.commands.arguments.SkillArgument;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;

public class PlayerSkillCommand {
    private static final SimpleCommandExceptionType ERROR_ADD_FAILED = new SimpleCommandExceptionType((Message)new TranslatableComponent("commands.epicfight.skill.add.failed"));
    private static final SimpleCommandExceptionType ERROR_REMOVE_FAILED = new SimpleCommandExceptionType((Message)new TranslatableComponent("commands.epicfight.skill.remove.failed"));
    private static final SimpleCommandExceptionType ERROR_CLEAR_FAILED = new SimpleCommandExceptionType((Message)new TranslatableComponent("commands.epicfight.skill.clear.failed"));

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        LiteralArgumentBuilder builder = (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"skill").requires(commandSourceStack -> commandSourceStack.m_6761_(2))).then(Commands.m_82127_((String)"clear").then(Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91470_()).executes(commandContext -> PlayerSkillCommand.clearSkill((CommandSourceStack)commandContext.getSource(), EntityArgument.m_91477_((CommandContext)commandContext, (String)"targets")))))).then(Commands.m_82127_((String)"add").then(Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91470_()).then(Commands.m_82129_((String)"skill", (ArgumentType)SkillArgument.skill()).executes(commandContext -> PlayerSkillCommand.addSkill((CommandSourceStack)commandContext.getSource(), EntityArgument.m_91477_((CommandContext)commandContext, (String)"targets"), SkillArgument.getSkill((CommandContext<CommandSourceStack>)commandContext, "skill"))))))).then(Commands.m_82127_((String)"remove").then(Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91470_()).then(Commands.m_82129_((String)"skill", (ArgumentType)SkillArgument.skill()).executes(commandContext -> PlayerSkillCommand.removeSkill((CommandSourceStack)commandContext.getSource(), EntityArgument.m_91477_((CommandContext)commandContext, (String)"targets"), SkillArgument.getSkill((CommandContext<CommandSourceStack>)commandContext, "skill"))))));
        dispatcher.register((LiteralArgumentBuilder)Commands.m_82127_((String)"epicfight").then((ArgumentBuilder)builder));
    }

    public static int clearSkill(CommandSourceStack commandSourceStack, Collection<? extends ServerPlayer> targets) throws CommandSyntaxException {
        int i = 0;
        for (ServerPlayer serverPlayer : targets) {
            ServerPlayerPatch playerpatch = (ServerPlayerPatch)serverPlayer.getCapability(EpicFightCapabilities.CAPABILITY_ENTITY, null).orElse(null);
            playerpatch.getSkillCapability().clear();
            EpicFightNetworkManager.sendToPlayer(new SPClearSkills(), serverPlayer);
            ++i;
        }
        if (i > 0) {
            if (i == 1) {
                commandSourceStack.m_81354_((Component)new TranslatableComponent("commands.epicfight.skill.clear.success.single", new Object[]{targets.iterator().next().m_5446_()}), true);
            } else {
                commandSourceStack.m_81354_((Component)new TranslatableComponent("commands.epicfight.skill.clear.success.multiple", new Object[]{i}), true);
            }
        } else {
            throw ERROR_CLEAR_FAILED.create();
        }
        return i;
    }

    public static int addSkill(CommandSourceStack commandSourceStack, Collection<? extends ServerPlayer> targets, Skill skill) throws CommandSyntaxException {
        int i = 0;
        for (ServerPlayer serverPlayer : targets) {
            ServerPlayerPatch playerpatch = (ServerPlayerPatch)serverPlayer.getCapability(EpicFightCapabilities.CAPABILITY_ENTITY, null).orElse(null);
            if (!playerpatch.getSkillCapability().skillContainers[skill.getCategory().universalOrdinal()].setSkill(skill)) continue;
            if (skill.getCategory().learnable()) {
                playerpatch.getSkillCapability().addLearnedSkill(skill);
            }
            EpicFightNetworkManager.sendToPlayer(new SPChangeSkill(skill.getCategory().universalOrdinal(), skill.toString(), SPChangeSkill.State.ENABLE), serverPlayer);
            ++i;
        }
        if (i > 0) {
            if (i == 1) {
                commandSourceStack.m_81354_((Component)new TranslatableComponent("commands.epicfight.skill.add.success.single", new Object[]{skill.getDisplayName(), targets.iterator().next().m_5446_()}), true);
            } else {
                commandSourceStack.m_81354_((Component)new TranslatableComponent("commands.epicfight.skill.add.success.multiple", new Object[]{skill.getDisplayName(), i}), true);
            }
        } else {
            throw ERROR_ADD_FAILED.create();
        }
        return i;
    }

    public static int removeSkill(CommandSourceStack commandSourceStack, Collection<? extends ServerPlayer> targets, Skill skill) throws CommandSyntaxException {
        int i = 0;
        for (ServerPlayer serverPlayer : targets) {
            ServerPlayerPatch playerpatch = (ServerPlayerPatch)serverPlayer.getCapability(EpicFightCapabilities.CAPABILITY_ENTITY, null).orElse(null);
            if (playerpatch == null || !playerpatch.getSkillCapability().removeLearnedSkill(skill)) continue;
            SkillContainer skillContainer = playerpatch.getSkillCapability().skillContainers[skill.getCategory().universalOrdinal()];
            if (skillContainer.getSkill() == skill) {
                skillContainer.setSkill(null);
            }
            EpicFightNetworkManager.sendToPlayer(new SPRemoveSkill(skill.toString()), serverPlayer);
            ++i;
        }
        if (i > 0) {
            if (i == 1) {
                commandSourceStack.m_81354_((Component)new TranslatableComponent("commands.epicfight.skill.remove.success.single", new Object[]{skill.getDisplayName(), targets.iterator().next().m_5446_()}), true);
            } else {
                commandSourceStack.m_81354_((Component)new TranslatableComponent("commands.epicfight.skill.remove.success.multiple", new Object[]{skill.getDisplayName(), i}), true);
            }
        } else {
            throw ERROR_REMOVE_FAILED.create();
        }
        return i;
    }
}

