/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.network.server;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;
import yesman.epicfight.client.world.capabilites.entitypatch.player.LocalPlayerPatch;
import yesman.epicfight.gameasset.Skills;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;

public class SPRemoveSkill {
    private String skillName;

    public SPRemoveSkill() {
        this("");
    }

    public SPRemoveSkill(String name) {
        this.skillName = name;
    }

    public static SPRemoveSkill fromBytes(FriendlyByteBuf buf) {
        SPRemoveSkill msg = new SPRemoveSkill(buf.m_130277_());
        return msg;
    }

    public static void toBytes(SPRemoveSkill msg, FriendlyByteBuf buf) {
        buf.m_130070_(msg.skillName);
    }

    public static void handle(SPRemoveSkill msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            Minecraft mc = Minecraft.m_91087_();
            LocalPlayerPatch playerpatch = (LocalPlayerPatch)mc.f_91074_.getCapability(EpicFightCapabilities.CAPABILITY_ENTITY, null).orElse(null);
            if (playerpatch != null) {
                Skill skill = Skills.getSkill(msg.skillName);
                playerpatch.getSkillCapability().removeLearnedSkill(skill);
                SkillContainer skillContainer = playerpatch.getSkillCapability().skillContainers[skill.getCategory().universalOrdinal()];
                if (skillContainer.getSkill() == skill) {
                    skillContainer.setSkill(null);
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

