/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.network.client;

import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;
import yesman.epicfight.gameasset.Skills;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;

public class CPChangeSkill {
    private int skillSlotIndex;
    private int itemSlotIndex;
    private String skillName;
    private boolean consumeXp;

    public CPChangeSkill() {
        this(0, -1, "", false);
    }

    public CPChangeSkill(int skillSlotIndex, int itemSlotIndex, String name, boolean consumeXp) {
        this.skillSlotIndex = skillSlotIndex;
        this.itemSlotIndex = itemSlotIndex;
        this.skillName = name;
        this.consumeXp = consumeXp;
    }

    public static CPChangeSkill fromBytes(FriendlyByteBuf buf) {
        CPChangeSkill msg = new CPChangeSkill(buf.readInt(), buf.readInt(), buf.m_130277_(), buf.readBoolean());
        return msg;
    }

    public static void toBytes(CPChangeSkill msg, FriendlyByteBuf buf) {
        buf.writeInt(msg.skillSlotIndex);
        buf.writeInt(msg.itemSlotIndex);
        buf.m_130070_(msg.skillName);
        buf.writeBoolean(msg.consumeXp);
    }

    public static void handle(CPChangeSkill msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer serverPlayer = ((NetworkEvent.Context)ctx.get()).getSender();
            ServerPlayerPatch playerpatch = (ServerPlayerPatch)serverPlayer.getCapability(EpicFightCapabilities.CAPABILITY_ENTITY, null).orElse(null);
            if (playerpatch != null) {
                Skill skill = Skills.getSkill(msg.skillName);
                playerpatch.getSkill(msg.skillSlotIndex).setSkill(skill);
                if (skill.getCategory().learnable()) {
                    playerpatch.getSkillCapability().addLearnedSkill(skill);
                }
                if (msg.consumeXp) {
                    serverPlayer.m_6749_(-skill.getRequiredXp());
                } else if (!serverPlayer.m_7500_()) {
                    serverPlayer.m_150109_().m_36057_(serverPlayer.m_150109_().m_8020_(msg.itemSlotIndex));
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

