/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.config;

import com.google.common.collect.Lists;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;

public class ClientConfig {
    public final ForgeConfigSpec.IntValue longPressCountConfig;
    public final ForgeConfigSpec.BooleanValue showHealthIndicator;
    public final ForgeConfigSpec.BooleanValue showTargetIndicator;
    public final ForgeConfigSpec.BooleanValue filterAnimation;
    public final ForgeConfigSpec.DoubleValue aimHelperColor;
    public final ForgeConfigSpec.BooleanValue enableAimHelper;
    public final ForgeConfigSpec.BooleanValue cameraAutoSwitch;
    public final ForgeConfigSpec.BooleanValue autoPreparation;
    public final ForgeConfigSpec.BooleanValue offBloodEffects;
    public final ForgeConfigSpec.ConfigValue<List<? extends String>> battleAutoSwitchItems;
    public final ForgeConfigSpec.ConfigValue<List<? extends String>> miningAutoSwitchItems;

    public ClientConfig(ForgeConfigSpec.Builder config) {
        this.longPressCountConfig = config.defineInRange("ingame.long_press_count", 2, 1, 10);
        this.showHealthIndicator = config.define("ingame.show_health_indicator", () -> true);
        this.showTargetIndicator = config.define("ingame.show_target_indicator", () -> true);
        this.filterAnimation = config.define("ingame.filter_animation", () -> true);
        this.aimHelperColor = config.defineInRange("ingame.laser_pointer_color", 0.328125, 0.0, 1.0);
        this.enableAimHelper = config.define("ingame.enable_laser_pointer", () -> true);
        this.cameraAutoSwitch = config.define("ingame.camera_auto_switch", () -> false);
        this.autoPreparation = config.define("ingame.auto_preparation", () -> false);
        this.offBloodEffects = config.define("ingame.off_gore", () -> false);
        this.battleAutoSwitchItems = config.defineList("ingame.battle_autoswitch_items", (List)Lists.newArrayList(), element -> {
            if (element instanceof String) {
                return ((String)element).contains(":");
            }
            return false;
        });
        this.miningAutoSwitchItems = config.defineList("ingame.mining_autoswitch_items", (List)Lists.newArrayList(), element -> {
            if (element instanceof String) {
                return ((String)element).contains(":");
            }
            return false;
        });
    }
}

