/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.client.renderer.patched.layer;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.layers.HumanoidArmorLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.DyeableLeatherItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.ForgeHooksClient;
import yesman.epicfight.api.client.model.ClientModel;
import yesman.epicfight.api.client.model.ClientModels;
import yesman.epicfight.api.client.model.CustomModelBakery;
import yesman.epicfight.api.utils.math.OpenMatrix4f;
import yesman.epicfight.client.ClientEngine;
import yesman.epicfight.client.renderer.EpicFightRenderTypes;
import yesman.epicfight.client.renderer.patched.layer.PatchedLayer;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;

@OnlyIn(value=Dist.CLIENT)
public class WearableItemLayer<E extends LivingEntity, T extends LivingEntityPatch<E>, M extends HumanoidModel<E>>
extends PatchedLayer<E, T, M, HumanoidArmorLayer<E, M, M>> {
    private static final Map<ResourceLocation, ClientModel> ARMOR_MODELS = new HashMap<ResourceLocation, ClientModel>();
    private static final Map<String, ResourceLocation> EPICFIGHT_OVERRIDING_TEXTURES = Maps.newHashMap();
    final boolean doNotRenderHelment;

    public static void clear() {
        ARMOR_MODELS.clear();
        EPICFIGHT_OVERRIDING_TEXTURES.clear();
    }

    public WearableItemLayer() {
        this(false);
    }

    public WearableItemLayer(boolean doNotRenderHelment) {
        this.doNotRenderHelment = doNotRenderHelment;
    }

    private void renderArmor(PoseStack matStack, MultiBufferSource multiBufferSource, int packedLightIn, boolean hasEffect, ClientModel model, float r, float g, float b, ResourceLocation armorTexture, OpenMatrix4f[] poses) {
        VertexConsumer vertexConsumer = EpicFightRenderTypes.getArmorVertexBuilder(multiBufferSource, EpicFightRenderTypes.animatedArmor(armorTexture, model.getProperties().isTransparent()), hasEffect);
        model.drawAnimatedModel(matStack, vertexConsumer, packedLightIn, r, g, b, 1.0f, OverlayTexture.f_118083_, poses);
    }

    @Override
    public void renderLayer(T entitypatch, E entityliving, HumanoidArmorLayer<E, M, M> originalRenderer, PoseStack poseStack, MultiBufferSource buf, int packedLightIn, OpenMatrix4f[] poses, float netYawHead, float pitchHead, float partialTicks) {
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            ItemStack stack;
            Item item;
            if (slot.m_20743_() != EquipmentSlot.Type.ARMOR || slot == EquipmentSlot.HEAD && this.doNotRenderHelment || !((item = (stack = entityliving.m_6844_(slot)).m_41720_()) instanceof ArmorItem)) continue;
            ArmorItem armorItem = (ArmorItem)stack.m_41720_();
            if (slot != armorItem.m_40402_()) {
                return;
            }
            poseStack.m_85836_();
            float head = 0.0f;
            if (((HumanoidModel)originalRenderer.m_117386_()).m_5585_() != null && ((HumanoidModel)originalRenderer.m_117386_()).m_5585_().f_104212_.size() > 0) {
                ModelPart.Cube headCube = (ModelPart.Cube)((HumanoidModel)originalRenderer.m_117386_()).m_5585_().f_104212_.get(0);
                head = headCube.f_104338_ - headCube.f_104336_ - 12.0f;
            }
            if (slot == EquipmentSlot.HEAD) {
                poseStack.m_85837_(0.0, (double)head * 0.055, 0.0);
            }
            ClientModel model = this.getArmorModel(originalRenderer, entityliving, armorItem, stack, slot);
            boolean hasEffect = stack.m_41790_();
            if (armorItem instanceof DyeableLeatherItem) {
                int i = ((DyeableLeatherItem)armorItem).m_41121_(stack);
                float r = (float)(i >> 16 & 0xFF) / 255.0f;
                float g = (float)(i >> 8 & 0xFF) / 255.0f;
                float b = (float)(i & 0xFF) / 255.0f;
                this.renderArmor(poseStack, buf, packedLightIn, hasEffect, model, r, g, b, this.getArmorTexture(stack, (Entity)entityliving, slot, null), poses);
                this.renderArmor(poseStack, buf, packedLightIn, hasEffect, model, 1.0f, 1.0f, 1.0f, this.getArmorTexture(stack, (Entity)entityliving, slot, "overlay"), poses);
            } else {
                this.renderArmor(poseStack, buf, packedLightIn, hasEffect, model, 1.0f, 1.0f, 1.0f, this.getArmorTexture(stack, (Entity)entityliving, slot, null), poses);
            }
            poseStack.m_85849_();
        }
    }

    private ClientModel getArmorModel(HumanoidArmorLayer<E, M, M> originalRenderer, E entityliving, ArmorItem armorItem, ItemStack stack, EquipmentSlot slot) {
        ResourceLocation rl;
        ClientModel model;
        ResourceLocation registryName = armorItem.getRegistryName();
        boolean debuggingMode = ClientEngine.instance.isArmorModelDebuggingMode();
        if (ARMOR_MODELS.containsKey(registryName) && !debuggingMode) {
            return ARMOR_MODELS.get(registryName);
        }
        ResourceManager resourceManager = Minecraft.m_91087_().m_91098_();
        if (resourceManager.m_7165_((model = new ClientModel(rl = new ResourceLocation(armorItem.getRegistryName().m_135827_(), "armor/" + armorItem.getRegistryName().m_135815_()))).getLocation())) {
            model.loadMeshAndProperties(resourceManager);
        } else {
            HumanoidModel defaultModel = originalRenderer.m_117078_(slot);
            Model customModel = ForgeHooksClient.getArmorModel(entityliving, (ItemStack)stack, (EquipmentSlot)slot, (HumanoidModel)defaultModel);
            model = customModel == defaultModel || !(customModel instanceof HumanoidModel) ? WearableItemLayer.getDefaultArmorModel(slot) : CustomModelBakery.bakeBipedCustomArmorModel((HumanoidModel)customModel, armorItem, slot, debuggingMode);
        }
        ARMOR_MODELS.put(registryName, model);
        return model;
    }

    private ResourceLocation getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
        ResourceLocation resourcelocation;
        int idx2;
        ArmorItem item = (ArmorItem)stack.m_41720_();
        String texture = item.m_40401_().m_6082_();
        String domain = "minecraft";
        int idx = texture.indexOf(58);
        if (idx != -1) {
            domain = texture.substring(0, idx);
            texture = texture.substring(idx + 1);
        }
        String s1 = String.format("%s:textures/models/armor/%s_layer_%d%s.png", domain, texture, slot == EquipmentSlot.LEGS ? 2 : 1, type == null ? "" : String.format("_%s", type));
        String s2 = String.format("%s/epicfight/%s", (s1 = ForgeHooksClient.getArmorTexture((Entity)entity, (ItemStack)stack, (String)s1, (EquipmentSlot)slot, (String)type)).substring(0, idx2 = s1.lastIndexOf(47)), s1.substring(idx2 + 1));
        ResourceLocation resourcelocation2 = EPICFIGHT_OVERRIDING_TEXTURES.get(s2);
        if (resourcelocation2 != null) {
            return resourcelocation2;
        }
        if (!EPICFIGHT_OVERRIDING_TEXTURES.containsKey(s2)) {
            resourcelocation2 = new ResourceLocation(s2);
            ResourceManager rm = Minecraft.m_91087_().m_91098_();
            if (rm.m_7165_(resourcelocation2)) {
                EPICFIGHT_OVERRIDING_TEXTURES.put(s2, resourcelocation2);
                return resourcelocation2;
            }
            EPICFIGHT_OVERRIDING_TEXTURES.put(s2, null);
        }
        if ((resourcelocation = (ResourceLocation)HumanoidArmorLayer.f_117070_.get(s1)) == null) {
            resourcelocation = new ResourceLocation(s1);
            HumanoidArmorLayer.f_117070_.put(s1, resourcelocation);
        }
        return resourcelocation;
    }

    public static ClientModel getDefaultArmorModel(EquipmentSlot slot) {
        ClientModels modelDB = ClientModels.LOGICAL_CLIENT;
        switch (slot) {
            case HEAD: {
                return modelDB.helmet;
            }
            case CHEST: {
                return modelDB.chestplate;
            }
            case LEGS: {
                return modelDB.leggins;
            }
            case FEET: {
                return modelDB.boots;
            }
        }
        return null;
    }
}

