/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.client.renderer.patched.layer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.WitherBossModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.layers.WitherArmorLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import yesman.epicfight.api.animation.AnimationPlayer;
import yesman.epicfight.api.animation.Animator;
import yesman.epicfight.api.client.model.ClientModels;
import yesman.epicfight.api.utils.math.OpenMatrix4f;
import yesman.epicfight.client.renderer.EpicFightRenderTypes;
import yesman.epicfight.client.renderer.patched.layer.PatchedLayer;
import yesman.epicfight.gameasset.Animations;
import yesman.epicfight.world.capabilities.entitypatch.boss.WitherPatch;

@OnlyIn(value=Dist.CLIENT)
public class PatchedWitherArmorLayer
extends PatchedLayer<WitherBoss, WitherPatch, WitherBossModel<WitherBoss>, WitherArmorLayer> {
    private static final ResourceLocation WITHER_ARMOR_LOCATION = new ResourceLocation("textures/entity/wither/wither_armor.png");

    @Override
    public void renderLayer(WitherPatch entitypatch, WitherBoss entityliving, WitherArmorLayer originalRenderer, PoseStack matrixStackIn, MultiBufferSource buffer, int packedLightIn, OpenMatrix4f[] poses, float netYawHead, float pitchHead, float partialTicks) {
        if (entitypatch.isArmorActivated()) {
            float progress = (float)entityliving.f_19797_ + partialTicks;
            matrixStackIn.m_85836_();
            matrixStackIn.m_85837_(0.0, -0.1, 0.0);
            matrixStackIn.m_85841_(1.05f, 1.05f, 1.05f);
            int transparencyCount = entitypatch.getTransparency();
            float transparency = 1.0f;
            if (transparencyCount == 0) {
                transparency = entitypatch.isGhost() ? 0.0f : 1.0f;
                AnimationPlayer animationPlayer = ((Animator)entitypatch.getAnimator()).getPlayerFor(null);
                if (animationPlayer.getAnimation() == Animations.WITHER_SPELL_ARMOR) {
                    transparency = (animationPlayer.getPrevElapsedTime() + (animationPlayer.getElapsedTime() - animationPlayer.getPrevElapsedTime()) * partialTicks) / (Animations.WITHER_SPELL_ARMOR.getTotalTime() - 0.5f);
                }
            } else if (transparencyCount < 0) {
                transparency = 1.0f - ((float)Math.abs(transparencyCount) + partialTicks) / 41.0f;
            } else if (transparencyCount > 0) {
                transparency = ((float)Math.abs(transparencyCount) + partialTicks) / 41.0f;
            }
            VertexConsumer ivertexbuilder = buffer.m_6299_(EpicFightRenderTypes.energySwirlTrianlges(WITHER_ARMOR_LOCATION, Mth.m_14089_((float)(progress * 0.02f)) * 3.0f % 1.0f, progress * 0.01f % 1.0f));
            entitypatch.getEntityModel(ClientModels.LOGICAL_CLIENT).drawAnimatedModel(matrixStackIn, ivertexbuilder, packedLightIn, transparency * 0.5f, transparency * 0.5f, transparency * 0.5f, 1.0f, OverlayTexture.f_118083_, poses);
            matrixStackIn.m_85849_();
        }
    }
}

