/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.client.renderer.patched.layer;

import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Map;
import net.minecraft.client.model.IronGolemModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.layers.IronGolemCrackinessLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import yesman.epicfight.api.client.model.ClientModels;
import yesman.epicfight.api.utils.math.OpenMatrix4f;
import yesman.epicfight.client.renderer.EpicFightRenderTypes;
import yesman.epicfight.client.renderer.patched.layer.PatchedLayer;
import yesman.epicfight.world.capabilities.entitypatch.mob.IronGolemPatch;

@OnlyIn(value=Dist.CLIENT)
public class PatchedGolemCrackLayer
extends PatchedLayer<IronGolem, IronGolemPatch, IronGolemModel<IronGolem>, IronGolemCrackinessLayer> {
    private static final Map<IronGolem.Crackiness, ResourceLocation> CRACK_MAP = ImmutableMap.of((Object)IronGolem.Crackiness.LOW, (Object)new ResourceLocation("textures/entity/iron_golem/iron_golem_crackiness_low.png"), (Object)IronGolem.Crackiness.MEDIUM, (Object)new ResourceLocation("textures/entity/iron_golem/iron_golem_crackiness_medium.png"), (Object)IronGolem.Crackiness.HIGH, (Object)new ResourceLocation("textures/entity/iron_golem/iron_golem_crackiness_high.png"));

    @Override
    public void renderLayer(IronGolemPatch entitypatch, IronGolem entityGolem, IronGolemCrackinessLayer originalRenderer, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn, OpenMatrix4f[] poses, float netYawHead, float pitchHead, float partialTicks) {
        IronGolem.Crackiness crack = entityGolem.m_28873_();
        if (crack != IronGolem.Crackiness.NONE) {
            VertexConsumer ivertexbuilder = bufferIn.m_6299_(EpicFightRenderTypes.animatedModel(CRACK_MAP.get(crack)));
            entitypatch.getEntityModel(ClientModels.LOGICAL_CLIENT).drawAnimatedModel(matrixStackIn, ivertexbuilder, packedLightIn, 1.0f, 1.0f, 1.0f, 1.0f, OverlayTexture.f_118083_, poses);
        }
    }
}

