/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.client.renderer.patched.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderNameplateEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import yesman.epicfight.api.model.Armature;
import yesman.epicfight.api.utils.math.MathUtils;
import yesman.epicfight.api.utils.math.OpenMatrix4f;
import yesman.epicfight.world.capabilities.entitypatch.EntityPatch;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;

@OnlyIn(value=Dist.CLIENT)
public abstract class PatchedEntityRenderer<E extends LivingEntity, T extends LivingEntityPatch<E>, R extends EntityRenderer<E>> {
    protected static Method shouldShowName = ObfuscationReflectionHelper.findMethod(EntityRenderer.class, (String)"m_6512_", (Class[])new Class[]{Entity.class});
    protected static Method renderNameTag = ObfuscationReflectionHelper.findMethod(EntityRenderer.class, (String)"m_7649_", (Class[])new Class[]{Entity.class, Component.class, PoseStack.class, MultiBufferSource.class, Integer.TYPE});
    private ResourceLocation overridingTexture;

    public PatchedEntityRenderer<E, T, R> setOverridingTexture(String texture) {
        this.overridingTexture = new ResourceLocation(texture);
        return this;
    }

    public void render(E entityIn, T entitypatch, R renderer, MultiBufferSource buffer, PoseStack poseStack, int packedLight, float partialTicks) {
        try {
            RenderNameplateEvent renderNameplateEvent = new RenderNameplateEvent(entityIn, entityIn.m_5446_(), renderer, poseStack, buffer, packedLight, partialTicks);
            MinecraftForge.EVENT_BUS.post((Event)renderNameplateEvent);
            if ((((Boolean)shouldShowName.invoke(renderer, entityIn)).booleanValue() || renderNameplateEvent.getResult() == Event.Result.ALLOW) && renderNameplateEvent.getResult() != Event.Result.DENY) {
                renderNameTag.invoke(renderer, entityIn, renderNameplateEvent.getContent(), poseStack, buffer, packedLight);
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    public OpenMatrix4f[] getPoseMatrices(T entitypatch, Armature armature, float partialTicks) {
        armature.initializeTransform();
        this.setJointTransforms(entitypatch, armature, partialTicks);
        ((LivingEntityPatch)entitypatch).getClientAnimator().setPoseToModel(partialTicks);
        OpenMatrix4f[] poseMatrices = armature.getJointTransforms();
        return poseMatrices;
    }

    protected void setJointTransform(int jointId, Armature modelArmature, OpenMatrix4f mat) {
        modelArmature.searchJointById(jointId).getAnimatedTransform().mulFront(mat);
    }

    public void mulPoseStack(PoseStack poseStack, Armature armature, E entityIn, T entitypatch, float partialTicks) {
        OpenMatrix4f modelMatrix = ((LivingEntityPatch)entitypatch).getModelMatrix(partialTicks);
        OpenMatrix4f transpose = modelMatrix.transpose(null);
        poseStack.m_85845_(Vector3f.f_122225_.m_122240_(180.0f));
        MathUtils.translateStack(poseStack, modelMatrix);
        MathUtils.rotateStack(poseStack, transpose);
        MathUtils.scaleStack(poseStack, transpose);
    }

    protected void setJointTransforms(T entitypatch, Armature armature, float partialTicks) {
    }

    protected ResourceLocation getEntityTexture(T entitypatch, R renderer) {
        if (this.overridingTexture != null) {
            return this.overridingTexture;
        }
        return renderer.m_5478_((Entity)((LivingEntity)((EntityPatch)entitypatch).getOriginal()));
    }
}

