/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.client.renderer.patched.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EndCrystalRenderer;
import net.minecraft.client.renderer.entity.EnderDragonRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.boss.enderdragon.EndCrystal;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.boss.enderdragon.phases.DragonPhaseInstance;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import yesman.epicfight.api.animation.AnimationPlayer;
import yesman.epicfight.api.client.animation.Layer;
import yesman.epicfight.api.client.model.ClientModel;
import yesman.epicfight.api.client.model.ClientModels;
import yesman.epicfight.api.model.Armature;
import yesman.epicfight.api.utils.math.MathUtils;
import yesman.epicfight.api.utils.math.OpenMatrix4f;
import yesman.epicfight.api.utils.math.Vec3f;
import yesman.epicfight.client.renderer.EpicFightRenderTypes;
import yesman.epicfight.client.renderer.LightningRenderHelper;
import yesman.epicfight.client.renderer.patched.entity.PatchedEntityRenderer;
import yesman.epicfight.world.capabilities.entitypatch.boss.enderdragon.DragonCrystalLinkPhase;
import yesman.epicfight.world.capabilities.entitypatch.boss.enderdragon.EnderDragonPatch;
import yesman.epicfight.world.capabilities.entitypatch.boss.enderdragon.PatchedPhases;

@OnlyIn(value=Dist.CLIENT)
public class PEnderDragonRenderer
extends PatchedEntityRenderer<EnderDragon, EnderDragonPatch, EnderDragonRenderer> {
    private static final ResourceLocation DRAGON_LOCATION = new ResourceLocation("textures/entity/enderdragon/dragon.png");
    private static final ResourceLocation DRAGON_EXPLODING_LOCATION = new ResourceLocation("textures/entity/enderdragon/dragon_exploding.png");

    @Override
    public void render(EnderDragon entityIn, EnderDragonPatch entitypatch, EnderDragonRenderer renderer, MultiBufferSource buffer, PoseStack poseStack, int packedLight, float partialTicks) {
        float deathTimeProgression;
        ClientModel model = entitypatch.getEntityModel(ClientModels.LOGICAL_CLIENT);
        Armature armature = model.getArmature();
        poseStack.m_85836_();
        this.mulPoseStack(poseStack, armature, entityIn, entitypatch, partialTicks);
        OpenMatrix4f[] poses = this.getPoseMatrices(entitypatch, armature, partialTicks);
        if (entityIn.f_31084_ > 0) {
            poseStack.m_85837_(entityIn.m_21187_().nextGaussian() * 0.08, 0.0, entityIn.m_21187_().nextGaussian() * 0.08);
            deathTimeProgression = ((float)entityIn.f_31084_ + partialTicks) / 200.0f;
            VertexConsumer builder = buffer.m_6299_(EpicFightRenderTypes.dragonExplosionAlphaTriangles(DRAGON_EXPLODING_LOCATION));
            model.drawAnimatedModel(poseStack, builder, packedLight, 1.0f, 1.0f, 1.0f, deathTimeProgression, OverlayTexture.f_118083_, poses);
            VertexConsumer builder2 = buffer.m_6299_(EpicFightRenderTypes.entityDecalTriangles(DRAGON_LOCATION));
            model.drawAnimatedModel(poseStack, builder2, packedLight, 1.0f, 1.0f, 1.0f, 1.0f, this.getOverlayCoord(entityIn, entitypatch, partialTicks), poses);
        } else {
            VertexConsumer builder = buffer.m_6299_(EpicFightRenderTypes.animatedModel(DRAGON_LOCATION));
            model.drawAnimatedModel(poseStack, builder, packedLight, 1.0f, 1.0f, 1.0f, 1.0f, this.getOverlayCoord(entityIn, entitypatch, partialTicks), poses);
        }
        if (Minecraft.m_91087_().m_91290_().m_114377_()) {
            for (Layer.Priority priority : Layer.Priority.values()) {
                AnimationPlayer animPlayer = entitypatch.getClientAnimator().getCompositeLayer((Layer.Priority)priority).animationPlayer;
                float playTime = animPlayer.getPrevElapsedTime() + (animPlayer.getElapsedTime() - animPlayer.getPrevElapsedTime()) * partialTicks;
                animPlayer.getAnimation().renderDebugging(poseStack, buffer, entitypatch, playTime, partialTicks);
            }
        }
        poseStack.m_85849_();
        if (entityIn.f_31086_ != null) {
            float x = (float)(entityIn.f_31086_.m_20185_() - Mth.m_14139_((double)partialTicks, (double)entityIn.f_19854_, (double)entityIn.m_20185_()));
            float y = (float)(entityIn.f_31086_.m_20186_() - Mth.m_14139_((double)partialTicks, (double)entityIn.f_19855_, (double)entityIn.m_20186_()));
            float z = (float)(entityIn.f_31086_.m_20189_() - Mth.m_14139_((double)partialTicks, (double)entityIn.f_19856_, (double)entityIn.m_20189_()));
            poseStack.m_85836_();
            EnderDragonRenderer.m_114187_((float)x, (float)(y + EndCrystalRenderer.m_114158_((EndCrystal)entityIn.f_31086_, (float)partialTicks)), (float)z, (float)partialTicks, (int)entityIn.f_19797_, (PoseStack)poseStack, (MultiBufferSource)buffer, (int)packedLight);
            poseStack.m_85849_();
        }
        if (entityIn.f_31084_ > 0) {
            deathTimeProgression = ((float)entityIn.f_31084_ + partialTicks) / 200.0f;
            VertexConsumer lightningBuffer = buffer.m_6299_(RenderType.m_110502_());
            int density = (int)((deathTimeProgression + deathTimeProgression * deathTimeProgression) / 2.0f * 60.0f);
            float f7 = Math.min(deathTimeProgression > 0.8f ? (deathTimeProgression - 0.8f) / 0.2f : 0.0f, 1.0f);
            poseStack.m_85836_();
            LightningRenderHelper.renderCyclingLight(lightningBuffer, poseStack, 255, 0, 255, density, 1.0f, deathTimeProgression, f7);
            poseStack.m_85849_();
        }
    }

    @Override
    public void mulPoseStack(PoseStack matStack, Armature armature, EnderDragon entityIn, EnderDragonPatch entitypatch, float partialTicks) {
        OpenMatrix4f modelMatrix;
        if (!entitypatch.isGroundPhase() || ((EnderDragon)entitypatch.getOriginal()).f_31084_ > 0) {
            float f = (float)entityIn.m_31101_(7, partialTicks)[0];
            float f1 = (float)(entityIn.m_31101_(5, partialTicks)[1] - entityIn.m_31101_(10, partialTicks)[1]);
            float f2 = ((EnderDragon)entitypatch.getOriginal()).f_31084_ > 0 ? 0.0f : Mth.m_14209_((double)(entityIn.m_31101_(5, partialTicks)[0] - entityIn.m_31101_(10, partialTicks)[0]));
            modelMatrix = MathUtils.getModelMatrixIntegral(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, f1, f1, f, f, partialTicks, 1.0f, 1.0f, 1.0f).rotateDeg(-f2 * 1.5f, Vec3f.Z_AXIS);
        } else {
            modelMatrix = entitypatch.getModelMatrix(partialTicks).scale(-1.0f, 1.0f, -1.0f);
        }
        OpenMatrix4f transpose = new OpenMatrix4f(modelMatrix).transpose();
        MathUtils.translateStack(matStack, modelMatrix);
        MathUtils.rotateStack(matStack, transpose);
        MathUtils.scaleStack(matStack, transpose);
    }

    protected int getOverlayCoord(EnderDragon entity, EnderDragonPatch entitypatch, float partialTicks) {
        DragonPhaseInstance currentPhase = entity.m_31157_().m_31415_();
        float chargingTick = 158.0f;
        float progression = currentPhase.m_7309_() == PatchedPhases.CRYSTAL_LINK ? (chargingTick - (float)((DragonCrystalLinkPhase)currentPhase).getChargingCount()) / chargingTick : 0.0f;
        return OverlayTexture.m_118093_((int)OverlayTexture.m_118088_((float)progression), (int)OverlayTexture.m_118096_((entity.f_20916_ > 5 || entity.f_20919_ > 0 ? 1 : 0) != 0));
    }
}

