/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.layers.ArrowLayer;
import net.minecraft.client.renderer.entity.layers.BeeStingerLayer;
import net.minecraft.client.renderer.entity.layers.CustomHeadLayer;
import net.minecraft.client.renderer.entity.layers.ElytraLayer;
import net.minecraft.client.renderer.entity.layers.HumanoidArmorLayer;
import net.minecraft.client.renderer.entity.layers.PlayerItemInHandLayer;
import net.minecraft.client.renderer.entity.layers.SpinAttackEffectLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import yesman.epicfight.api.animation.types.ActionAnimation;
import yesman.epicfight.api.animation.types.AimAnimation;
import yesman.epicfight.api.client.animation.Layer;
import yesman.epicfight.api.client.model.ClientModel;
import yesman.epicfight.api.client.model.ClientModels;
import yesman.epicfight.api.model.Armature;
import yesman.epicfight.api.utils.math.OpenMatrix4f;
import yesman.epicfight.api.utils.math.Vec4f;
import yesman.epicfight.client.renderer.EpicFightRenderTypes;
import yesman.epicfight.client.renderer.patched.entity.PatchedLivingEntityRenderer;
import yesman.epicfight.client.renderer.patched.layer.EmptyLayer;
import yesman.epicfight.client.renderer.patched.layer.PatchedElytraLayer;
import yesman.epicfight.client.renderer.patched.layer.PatchedItemInHandLayer;
import yesman.epicfight.client.renderer.patched.layer.WearableItemLayer;
import yesman.epicfight.client.world.capabilites.entitypatch.player.LocalPlayerPatch;

@OnlyIn(value=Dist.CLIENT)
public class FirstPersonRenderer
extends PatchedLivingEntityRenderer<LocalPlayer, LocalPlayerPatch, PlayerModel<LocalPlayer>> {
    public FirstPersonRenderer() {
        this.addPatchedLayer(ElytraLayer.class, new PatchedElytraLayer());
        this.addPatchedLayer(PlayerItemInHandLayer.class, new PatchedItemInHandLayer());
        this.addPatchedLayer(HumanoidArmorLayer.class, new WearableItemLayer(true));
        this.addPatchedLayer(CustomHeadLayer.class, new EmptyLayer());
        this.addPatchedLayer(ArrowLayer.class, new EmptyLayer());
        this.addPatchedLayer(BeeStingerLayer.class, new EmptyLayer());
        this.addPatchedLayer(SpinAttackEffectLayer.class, new EmptyLayer());
    }

    @Override
    public void render(LocalPlayer entityIn, LocalPlayerPatch entitypatch, LivingEntityRenderer<LocalPlayer, PlayerModel<LocalPlayer>> renderer, MultiBufferSource buffer, PoseStack matStackIn, int packedLightIn, float partialTicks) {
        Minecraft mc = Minecraft.m_91087_();
        Camera renderInfo = mc.f_91063_.m_109153_();
        Vec3 projView = renderInfo.m_90583_();
        double x = Mth.m_14139_((double)partialTicks, (double)entityIn.f_19854_, (double)entityIn.m_20185_()) - projView.m_7096_();
        double y = Mth.m_14139_((double)partialTicks, (double)entityIn.f_19855_, (double)entityIn.m_20186_()) - projView.m_7098_();
        double z = Mth.m_14139_((double)partialTicks, (double)entityIn.f_19856_, (double)entityIn.m_20189_()) - projView.m_7094_();
        ClientModel model = entitypatch.getEntityModel(ClientModels.LOGICAL_CLIENT);
        Armature armature = model.getArmature();
        armature.initializeTransform();
        entitypatch.getClientAnimator().setPoseToModel(partialTicks);
        OpenMatrix4f[] poses = armature.getJointTransforms();
        matStackIn.m_85836_();
        Vec4f headPos = new Vec4f(0.0f, entityIn.m_20192_(), 0.0f, 1.0f);
        OpenMatrix4f.transform(poses[9], headPos, headPos);
        float pitch = renderInfo.m_90589_();
        boolean flag1 = entitypatch.getClientAnimator().baseLayer.animationPlayer.getAnimation() instanceof ActionAnimation;
        boolean flag2 = entitypatch.getClientAnimator().getCompositeLayer((Layer.Priority)Layer.Priority.MIDDLE).animationPlayer.getAnimation() instanceof AimAnimation;
        float zCoord = flag1 ? 0.0f : poses[0].m32;
        float posZ = Math.min(headPos.z - zCoord, 0.0f);
        if (headPos.z > poses[0].m32) {
            posZ += poses[0].m32 - headPos.z;
        }
        if (!flag2) {
            matStackIn.m_85845_(Vector3f.f_122223_.m_122240_(pitch));
        }
        float interpolation = pitch > 0.0f ? pitch / 90.0f : 0.0f;
        double yCorrection = y - 0.1 - 0.2 * (flag2 ? 0.8 : (double)interpolation);
        double zCorrection = z + 0.1 + 0.7 * (flag2 ? 0.0 : (double)interpolation) - (double)posZ;
        matStackIn.m_85837_(x, yCorrection, zCorrection);
        ClientModel firstModel = entityIn.m_108564_().equals("slim") ? ClientModels.LOGICAL_CLIENT.playerFirstPersonAlex : ClientModels.LOGICAL_CLIENT.playerFirstPerson;
        firstModel.drawAnimatedModel(matStackIn, buffer.m_6299_(EpicFightRenderTypes.animatedModel(((LocalPlayer)entitypatch.getOriginal()).m_108560_())), packedLightIn, 1.0f, 1.0f, 1.0f, 1.0f, OverlayTexture.f_118083_, poses);
        if (!entityIn.m_5833_()) {
            this.renderLayer(renderer, entitypatch, entityIn, poses, buffer, matStackIn, packedLightIn, partialTicks);
        }
        matStackIn.m_85849_();
    }
}

