/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.client.particle;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix4f;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import yesman.epicfight.api.client.model.ClientModel;
import yesman.epicfight.api.client.model.ClientModels;
import yesman.epicfight.api.model.Armature;
import yesman.epicfight.api.utils.math.OpenMatrix4f;
import yesman.epicfight.client.ClientEngine;
import yesman.epicfight.client.particle.CustomModelParticle;
import yesman.epicfight.client.particle.EpicFightParticleRenderTypes;
import yesman.epicfight.client.renderer.patched.entity.PatchedEntityRenderer;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;

@OnlyIn(value=Dist.CLIENT)
public class EntityAfterImageParticle
extends CustomModelParticle {
    private OpenMatrix4f[] poseMatrices;
    private Matrix4f modelMatrix;
    private float alphaO;

    public EntityAfterImageParticle(ClientLevel level, double x, double y, double z, double xd, double yd, double zd, ClientModel particleMesh, OpenMatrix4f[] matrices, Matrix4f modelMatrix) {
        super(level, x, y, z, xd, yd, zd, particleMesh);
        this.poseMatrices = matrices;
        this.modelMatrix = modelMatrix;
        this.f_107225_ = 20;
        this.f_107227_ = 1.0f;
        this.f_107228_ = 1.0f;
        this.f_107229_ = 1.0f;
        this.alphaO = 0.3f;
        this.f_107230_ = 0.3f;
    }

    @Override
    public void m_5989_() {
        super.m_5989_();
        this.alphaO = this.f_107230_;
        this.f_107230_ = (float)(this.f_107225_ - this.f_107224_) / (float)this.f_107225_ * 0.8f;
    }

    @Override
    public void m_5744_(VertexConsumer vertexConsumer, Camera camera, float partialTicks) {
        PoseStack poseStack = new PoseStack();
        this.setupPoseStack(poseStack, camera, partialTicks);
        poseStack.m_166854_(this.modelMatrix);
        float alpha = this.alphaO + (this.f_107230_ - this.alphaO) * partialTicks;
        this.particleMesh.drawAnimatedModelNoTexture(poseStack, vertexConsumer, this.m_6355_(partialTicks), this.f_107227_, this.f_107228_, this.f_107229_, alpha, OverlayTexture.f_118083_, this.poseMatrices);
    }

    public ParticleRenderType m_7556_() {
        return EpicFightParticleRenderTypes.TRANSLUCENT;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Provider
    implements ParticleProvider<SimpleParticleType> {
        public Particle createParticle(SimpleParticleType typeIn, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            LivingEntityPatch entitypatch = (LivingEntityPatch)level.m_6815_((int)Double.doubleToLongBits(xSpeed)).getCapability(EpicFightCapabilities.CAPABILITY_ENTITY).orElse(null);
            if (entitypatch != null && ClientEngine.instance.renderEngine.hasRendererFor((Entity)entitypatch.getOriginal())) {
                PatchedEntityRenderer renderer = ClientEngine.instance.renderEngine.getEntityRenderer((Entity)entitypatch.getOriginal());
                Armature armature = entitypatch.getEntityModel(ClientModels.LOGICAL_CLIENT).getArmature();
                PoseStack poseStack = new PoseStack();
                OpenMatrix4f[] matrices = renderer.getPoseMatrices(entitypatch, armature, 1.0f);
                renderer.mulPoseStack(poseStack, armature, (LivingEntity)entitypatch.getOriginal(), entitypatch, 1.0f);
                EntityAfterImageParticle particle = new EntityAfterImageParticle(level, x, y, z, xSpeed, ySpeed, zSpeed, entitypatch.getEntityModel(ClientModels.LOGICAL_CLIENT), matrices, poseStack.m_85850_().m_85861_());
                return particle;
            }
            return null;
        }
    }
}

