/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.client.gui.screen;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import yesman.epicfight.network.EpicFightNetworkManager;
import yesman.epicfight.network.client.CPChangeSkill;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillCategory;
import yesman.epicfight.world.capabilities.skill.CapabilitySkill;

@OnlyIn(value=Dist.CLIENT)
public class SkillEditScreen
extends Screen {
    private static final ResourceLocation SKILL_EDIT_UI = new ResourceLocation("epicfight", "textures/gui/screen/skill_edit.png");
    private static final TranslatableComponent NO_SKILLS = new TranslatableComponent("gui.epicfight.no_skills");
    private CapabilitySkill skills;
    private List<CategoryButton> categoryButtons = Lists.newArrayList();
    private List<LearnSkillButton> learnedSkillButtons = Lists.newArrayList();

    public SkillEditScreen(CapabilitySkill skills) {
        super((Component)new TranslatableComponent("gui.epicfight.skill_edit"));
        this.skills = skills;
    }

    public void m_7856_() {
        int i = this.f_96543_ / 2 - 80;
        int j = this.f_96544_ / 2 - 82;
        this.categoryButtons.clear();
        this.learnedSkillButtons.clear();
        for (SkillCategory skillCategory : SkillCategory.ENUM_MANAGER.universalValues()) {
            if (!this.skills.hasCategory(skillCategory) || !skillCategory.learnable()) continue;
            CategoryButton categoryButton = new CategoryButton(i, j, 18, 18, this.skills.skillContainers[skillCategory.universalOrdinal()].getSkill(), button -> {
                for (Button button2 : this.learnedSkillButtons) {
                    this.m_6702_().remove(button2);
                }
                this.learnedSkillButtons.clear();
                int k = this.f_96543_ / 2 - 53;
                int n = this.f_96544_ / 2 - 78;
                for (Skill skill : this.skills.getLearnedSkills(skillCategory)) {
                    void var4_7;
                    this.learnedSkillButtons.add(new LearnSkillButton(k, (int)var4_7, 117, 24, skill, (Component)new TranslatableComponent(skill.getTranslatableText()), pressedButton -> {
                        if (this.f_96541_.f_91074_.f_36078_ >= learnedSkill.getRequiredXp() || this.f_96541_.f_91074_.m_7500_()) {
                            this.skills.skillContainers[learnedSkill.getCategory().universalOrdinal()].setSkill(learnedSkill);
                            EpicFightNetworkManager.sendToServer(new CPChangeSkill(learnedSkill.getCategory().universalOrdinal(), -1, learnedSkill.toString(), !this.f_96541_.f_91074_.m_7500_()));
                            this.m_7379_();
                        }
                    }).setActive(!skill.equals(this.skills.skillContainers[skillCategory.universalOrdinal()].getSkill())));
                    var4_7 += 26;
                }
                for (Button button3 : this.learnedSkillButtons) {
                    this.m_7787_((GuiEventListener)button3);
                }
            }, (button, PoseStack2, x, y) -> this.m_96617_(PoseStack2, this.f_96541_.f_91062_.m_92923_((FormattedText)new TextComponent(skillCategory.toString()), Math.max(this.f_96543_ / 2 - 43, 170)), x, y));
            this.categoryButtons.add(categoryButton);
            this.m_7787_((GuiEventListener)categoryButton);
            j += 18;
        }
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
        int i;
        this.m_7333_(poseStack);
        for (i = 0; i < this.learnedSkillButtons.size(); ++i) {
            this.learnedSkillButtons.get(i).m_6305_(poseStack, mouseX, mouseY, partialTicks);
        }
        for (i = 0; i < this.categoryButtons.size(); ++i) {
            this.categoryButtons.get(i).m_6305_(poseStack, mouseX, mouseY, partialTicks);
        }
        if (this.categoryButtons.isEmpty()) {
            int lineHeight = 0;
            for (FormattedCharSequence s : this.f_96547_.m_92923_((FormattedText)NO_SKILLS, 110)) {
                this.f_96547_.m_92877_(poseStack, s, (float)(this.f_96543_ / 2 - 50), (float)(this.f_96544_ / 2 - 72 + lineHeight), 0x303030);
                lineHeight += 10;
            }
        }
    }

    public void m_7333_(PoseStack PoseStack2) {
        super.m_7333_(PoseStack2);
        RenderSystem.m_157456_((int)0, (ResourceLocation)SKILL_EDIT_UI);
        this.m_93228_(PoseStack2, this.f_96543_ / 2 - 88, this.f_96544_ / 2 - 100, 0, 0, 177, 200);
    }

    class CategoryButton
    extends Button {
        private Skill skill;

        public CategoryButton(int x, int y, int width, int height, Skill skill, Button.OnPress pressedAction, Button.OnTooltip onTooltip) {
            super(x, y, width, height, TextComponent.f_131282_, pressedAction, onTooltip);
            this.skill = skill;
        }

        public void m_6305_(PoseStack PoseStack2, int mouseX, int mouseY, float partialTicks) {
            RenderSystem.m_157456_((int)0, (ResourceLocation)SKILL_EDIT_UI);
            this.f_93622_ = mouseX >= this.f_93620_ && mouseY >= this.f_93621_ && mouseX < this.f_93620_ + this.f_93618_ && mouseY < this.f_93621_ + this.f_93619_;
            int y = this.f_93622_ ? 35 : 17;
            this.m_93228_(PoseStack2, this.f_93620_, this.f_93621_, 237, y, this.f_93618_, this.f_93619_);
            if (this.skill != null) {
                RenderSystem.m_69478_();
                RenderSystem.m_157456_((int)0, (ResourceLocation)this.skill.getSkillTexture());
                GuiComponent.m_93160_((PoseStack)PoseStack2, (int)(this.f_93620_ + 1), (int)(this.f_93621_ + 1), (int)16, (int)16, (float)0.0f, (float)0.0f, (int)128, (int)128, (int)128, (int)128);
            }
            if (this.m_198029_()) {
                this.m_7428_(PoseStack2, mouseX, mouseY);
            }
        }
    }

    class LearnSkillButton
    extends Button {
        private Skill skill;

        public LearnSkillButton(int x, int y, int width, int height, Skill skill, Component title, Button.OnPress pressedAction) {
            super(x, y, width, height, title, pressedAction, Button.f_93716_);
            this.skill = skill;
        }

        public void m_6305_(PoseStack PoseStack2, int mouseX, int mouseY, float partialTicks) {
            RenderSystem.m_157456_((int)0, (ResourceLocation)SKILL_EDIT_UI);
            this.f_93622_ = mouseX >= this.f_93620_ && mouseY >= this.f_93621_ && mouseX < this.f_93620_ + this.f_93618_ && mouseY < this.f_93621_ + this.f_93619_;
            int y = this.f_93622_ || !this.f_93623_ ? 224 : 200;
            this.m_93228_(PoseStack2, this.f_93620_, this.f_93621_, 0, y, this.f_93618_, this.f_93619_);
            RenderSystem.m_69478_();
            RenderSystem.m_157456_((int)0, (ResourceLocation)this.skill.getSkillTexture());
            GuiComponent.m_93160_((PoseStack)PoseStack2, (int)(this.f_93620_ + 5), (int)(this.f_93621_ + 4), (int)16, (int)16, (float)0.0f, (float)0.0f, (int)128, (int)128, (int)128, (int)128);
            LearnSkillButton.m_93243_((PoseStack)PoseStack2, (Font)SkillEditScreen.this.f_96547_, (Component)this.m_6035_(), (int)(this.f_93620_ + 26), (int)(this.f_93621_ + 2), (int)-1);
            if (this.f_93623_) {
                int color = ((SkillEditScreen)SkillEditScreen.this).f_96541_.f_91074_.f_36078_ >= this.skill.getRequiredXp() || ((SkillEditScreen)SkillEditScreen.this).f_96541_.f_91074_.m_7500_() ? 8453920 : 0xFF6060;
                LearnSkillButton.m_93243_((PoseStack)PoseStack2, (Font)SkillEditScreen.this.f_96547_, (Component)new TranslatableComponent("gui.epicfight.changing_cost", new Object[]{this.skill.getRequiredXp()}), (int)(this.f_93620_ + 70), (int)(this.f_93621_ + 12), (int)color);
            }
        }

        public LearnSkillButton setActive(boolean active) {
            this.f_93623_ = active;
            return this;
        }
    }
}

