/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.client.gui.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import yesman.epicfight.client.world.capabilites.entitypatch.player.LocalPlayerPatch;
import yesman.epicfight.network.EpicFightNetworkManager;
import yesman.epicfight.network.client.CPChangeSkill;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.item.SkillBookItem;

@OnlyIn(value=Dist.CLIENT)
public class SkillBookScreen
extends Screen {
    public static final ResourceLocation BACKGROUND = new ResourceLocation("epicfight", "textures/gui/screen/skillbook.png");
    private final Player opener;
    private final Skill skill;
    private final InteractionHand hand;

    public SkillBookScreen(Player opener, ItemStack stack, InteractionHand hand) {
        super(TextComponent.f_131282_);
        this.opener = opener;
        this.skill = SkillBookItem.getContainSkill(stack);
        this.hand = hand;
    }

    protected void m_7856_() {
        LocalPlayerPatch playerpatch = (LocalPlayerPatch)this.opener.getCapability(EpicFightCapabilities.CAPABILITY_ENTITY, null).orElse(null);
        boolean isUsing = this.skill.equals(playerpatch.getSkill(this.skill.getCategory()).getSkill());
        Skill priorSkill = this.skill.getPriorSkill();
        boolean condition = priorSkill == null ? true : playerpatch.getSkill(priorSkill.getCategory()).getSkill() == priorSkill;
        Button.OnTooltip tooltip = Button.f_93716_;
        if (!isUsing) {
            if (condition) {
                if (playerpatch.getSkill(this.skill.getCategory()).getSkill() != null) {
                    tooltip = (button, matrixStack, mouseX, mouseY) -> this.m_96617_(matrixStack, this.f_96541_.f_91062_.m_92923_((FormattedText)new TranslatableComponent("gui.epicfight.replace", new Object[]{new TranslatableComponent(this.skill.getTranslatableText()).getString()}), Math.max(this.f_96543_ / 2 - 43, 170)), mouseX, mouseY);
                }
            } else {
                tooltip = (button, matrixStack, mouseX, mouseY) -> this.m_96617_(matrixStack, this.f_96541_.f_91062_.m_92923_((FormattedText)new TranslatableComponent("gui.epicfight.require_learning", new Object[]{new TranslatableComponent(priorSkill.getTranslatableText()).getString()}), Math.max(this.f_96543_ / 2 - 43, 170)), mouseX, mouseY);
            }
        }
        Button changeButton = new Button((this.f_96543_ + 130) / 2, (this.f_96544_ + 90) / 2, 46, 20, (Component)new TranslatableComponent("gui.epicfight" + (isUsing ? ".applied" : (condition ? ".learn" : ".unusable"))), p_onPress_1_ -> {
            if (playerpatch != null) {
                playerpatch.getSkill(this.skill.getCategory()).setSkill(this.skill);
                this.f_96541_.m_91152_((Screen)null);
                playerpatch.getSkillCapability().addLearnedSkill(this.skill);
                int i = this.hand == InteractionHand.MAIN_HAND ? this.opener.m_150109_().f_35977_ : 40;
                EpicFightNetworkManager.sendToServer(new CPChangeSkill(this.skill.getCategory().universalOrdinal(), i, this.skill.toString(), false));
            }
        }, tooltip);
        if (isUsing || !condition) {
            changeButton.f_93623_ = false;
        }
        this.m_142416_((GuiEventListener)changeButton);
    }

    public void m_6305_(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.m_7333_(matrixStack);
        int posX = (this.f_96543_ - 250) / 2;
        int posY = (this.f_96544_ - 200) / 2;
        RenderSystem.m_157427_(GameRenderer::m_172820_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)BACKGROUND);
        this.m_93228_(matrixStack, posX, posY, 0, 0, 256, 181);
        RenderSystem.m_157456_((int)0, (ResourceLocation)this.skill.getSkillTexture());
        RenderSystem.m_69478_();
        GuiComponent.m_93160_((PoseStack)matrixStack, (int)(posX + 25), (int)(posY + 50), (int)50, (int)50, (float)0.0f, (float)0.0f, (int)64, (int)64, (int)64, (int)64);
        RenderSystem.m_69461_();
        String translationName = this.skill.getTranslatableText();
        String skillName = new TranslatableComponent(translationName).getString();
        int width = this.f_96547_.m_92895_(skillName);
        this.f_96547_.m_92883_(matrixStack, skillName, (float)(posX + 50 - width / 2), (float)(posY + 115), 0);
        String skillCategory = String.format("(%s)", new TranslatableComponent("skill.epicfight." + this.skill.getCategory().toString().toLowerCase() + ".category").getString());
        width = this.f_96547_.m_92895_(skillCategory);
        this.f_96547_.m_92883_(matrixStack, skillCategory, (float)(posX + 50 - width / 2), (float)(posY + 130), 0);
        List list = this.f_96547_.m_92923_((FormattedText)new TranslatableComponent(translationName + ".tooltip", this.skill.getTooltipArgs().toArray(new Object[0])), 140);
        int height = posY + 20;
        for (int l1 = 0; l1 < list.size(); ++l1) {
            FormattedCharSequence ireorderingprocessor1 = (FormattedCharSequence)list.get(l1);
            if (ireorderingprocessor1 != null) {
                this.f_96547_.m_92877_(matrixStack, ireorderingprocessor1, (float)(posX + 105), (float)height, 0);
            }
            height += 10;
        }
        super.m_6305_(matrixStack, mouseX, mouseY, partialTicks);
    }
}

