/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.client.gui;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix4f;
import java.util.Collection;
import java.util.Iterator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import yesman.epicfight.client.gui.EntityIndicator;
import yesman.epicfight.client.renderer.EpicFightRenderTypes;
import yesman.epicfight.main.EpicFightMod;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.EntityPatch;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.effect.VisibleMobEffect;

@OnlyIn(value=Dist.CLIENT)
public class HealthBarIndicator
extends EntityIndicator {
    @Override
    public boolean shouldDraw(LocalPlayer player, LivingEntity entityIn) {
        if (!EpicFightMod.CLIENT_INGAME_CONFIG.showHealthIndicator.getValue().booleanValue()) {
            return false;
        }
        if (!entityIn.m_6072_() || entityIn.m_20145_() || entityIn == player.m_20202_()) {
            return false;
        }
        if (entityIn.m_20280_(Minecraft.m_91087_().m_91288_()) >= 400.0) {
            return false;
        }
        if (entityIn instanceof Player) {
            Player playerIn = (Player)entityIn;
            if (playerIn == player) {
                return false;
            }
            if (playerIn.m_7500_() || playerIn.m_5833_()) {
                return false;
            }
        }
        return !(entityIn.m_21220_().isEmpty() && entityIn.m_21223_() >= entityIn.m_21233_()) && entityIn.f_20919_ < 19;
    }

    @Override
    public void drawIndicator(LivingEntity entityIn, PoseStack matStackIn, MultiBufferSource bufferIn, float partialTicks) {
        EntityPatch entitypatch;
        Matrix4f mvMatrix = super.getMVMatrix(matStackIn, entityIn, 0.0f, entityIn.m_20206_() + 0.25f, 0.0f, true, partialTicks);
        Collection activeEffects = entityIn.m_21220_();
        if (!activeEffects.isEmpty()) {
            Iterator iter = activeEffects.iterator();
            int acives = activeEffects.size();
            int row = acives > 1 ? 1 : 0;
            int column = (acives - 1) / 2;
            float startX = -0.8f + -0.3f * (float)row;
            float startY = -0.15f + 0.15f * (float)column;
            block0: for (int i = 0; i <= column; ++i) {
                for (int j = 0; j <= row; ++j) {
                    MobEffect effect = ((MobEffectInstance)iter.next()).m_19544_();
                    ResourceLocation rl = effect instanceof VisibleMobEffect ? ((VisibleMobEffect)effect).getIcon() : new ResourceLocation(effect.getRegistryName().m_135827_(), "textures/mob_effect/" + effect.getRegistryName().m_135815_() + ".png");
                    Minecraft.m_91087_().m_91097_().m_174784_(rl);
                    float x = startX + 0.3f * (float)j;
                    float y = startY + -0.3f * (float)i;
                    VertexConsumer vertexBuilder1 = bufferIn.m_6299_(EpicFightRenderTypes.entityIndicator(rl));
                    this.drawTexturedModalRect2DPlane(mvMatrix, vertexBuilder1, x, y, x + 0.3f, y + 0.3f, 0.0f, 0.0f, 256.0f, 256.0f);
                    if (!iter.hasNext()) continue block0;
                }
            }
        }
        VertexConsumer vertexBuilder = bufferIn.m_6299_(EpicFightRenderTypes.entityIndicator(BATTLE_ICON));
        float ratio = entityIn.m_21223_() / entityIn.m_21233_();
        float healthRatio = -0.5f + ratio;
        int textureRatio = (int)(62.0f * ratio);
        this.drawTexturedModalRect2DPlane(mvMatrix, vertexBuilder, -0.5f, -0.05f, healthRatio, 0.05f, 1.0f, 15.0f, textureRatio, 20.0f);
        this.drawTexturedModalRect2DPlane(mvMatrix, vertexBuilder, healthRatio, -0.05f, 0.5f, 0.05f, textureRatio, 10.0f, 62.0f, 15.0f);
        float absorption = entityIn.m_6103_();
        if ((double)absorption > 0.0) {
            float absorptionRatio = absorption / entityIn.m_21233_();
            int absTexRatio = (int)(62.0f * absorptionRatio);
            this.drawTexturedModalRect2DPlane(mvMatrix, vertexBuilder, -0.5f, -0.05f, absorptionRatio - 0.5f, 0.05f, 1.0f, 20.0f, absTexRatio, 25.0f);
        }
        if ((entitypatch = (EntityPatch)entityIn.getCapability(EpicFightCapabilities.CAPABILITY_ENTITY, null).orElse(null)) != null && entitypatch instanceof LivingEntityPatch) {
            this.renderStunShield((LivingEntityPatch)entitypatch, mvMatrix, vertexBuilder);
        }
    }

    private void renderStunShield(LivingEntityPatch<?> entitypatch, Matrix4f mvMatrix, VertexConsumer vertexBuilder) {
        if (entitypatch.getStunShield() == 0.0f) {
            return;
        }
        float ratio = entitypatch.getStunShield() / entitypatch.getStunArmor();
        float barRatio = -0.5f + ratio;
        int textureRatio = (int)(62.0f * ratio);
        this.drawTexturedModalRect2DPlane(mvMatrix, vertexBuilder, -0.5f, -0.1f, barRatio, -0.05f, 1.0f, 5.0f, textureRatio, 10.0f);
        this.drawTexturedModalRect2DPlane(mvMatrix, vertexBuilder, barRatio, -0.1f, 0.5f, -0.05f, textureRatio, 0.0f, 63.0f, 5.0f);
    }
}

