/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.client.gui;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import java.util.List;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import yesman.epicfight.api.utils.math.OpenMatrix4f;
import yesman.epicfight.api.utils.math.Vec3f;
import yesman.epicfight.client.gui.HealthBarIndicator;
import yesman.epicfight.client.gui.ModIngameGui;
import yesman.epicfight.client.gui.TargetIndicator;

@OnlyIn(value=Dist.CLIENT)
public abstract class EntityIndicator
extends ModIngameGui {
    public static final List<EntityIndicator> ENTITY_INDICATOR_RENDERERS = Lists.newArrayList();
    public static final ResourceLocation BATTLE_ICON = new ResourceLocation("epicfight", "textures/gui/battle_icons.png");

    public static void init() {
        new TargetIndicator();
        new HealthBarIndicator();
    }

    public void drawTexturedModalRect2DPlane(Matrix4f matrix, VertexConsumer vertexBuilder, float minX, float minY, float maxX, float maxY, float minTexU, float minTexV, float maxTexU, float maxTexV) {
        this.drawTexturedModalRect3DPlane(matrix, vertexBuilder, minX, minY, this.m_93252_(), maxX, maxY, this.m_93252_(), minTexU, minTexV, maxTexU, maxTexV);
    }

    public void drawTexturedModalRect3DPlane(Matrix4f matrix, VertexConsumer vertexBuilder, float minX, float minY, float minZ, float maxX, float maxY, float maxZ, float minTexU, float minTexV, float maxTexU, float maxTexV) {
        float cor = 0.00390625f;
        vertexBuilder.m_85982_(matrix, minX, minY, maxZ).m_7421_(minTexU * cor, maxTexV * cor).m_5752_();
        vertexBuilder.m_85982_(matrix, maxX, minY, maxZ).m_7421_(maxTexU * cor, maxTexV * cor).m_5752_();
        vertexBuilder.m_85982_(matrix, maxX, maxY, minZ).m_7421_(maxTexU * cor, minTexV * cor).m_5752_();
        vertexBuilder.m_85982_(matrix, minX, maxY, minZ).m_7421_(minTexU * cor, minTexV * cor).m_5752_();
    }

    public EntityIndicator() {
        ENTITY_INDICATOR_RENDERERS.add(this);
    }

    public final Matrix4f getMVMatrix(PoseStack matStackIn, LivingEntity entityIn, float correctionX, float correctionY, float correctionZ, boolean lockRotation, float partialTicks) {
        float posX = (float)Mth.m_14139_((double)partialTicks, (double)entityIn.f_19790_, (double)entityIn.m_20185_());
        float posY = (float)Mth.m_14139_((double)partialTicks, (double)entityIn.f_19791_, (double)entityIn.m_20186_());
        float posZ = (float)Mth.m_14139_((double)partialTicks, (double)entityIn.f_19792_, (double)entityIn.m_20189_());
        matStackIn.m_85836_();
        matStackIn.m_85837_((double)(-posX), (double)(-posY), (double)(-posZ));
        matStackIn.m_85845_(Vector3f.f_122225_.m_122240_(180.0f));
        return this.getMVMatrix(matStackIn, posX + correctionX, posY + correctionY, posZ + correctionZ, lockRotation);
    }

    public final Matrix4f getMVMatrix(PoseStack matStackIn, float posX, float posY, float posZ, boolean lockRotation) {
        OpenMatrix4f viewMatrix = OpenMatrix4f.importFromMojangMatrix(matStackIn.m_85850_().m_85861_());
        OpenMatrix4f finalMatrix = new OpenMatrix4f();
        finalMatrix.translate(new Vec3f(-posX, posY, -posZ));
        matStackIn.m_85849_();
        if (lockRotation) {
            finalMatrix.m00 = viewMatrix.m00;
            finalMatrix.m01 = viewMatrix.m10;
            finalMatrix.m02 = viewMatrix.m20;
            finalMatrix.m10 = viewMatrix.m01;
            finalMatrix.m11 = viewMatrix.m11;
            finalMatrix.m12 = viewMatrix.m21;
            finalMatrix.m20 = viewMatrix.m02;
            finalMatrix.m21 = viewMatrix.m12;
            finalMatrix.m22 = viewMatrix.m22;
        }
        finalMatrix.mulFront(viewMatrix);
        return OpenMatrix4f.exportToMojangMatrix(finalMatrix);
    }

    public abstract void drawIndicator(LivingEntity var1, PoseStack var2, MultiBufferSource var3, float var4);

    public abstract boolean shouldDraw(LocalPlayer var1, LivingEntity var2);
}

