/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.api.utils.math;

public class ValueCorrector {
    private float adders;
    private float multipliers;
    private float setters;

    public ValueCorrector(float adder, float multiplier, float setter) {
        this.adders = adder;
        this.multipliers = multiplier;
        this.setters = setter;
    }

    public void merge(ValueCorrector valueCorrector) {
        this.adders += valueCorrector.adders;
        this.multipliers *= valueCorrector.multipliers;
        this.setters += valueCorrector.setters;
    }

    public float getTotalValue(float value) {
        return this.setters == 0.0f ? value * this.multipliers + this.adders : this.setters;
    }

    public String toString() {
        return this.setters == 0.0f ? String.format("%.0f%%", Float.valueOf(this.multipliers * 100.0f)) + (this.adders == 0.0f ? "" : String.format(" + %.1f", Float.valueOf(this.adders))) : String.format("%.0f", Float.valueOf(this.setters));
    }

    public static ValueCorrector empty() {
        return new ValueCorrector(0.0f, 1.0f, 0.0f);
    }

    public static ValueCorrector adder(float arg) {
        return new ValueCorrector(arg, 1.0f, 0.0f);
    }

    public static ValueCorrector multiplier(float arg) {
        return new ValueCorrector(0.0f, arg, 0.0f);
    }

    public static ValueCorrector setter(float arg) {
        return new ValueCorrector(0.0f, 1.0f, arg);
    }
}

