/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.api.utils.math;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import yesman.epicfight.api.utils.math.OpenMatrix4f;
import yesman.epicfight.api.utils.math.Vec3f;

public class MathUtils {
    public static OpenMatrix4f getModelMatrixIntegral(float prevPosX, float posX, float prevPosY, float posY, float prevPosZ, float posZ, float prevPitch, float pitch, float prevYaw, float yaw, float partialTick, float scaleX, float scaleY, float scaleZ) {
        OpenMatrix4f modelMatrix = new OpenMatrix4f();
        Vec3f entityPosition = new Vec3f(-(prevPosX + (posX - prevPosX) * partialTick), prevPosY + (posY - prevPosY) * partialTick, -(prevPosZ + (posZ - prevPosZ) * partialTick));
        float pitchDegree = MathUtils.lerpBetween(prevPitch, pitch, partialTick);
        float yawDegree = MathUtils.lerpBetween(prevYaw, yaw, partialTick);
        modelMatrix.translate(entityPosition).rotateDeg(-yawDegree, Vec3f.Y_AXIS).rotateDeg(-pitchDegree, Vec3f.X_AXIS).scale(scaleX, scaleY, scaleZ);
        return modelMatrix;
    }

    public static Vec3 getVectorForRotation(float pitch, float yaw) {
        float f = pitch * ((float)Math.PI / 180);
        float f1 = -yaw * ((float)Math.PI / 180);
        float f2 = Mth.m_14089_((float)f1);
        float f3 = Mth.m_14031_((float)f1);
        float f4 = Mth.m_14089_((float)f);
        float f5 = Mth.m_14031_((float)f);
        return new Vec3((double)(f3 * f4), (double)(-f5), (double)(f2 * f4));
    }

    public static float lerpBetween(float f1, float f2, float zero2one) {
        float f = 0.0f;
        for (f = f2 - f1; f < -180.0f; f += 360.0f) {
        }
        while (f >= 180.0f) {
            f -= 360.0f;
        }
        return f1 + zero2one * f;
    }

    public static float rotlerp(float from, float to, float limit) {
        float f1;
        float f = Mth.m_14177_((float)(to - from));
        if (f > limit) {
            f = limit;
        }
        if (f < -limit) {
            f = -limit;
        }
        for (f1 = from + f; f1 >= 180.0f; f1 -= 360.0f) {
        }
        while (f1 <= -180.0f) {
            f1 += 360.0f;
        }
        return f1;
    }

    public static void translateStack(PoseStack mStack, OpenMatrix4f mat) {
        Vector3f vector = new Vector3f(mat.m30, mat.m31, mat.m32);
        mStack.m_85837_((double)vector.m_122239_(), (double)vector.m_122260_(), (double)vector.m_122269_());
    }

    public static void rotateStack(PoseStack mStack, OpenMatrix4f mat) {
        mStack.m_85845_(MathUtils.getQuaternionFromMatrix(mat));
    }

    public static void scaleStack(PoseStack mStack, OpenMatrix4f mat) {
        Vector3f vector = MathUtils.getScaleVectorFromMatrix(mat);
        mStack.m_85841_(vector.m_122239_(), vector.m_122260_(), vector.m_122269_());
    }

    public static double getAngleBetween(Vec3f a, Vec3f b) {
        double cos = a.x * b.x + a.y * b.y + a.z * b.z;
        return Math.acos(cos);
    }

    private static Quaternion getQuaternionFromMatrix(OpenMatrix4f mat) {
        float z;
        float y;
        float x;
        float w;
        float diagonal = mat.m00 + mat.m11 + mat.m22;
        if (diagonal > 0.0f) {
            float w4 = (float)(Math.sqrt(diagonal + 1.0f) * 2.0);
            w = w4 * 0.25f;
            x = (mat.m21 - mat.m12) / w4;
            y = (mat.m02 - mat.m20) / w4;
            z = (mat.m10 - mat.m01) / w4;
        } else if (mat.m00 > mat.m11 && mat.m00 > mat.m22) {
            float x4 = (float)(Math.sqrt(1.0f + mat.m00 - mat.m11 - mat.m22) * 2.0);
            w = (mat.m21 - mat.m12) / x4;
            x = x4 * 0.25f;
            y = (mat.m01 + mat.m10) / x4;
            z = (mat.m02 + mat.m20) / x4;
        } else if (mat.m11 > mat.m22) {
            float y4 = (float)(Math.sqrt(1.0f + mat.m11 - mat.m00 - mat.m22) * 2.0);
            w = (mat.m02 - mat.m20) / y4;
            x = (mat.m01 + mat.m10) / y4;
            y = y4 * 0.25f;
            z = (mat.m12 + mat.m21) / y4;
        } else {
            float z4 = (float)(Math.sqrt(1.0f + mat.m22 - mat.m00 - mat.m11) * 2.0);
            w = (mat.m10 - mat.m01) / z4;
            x = (mat.m02 + mat.m20) / z4;
            y = (mat.m12 + mat.m21) / z4;
            z = z4 * 0.25f;
        }
        Quaternion quat = new Quaternion(x, y, z, w);
        quat.m_80160_();
        return quat;
    }

    public static Vec3f lerpVector(Vec3f start, Vec3f end, float weight) {
        float x = start.x + (end.x - start.x) * weight;
        float y = start.y + (end.y - start.y) * weight;
        float z = start.z + (end.z - start.z) * weight;
        return new Vec3f(x, y, z);
    }

    public static Vec3 projectVector(Vec3 from, Vec3 to) {
        double dot = to.m_82526_(from);
        double normalScale = 1.0 / (to.f_82479_ * to.f_82479_ + to.f_82480_ * to.f_82480_ + to.f_82481_ * to.f_82481_);
        return new Vec3(dot * to.f_82479_ * normalScale, dot * to.f_82480_ * normalScale, dot * to.f_82481_ * normalScale);
    }

    public static void setQuaternion(Quaternion quat, float x, float y, float z, float w) {
        quat.f_80119_ = x;
        quat.f_80120_ = y;
        quat.f_80121_ = z;
        quat.f_80122_ = w;
    }

    public static Quaternion mulQuaternion(Quaternion left, Quaternion right, Quaternion dest) {
        if (dest == null) {
            dest = new Quaternion(0.0f, 0.0f, 0.0f, 1.0f);
        }
        float f = left.m_80140_();
        float f1 = left.m_80150_();
        float f2 = left.m_80153_();
        float f3 = left.m_80156_();
        float f4 = right.m_80140_();
        float f5 = right.m_80150_();
        float f6 = right.m_80153_();
        float f7 = right.m_80156_();
        float i = f3 * f4 + f * f7 + f1 * f6 - f2 * f5;
        float j = f3 * f5 - f * f6 + f1 * f7 + f2 * f4;
        float k = f3 * f6 + f * f5 - f1 * f4 + f2 * f7;
        float r = f3 * f7 - f * f4 - f1 * f5 - f2 * f6;
        dest.m_80143_(i, j, k, r);
        return dest;
    }

    public static Quaternion lerpQuaternion(Quaternion from, Quaternion to, float weight) {
        float resultZ;
        float resultY;
        float resultX;
        float resultW;
        float fromX = from.m_80140_();
        float fromY = from.m_80150_();
        float fromZ = from.m_80153_();
        float fromW = from.m_80156_();
        float toX = to.m_80140_();
        float toY = to.m_80150_();
        float toZ = to.m_80153_();
        float toW = to.m_80156_();
        float dot = fromW * toW + fromX * toX + fromY * toY + fromZ * toZ;
        float blendI = 1.0f - weight;
        if (dot < 0.0f) {
            resultW = blendI * fromW + weight * -toW;
            resultX = blendI * fromX + weight * -toX;
            resultY = blendI * fromY + weight * -toY;
            resultZ = blendI * fromZ + weight * -toZ;
        } else {
            resultW = blendI * fromW + weight * toW;
            resultX = blendI * fromX + weight * toX;
            resultY = blendI * fromY + weight * toY;
            resultZ = blendI * fromZ + weight * toZ;
        }
        Quaternion result = new Quaternion(resultX, resultY, resultZ, resultW);
        MathUtils.normalizeQuaternion(result);
        return result;
    }

    private static void normalizeQuaternion(Quaternion quaternion) {
        float f = quaternion.m_80140_() * quaternion.m_80140_() + quaternion.m_80150_() * quaternion.m_80150_() + quaternion.m_80153_() * quaternion.m_80153_() + quaternion.m_80156_() * quaternion.m_80156_();
        if (f > 1.0E-6f) {
            float f1 = MathUtils.fastInvSqrt(f);
            MathUtils.setQuaternion(quaternion, quaternion.m_80140_() * f1, quaternion.m_80150_() * f1, quaternion.m_80153_() * f1, quaternion.m_80156_() * f1);
        } else {
            MathUtils.setQuaternion(quaternion, 0.0f, 0.0f, 0.0f, 0.0f);
        }
    }

    private static Vector3f getScaleVectorFromMatrix(OpenMatrix4f mat) {
        Vec3f a = new Vec3f(mat.m00, mat.m10, mat.m20);
        Vec3f b = new Vec3f(mat.m01, mat.m11, mat.m21);
        Vec3f c = new Vec3f(mat.m02, mat.m12, mat.m22);
        return new Vector3f(a.length(), b.length(), c.length());
    }

    private static float fastInvSqrt(float number) {
        float f = 0.5f * number;
        int i = Float.floatToIntBits(number);
        i = 1597463007 - (i >> 1);
        number = Float.intBitsToFloat(i);
        return number * (1.5f - f * number * number);
    }
}

