/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.api.collider;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import yesman.epicfight.api.animation.types.AttackAnimation;
import yesman.epicfight.api.collider.Collider;
import yesman.epicfight.api.utils.math.OpenMatrix4f;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;

public class PlaneCollider
extends Collider {
    private Vec3[] modelPos;
    private Vec3[] worldPos;

    public PlaneCollider(Vec3 center, AABB entityCallAABB) {
        super(center, entityCallAABB);
    }

    public PlaneCollider(AABB entityCallAABB, double centerX, double centerY, double centerZ, double pos1X, double pos1Y, double pos1Z, double pos2X, double pos2Y, double pos2Z) {
        super(new Vec3(centerX, centerY, centerZ), entityCallAABB);
        this.modelPos = new Vec3[2];
        this.worldPos = new Vec3[2];
        this.modelPos[0] = new Vec3(pos1X, pos1Y, pos1Z);
        this.modelPos[1] = new Vec3(pos2X, pos2Y, pos2Z);
        this.worldPos[0] = new Vec3(0.0, 0.0, 0.0);
        this.worldPos[1] = new Vec3(0.0, 0.0, 0.0);
    }

    @Override
    public boolean isCollide(Entity entity) {
        AABB opponent = entity.m_142469_();
        Vec3 planeNorm = this.worldPos[0].m_82537_(this.worldPos[1]);
        Vec3 pos = new Vec3(planeNorm.f_82479_ >= 0.0 ? opponent.f_82291_ : opponent.f_82288_, planeNorm.f_82480_ >= 0.0 ? opponent.f_82292_ : opponent.f_82289_, planeNorm.f_82481_ >= 0.0 ? opponent.f_82293_ : opponent.f_82290_);
        Vec3 neg = new Vec3(planeNorm.f_82479_ >= 0.0 ? opponent.f_82288_ : opponent.f_82291_, planeNorm.f_82480_ >= 0.0 ? opponent.f_82289_ : opponent.f_82292_, planeNorm.f_82481_ >= 0.0 ? opponent.f_82290_ : opponent.f_82293_);
        double planeD = planeNorm.m_82526_(this.worldCenter);
        double dot1 = planeNorm.m_82526_(pos) - planeD;
        if (dot1 < 0.0) {
            return false;
        }
        double dot2 = planeNorm.m_82526_(neg) - planeD;
        return !(dot2 > 0.0);
    }

    @Override
    public void transform(OpenMatrix4f mat) {
        for (int i = 0; i < 2; ++i) {
            this.worldPos[i] = OpenMatrix4f.transform(mat.removeTranslation(), this.modelPos[i]);
        }
        super.transform(mat);
    }

    @Override
    public void drawInternal(PoseStack matrixStackIn, MultiBufferSource buffer, OpenMatrix4f pose, boolean red) {
    }

    @Override
    public void draw(PoseStack matrixStackIn, MultiBufferSource buffer, LivingEntityPatch<?> entitypatch, AttackAnimation animation, float prevElapsedTime, float elapsedTime, float partialTicks, float attackSpeed) {
    }
}

