/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.api.collider;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix4f;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import yesman.epicfight.api.collider.Collider;
import yesman.epicfight.api.utils.math.MathUtils;
import yesman.epicfight.api.utils.math.OpenMatrix4f;
import yesman.epicfight.client.renderer.EpicFightRenderTypes;

public class LineCollider
extends Collider {
    protected Vec3 modelVec;
    protected Vec3 worldVec;

    public LineCollider(double posX, double posY, double posZ, double vecX, double vecY, double vecZ) {
        this(LineCollider.getInitialAABB(posX, posY, posZ, vecX, vecY, vecZ), posX, posY, posZ, vecX, vecY, vecZ);
    }

    public LineCollider(AABB outerAABB, double posX, double posY, double posZ, double vecX, double vecY, double vecZ) {
        super(new Vec3(posX, posY, posZ), outerAABB);
        this.modelVec = new Vec3(vecX, vecY, vecZ);
        this.worldVec = new Vec3(0.0, 0.0, 0.0);
    }

    static AABB getInitialAABB(double posX, double posY, double posZ, double vecX, double vecY, double vecZ) {
        Vec3 start = new Vec3(posX, posY, posZ);
        Vec3 end = new Vec3(vecX + posX, vecY + posY, vecZ + posZ);
        double length = Math.max(start.m_82553_(), end.m_82553_());
        return new AABB(length, length, length, -length, -length, -length);
    }

    @Override
    public void transform(OpenMatrix4f mat) {
        this.worldVec = OpenMatrix4f.transform(mat.removeTranslation(), this.modelVec);
        super.transform(mat);
    }

    @Override
    public boolean isCollide(Entity entity) {
        double endZ;
        double endY;
        double maxStart;
        double minEnd;
        double temp;
        double endX;
        AABB opponent = entity.m_142469_();
        if (this.worldVec.f_82479_ == 0.0 && (this.worldCenter.f_82479_ < opponent.f_82288_ || this.worldCenter.f_82479_ > opponent.f_82291_)) {
            return false;
        }
        double startX = Mth.m_14008_((double)((opponent.f_82288_ + this.worldCenter.f_82479_) / -this.worldVec.f_82479_), (double)0.0, (double)1.0);
        if (startX > (endX = Mth.m_14008_((double)((opponent.f_82291_ + this.worldCenter.f_82479_) / -this.worldVec.f_82479_), (double)0.0, (double)1.0))) {
            temp = startX;
            startX = endX;
            endX = temp;
        }
        if ((minEnd = endX) == (maxStart = startX)) {
            return false;
        }
        if (this.worldVec.f_82480_ == 0.0 && (this.worldCenter.f_82480_ < opponent.f_82289_ || this.worldCenter.f_82480_ > opponent.f_82292_)) {
            return false;
        }
        double startY = Mth.m_14008_((double)((double)((float)(opponent.f_82289_ - this.worldCenter.f_82480_)) / this.worldVec.f_82480_), (double)0.0, (double)1.0);
        if (startY > (endY = Mth.m_14008_((double)((double)((float)(opponent.f_82292_ - this.worldCenter.f_82480_)) / this.worldVec.f_82480_), (double)0.0, (double)1.0))) {
            temp = startY;
            startY = endY;
            endY = temp;
        }
        maxStart = maxStart < startY ? startY : maxStart;
        double d = minEnd = minEnd > endY ? endY : minEnd;
        if (maxStart >= minEnd) {
            return false;
        }
        if (this.worldVec.f_82481_ == 0.0 && (this.worldCenter.f_82481_ < opponent.f_82290_ || this.worldCenter.f_82481_ > opponent.f_82293_)) {
            return false;
        }
        double startZ = Mth.m_14008_((double)((double)((float)(opponent.f_82290_ + this.worldCenter.f_82481_)) / -this.worldVec.f_82481_), (double)0.0, (double)1.0);
        if (startZ > (endZ = Mth.m_14008_((double)((double)((float)(opponent.f_82293_ + this.worldCenter.f_82481_)) / -this.worldVec.f_82481_), (double)0.0, (double)1.0))) {
            temp = startZ;
            startZ = endZ;
            endZ = temp;
        }
        maxStart = maxStart < startZ ? startZ : maxStart;
        double d2 = minEnd = minEnd > endZ ? endZ : minEnd;
        return !(maxStart >= minEnd);
    }

    @Override
    public void drawInternal(PoseStack matrixStackIn, MultiBufferSource buffer, OpenMatrix4f pose, boolean red) {
        VertexConsumer vertexBuilder = buffer.m_6299_(EpicFightRenderTypes.debugCollider());
        OpenMatrix4f transpose = new OpenMatrix4f();
        OpenMatrix4f.transpose(pose, transpose);
        MathUtils.translateStack(matrixStackIn, pose);
        MathUtils.rotateStack(matrixStackIn, transpose);
        Matrix4f matrix = matrixStackIn.m_85850_().m_85861_();
        float startX = (float)this.modelCenter.f_82479_;
        float startY = (float)this.modelCenter.f_82480_;
        float startZ = (float)this.modelCenter.f_82481_;
        float endX = (float)(this.modelCenter.f_82479_ + this.modelVec.f_82479_);
        float endY = (float)(this.modelCenter.f_82480_ + this.modelVec.f_82480_);
        float endZ = (float)(this.modelCenter.f_82481_ + this.modelVec.f_82481_);
        float color = red ? 0.0f : 1.0f;
        vertexBuilder.m_85982_(matrix, startX, startY, startZ).m_85950_(1.0f, color, color, 1.0f).m_5752_();
        vertexBuilder.m_85982_(matrix, endX, endY, endZ).m_85950_(1.0f, color, color, 1.0f).m_5752_();
    }
}

