/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.api.collider;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.entity.PartEntity;
import yesman.epicfight.api.animation.Animator;
import yesman.epicfight.api.animation.types.AttackAnimation;
import yesman.epicfight.api.model.Armature;
import yesman.epicfight.api.utils.math.OpenMatrix4f;
import yesman.epicfight.gameasset.Models;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;

public abstract class Collider {
    protected final Vec3 modelCenter;
    protected final AABB outerAABB;
    protected Vec3 worldCenter;

    public Collider(Vec3 center, @Nullable AABB outerAABB) {
        this.modelCenter = center;
        this.outerAABB = outerAABB;
        this.worldCenter = new Vec3(0.0, 0.0, 0.0);
    }

    protected void transform(OpenMatrix4f mat) {
        this.worldCenter = OpenMatrix4f.transform(mat, this.modelCenter);
    }

    public List<Entity> updateAndSelectCollideEntity(LivingEntityPatch<?> entitypatch, AttackAnimation attackAnimation, float prevElapsedTime, float elapsedTime, String jointName, float attackSpeed) {
        Armature armature = entitypatch.getEntityModel(Models.LOGICAL_SERVER).getArmature();
        int pathIndex = armature.searchPathIndex(jointName);
        OpenMatrix4f transformMatrix = pathIndex == -1 ? new OpenMatrix4f() : Animator.getBindedJointTransformByIndex(attackAnimation.getPoseByTime(entitypatch, elapsedTime, 1.0f), armature, pathIndex);
        OpenMatrix4f toWorldCoord = OpenMatrix4f.createTranslation(-((float)((LivingEntity)entitypatch.getOriginal()).m_20185_()), (float)((LivingEntity)entitypatch.getOriginal()).m_20186_(), -((float)((LivingEntity)entitypatch.getOriginal()).m_20189_()));
        transformMatrix.mulFront(toWorldCoord.mulBack(entitypatch.getModelMatrix(1.0f)));
        this.transform(transformMatrix);
        return this.getCollideEntities((Entity)entitypatch.getOriginal());
    }

    public List<Entity> getCollideEntities(Entity entity) {
        List list = entity.f_19853_.m_6249_(entity, this.getHitboxAABB(), e -> {
            if (e instanceof PartEntity && ((PartEntity)e).getParent().m_7306_(entity)) {
                return false;
            }
            return this.isCollide((Entity)e);
        });
        return list;
    }

    @OnlyIn(value=Dist.CLIENT)
    public abstract void drawInternal(PoseStack var1, MultiBufferSource var2, OpenMatrix4f var3, boolean var4);

    @OnlyIn(value=Dist.CLIENT)
    public void draw(PoseStack matrixStackIn, MultiBufferSource buffer, LivingEntityPatch<?> entitypatch, AttackAnimation animation, float prevElapsedTime, float elapsedTime, float partialTicks, float attackSpeed) {
        Armature armature = entitypatch.getEntityModel(Models.LOGICAL_SERVER).getArmature();
        int pathIndex = armature.searchPathIndex(animation.getPathIndexByTime(elapsedTime));
        boolean flag3 = entitypatch.getEntityState().attacking();
        OpenMatrix4f mat = null;
        mat = pathIndex == -1 ? new OpenMatrix4f() : Animator.getBindedJointTransformByIndex(animation.getPoseByTime(entitypatch, elapsedTime, 0.0f), armature, pathIndex);
        this.drawInternal(matrixStackIn, buffer, mat, flag3);
    }

    protected abstract boolean isCollide(Entity var1);

    protected AABB getHitboxAABB() {
        return this.outerAABB.m_82386_(-this.worldCenter.f_82479_, this.worldCenter.f_82480_, -this.worldCenter.f_82481_);
    }

    public String toString() {
        return "[ColliderInfo] type: " + this.getClass() + " center: " + this.modelCenter;
    }
}

