/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.api.client.model;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.ArrayUtils;
import yesman.epicfight.api.client.model.Mesh;
import yesman.epicfight.api.utils.math.Vec2f;
import yesman.epicfight.api.utils.math.Vec3f;

@OnlyIn(value=Dist.CLIENT)
public class CustomArmorVertex {
    private Vec3f position;
    private Vec3f normal;
    private Vec2f textureCoordinate;
    private Vec3f effectiveJointIDs;
    private Vec3f effectiveJointWeights;
    private int effectiveJointNumber;

    public CustomArmorVertex() {
        this.position = null;
        this.normal = null;
        this.textureCoordinate = null;
    }

    public CustomArmorVertex(CustomArmorVertex vertex) {
        this.position = vertex.position;
        this.effectiveJointIDs = vertex.effectiveJointIDs;
        this.effectiveJointWeights = vertex.effectiveJointWeights;
        this.effectiveJointNumber = vertex.effectiveJointNumber;
    }

    public CustomArmorVertex setPosition(Vec3f position) {
        this.position = position;
        return this;
    }

    public CustomArmorVertex setNormal(Vec3f vector) {
        this.normal = vector;
        return this;
    }

    public CustomArmorVertex setTextureCoordinate(Vec2f vector) {
        this.textureCoordinate = vector;
        return this;
    }

    public CustomArmorVertex setEffectiveJointIDs(Vec3f effectiveJointIDs) {
        this.effectiveJointIDs = effectiveJointIDs;
        return this;
    }

    public CustomArmorVertex setEffectiveJointWeights(Vec3f effectiveJointWeights) {
        this.effectiveJointWeights = effectiveJointWeights;
        return this;
    }

    public CustomArmorVertex setEffectiveJointNumber(int count) {
        this.effectiveJointNumber = count;
        return this;
    }

    public State compareTextureCoordinateAndNormal(Vec3f normal, Vec2f textureCoord) {
        if (this.textureCoordinate == null) {
            return State.EMPTY;
        }
        if (this.textureCoordinate.equals(textureCoord) && this.normal.equals(normal)) {
            return State.EQUAL;
        }
        return State.DIFFERENT;
    }

    public static Mesh loadVertexInformation(List<CustomArmorVertex> vertices, int[] indices) {
        ArrayList positions = Lists.newArrayList();
        ArrayList normals = Lists.newArrayList();
        ArrayList texCoords = Lists.newArrayList();
        ArrayList animationIndices = Lists.newArrayList();
        ArrayList jointWeights = Lists.newArrayList();
        ArrayList affectCountList = Lists.newArrayList();
        for (int i = 0; i < vertices.size(); ++i) {
            CustomArmorVertex vertex = vertices.get(i);
            Vec3f position = vertex.position;
            Vec3f normal = vertex.normal;
            Vec2f texCoord = vertex.textureCoordinate;
            positions.add(Float.valueOf(position.x));
            positions.add(Float.valueOf(position.y));
            positions.add(Float.valueOf(position.z));
            normals.add(Float.valueOf(normal.x));
            normals.add(Float.valueOf(normal.y));
            normals.add(Float.valueOf(normal.z));
            texCoords.add(Float.valueOf(texCoord.x));
            texCoords.add(Float.valueOf(texCoord.y));
            Vec3f effectIDs = vertex.effectiveJointIDs;
            Vec3f weights = vertex.effectiveJointWeights;
            int count = Math.min(vertex.effectiveJointNumber, 3);
            affectCountList.add(count);
            block6: for (int j = 0; j < count; ++j) {
                switch (j) {
                    case 0: {
                        animationIndices.add((int)effectIDs.x);
                        jointWeights.add(Float.valueOf(weights.x));
                        animationIndices.add(jointWeights.size() - 1);
                        continue block6;
                    }
                    case 1: {
                        animationIndices.add((int)effectIDs.y);
                        jointWeights.add(Float.valueOf(weights.y));
                        animationIndices.add(jointWeights.size() - 1);
                        continue block6;
                    }
                    case 2: {
                        animationIndices.add((int)effectIDs.z);
                        jointWeights.add(Float.valueOf(weights.z));
                        animationIndices.add(jointWeights.size() - 1);
                        continue block6;
                    }
                }
            }
        }
        float[] positionList = ArrayUtils.toPrimitive((Float[])positions.toArray(new Float[0]));
        float[] normalList = ArrayUtils.toPrimitive((Float[])normals.toArray(new Float[0]));
        float[] texCoordList = ArrayUtils.toPrimitive((Float[])texCoords.toArray(new Float[0]));
        int[] animationIndexList = ArrayUtils.toPrimitive((Integer[])animationIndices.toArray(new Integer[0]));
        float[] jointWeightList = ArrayUtils.toPrimitive((Float[])jointWeights.toArray(new Float[0]));
        int[] affectJointCounts = ArrayUtils.toPrimitive((Integer[])affectCountList.toArray(new Integer[0]));
        return new Mesh(positionList, normalList, texCoordList, animationIndexList, jointWeightList, indices, affectJointCounts);
    }

    public static enum State {
        EMPTY,
        EQUAL,
        DIFFERENT;

    }
}

