/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.api.animation.types;

import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.world.InteractionHand;
import yesman.epicfight.api.animation.Animator;
import yesman.epicfight.api.animation.Pose;
import yesman.epicfight.api.animation.property.AnimationProperty;
import yesman.epicfight.api.animation.types.AttackAnimation;
import yesman.epicfight.api.animation.types.DynamicAnimation;
import yesman.epicfight.api.animation.types.LinkAnimation;
import yesman.epicfight.api.collider.Collider;
import yesman.epicfight.api.model.Model;
import yesman.epicfight.api.utils.math.Vec3f;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;

public class BasicAttackAnimation
extends AttackAnimation {
    public BasicAttackAnimation(float convertTime, float antic, float contact, float recovery, @Nullable Collider collider, String index, String path, Model model) {
        this(convertTime, antic, antic, contact, recovery, collider, index, path, model);
    }

    public BasicAttackAnimation(float convertTime, float antic, float preDelay, float contact, float recovery, @Nullable Collider collider, String index, String path, Model model) {
        super(convertTime, antic, preDelay, contact, recovery, collider, index, path, model);
        this.addProperty(AnimationProperty.AttackAnimationProperty.ROTATE_X, Boolean.valueOf(true));
        this.addProperty(AnimationProperty.ActionAnimationProperty.CANCELABLE_MOVE, Boolean.valueOf(true));
    }

    public BasicAttackAnimation(float convertTime, float antic, float contact, float recovery, InteractionHand hand, @Nullable Collider collider, String index, String path, Model model) {
        super(convertTime, antic, antic, contact, recovery, hand, collider, index, path, model);
        this.addProperty(AnimationProperty.AttackAnimationProperty.ROTATE_X, Boolean.valueOf(true));
        this.addProperty(AnimationProperty.ActionAnimationProperty.CANCELABLE_MOVE, Boolean.valueOf(true));
    }

    @Override
    public void setLinkAnimation(Pose pose1, float timeModifier, LivingEntityPatch<?> entitypatch, LinkAnimation dest) {
        float extTime = Math.max(this.convertTime + timeModifier, 0.0f);
        if (entitypatch instanceof PlayerPatch) {
            PlayerPatch playerpatch = (PlayerPatch)entitypatch;
            AttackAnimation.Phase phase = this.getPhaseByTime(((Animator)playerpatch.getAnimator()).getPlayerFor(this).getElapsedTime());
            extTime *= this.totalTime * playerpatch.getAttackSpeed(phase.hand);
        }
        extTime = Math.max(extTime - this.convertTime, 0.0f);
        super.setLinkAnimation(pose1, extTime, entitypatch, dest);
    }

    @Override
    protected void onLoaded() {
        super.onLoaded();
        if (!this.properties.containsKey(AnimationProperty.AttackAnimationProperty.BASIS_ATTACK_SPEED)) {
            float basisSpeed = Float.parseFloat(String.format(Locale.US, "%.2f", Float.valueOf(1.0f / this.totalTime)));
            this.addProperty(AnimationProperty.AttackAnimationProperty.BASIS_ATTACK_SPEED, Float.valueOf(basisSpeed));
        }
    }

    @Override
    protected Vec3f getCoordVector(LivingEntityPatch<?> entitypatch, DynamicAnimation dynamicAnimation) {
        Vec3f vec3 = super.getCoordVector(entitypatch, dynamicAnimation);
        if (entitypatch.shouldBlockMoving() && this.getProperty(AnimationProperty.ActionAnimationProperty.CANCELABLE_MOVE).orElse(false).booleanValue()) {
            vec3.scale(0.0f);
        }
        return vec3;
    }

    @Override
    public boolean isBasicAttackAnimation() {
        return true;
    }
}

