/*
 * Decompiled with CFR 0.152.
 */
package com.hammy275.immersivemc.server.tracker;

import com.hammy275.immersivemc.common.config.ActiveConfig;
import com.hammy275.immersivemc.common.tracker.AbstractTracker;
import com.hammy275.immersivemc.server.PlayerConfigs;
import com.hammy275.immersivemc.server.tracker.ServerTrackerInit;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;

public class RangedGrabTrackerServer
extends AbstractTracker {
    public static final double moveMultiplier = 0.6666666666666666;
    public final List<RangedGrabInfo> infos = new ArrayList<RangedGrabInfo>();
    protected final List<RangedGrabInfo> toRemove = new LinkedList<RangedGrabInfo>();

    public RangedGrabTrackerServer() {
        ServerTrackerInit.globalTrackers.add(this);
    }

    @Override
    protected void tick(Player player) {
        for (RangedGrabInfo info : this.infos) {
            if (info.item == null || !info.item.m_6084_() || info.tickTime <= 0) {
                this.toRemove.add(info);
                continue;
            }
            if (!PlayerConfigs.getConfig((Player)info.player).useRangedGrab) {
                return;
            }
            --info.tickTime;
            info.item.m_32010_(0);
            Vec3 baseVelocity = new Vec3(0.0, 0.0, 0.0);
            if (info.tickTime > 35) {
                baseVelocity = baseVelocity.m_82520_(0.0, 0.25, 0.0);
            }
            info.item.m_7618_(EntityAnchorArgument.Anchor.EYES, info.player.m_20182_().m_82520_(0.0, 1.0, 0.0));
            Vec3 move = info.item.m_20154_().m_82542_(0.6666666666666666, 0.6666666666666666, 0.6666666666666666).m_82549_(baseVelocity);
            info.item.m_20334_(move.f_82479_, move.f_82480_, move.f_82481_);
            info.item.f_19864_ = true;
        }
        for (RangedGrabInfo toRem : this.toRemove) {
            this.infos.remove(toRem);
        }
    }

    @Override
    protected boolean shouldTick(Player player) {
        return ActiveConfig.useRangedGrab && this.infos.size() > 0;
    }

    public static class RangedGrabInfo {
        public final ItemEntity item;
        public final ServerPlayer player;
        public int tickTime = 40;

        public RangedGrabInfo(ItemEntity item, ServerPlayer player) {
            this.item = item;
            this.player = player;
        }
    }
}

