/*
 * Decompiled with CFR 0.152.
 */
package com.hammy275.immersivemc.server.swap;

import com.hammy275.immersivemc.common.config.PlacementMode;
import com.hammy275.immersivemc.common.storage.AnvilStorage;
import com.hammy275.immersivemc.common.storage.ImmersiveStorage;
import com.hammy275.immersivemc.common.storage.workarounds.NullContainer;
import com.hammy275.immersivemc.common.util.Util;
import com.hammy275.immersivemc.mixin.AnvilMenuMixin;
import com.hammy275.immersivemc.server.storage.GetStorage;
import com.mojang.datafixers.util.Pair;
import java.util.Optional;
import java.util.concurrent.ThreadLocalRandom;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.AnvilMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.EnchantmentMenu;
import net.minecraft.world.inventory.SmithingMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.PotionItem;
import net.minecraft.world.item.RecordItem;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.AnvilBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.JukeboxBlock;
import net.minecraft.world.level.block.SmithingTableBlock;
import net.minecraft.world.level.block.entity.BarrelBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BrewingStandBlockEntity;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.entity.HopperBlockEntity;
import net.minecraft.world.level.block.entity.JukeboxBlockEntity;
import net.minecraft.world.level.block.entity.ShulkerBoxBlockEntity;
import net.minecraft.world.phys.Vec3;

public class Swap {
    public static void beaconSwap(ServerPlayer player, InteractionHand hand, BlockPos pos) {
        if (!player.m_21120_(hand).m_204117_(ItemTags.f_13164_) && !player.m_21120_(hand).m_41619_()) {
            return;
        }
        ImmersiveStorage beaconStorage = GetStorage.getBeaconStorage((Player)player, pos);
        ItemStack playerItem = player.m_21120_(hand).m_41777_();
        ItemStack beaconItem = beaconStorage.items[0].m_41777_();
        if (!beaconItem.m_41619_()) {
            Swap.placeLeftovers((Player)player, beaconItem);
            beaconStorage.items[0] = ItemStack.f_41583_;
        }
        if (!playerItem.m_41619_()) {
            beaconStorage.items[0] = playerItem.m_41777_();
            beaconStorage.items[0].m_41764_(1);
            playerItem.m_41774_(1);
            if (playerItem.m_41619_()) {
                playerItem = ItemStack.f_41583_;
            }
            player.m_21008_(hand, playerItem);
        }
        beaconStorage.wStorage.m_77762_();
    }

    public static void shulkerBoxSwap(ServerPlayer player, int slot, InteractionHand hand, BlockPos pos) {
        BlockEntity blockEntity = player.f_19853_.m_7702_(pos);
        if (blockEntity instanceof ShulkerBoxBlockEntity) {
            ShulkerBoxBlockEntity shulkerBox = (ShulkerBoxBlockEntity)blockEntity;
            ItemStack shulkerItem = shulkerBox.m_8020_(slot).m_41777_();
            ItemStack playerItem = player.m_21120_(hand);
            if (playerItem.m_41619_() || shulkerItem.m_41619_() || !Util.stacksEqualBesidesCount(shulkerItem, playerItem)) {
                if (shulkerBox.m_7155_(slot, playerItem, null)) {
                    player.m_21008_(hand, shulkerItem);
                    shulkerBox.m_6836_(slot, playerItem);
                }
            } else {
                Util.ItemStackMergeResult result = Util.mergeStacks(shulkerItem, playerItem, false);
                player.m_21008_(hand, result.mergedFrom);
                shulkerBox.m_6836_(slot, result.mergedInto);
            }
            shulkerBox.m_6596_();
        }
    }

    public static void enchantingTableSwap(ServerPlayer player, int slot, InteractionHand hand, BlockPos pos) {
        if (player == null) {
            return;
        }
        ImmersiveStorage enchStorage = GetStorage.getEnchantingStorage((Player)player, pos);
        if (slot == 0) {
            ItemStack toEnchant = player.m_21120_(hand).m_41777_();
            ItemStack toPlayer = enchStorage.items[0].m_41777_();
            if (!toEnchant.m_41619_() && !toEnchant.m_41792_()) {
                return;
            }
            player.m_21008_(hand, toPlayer);
            enchStorage.items[0] = toEnchant;
        } else if (player.m_21120_(hand).m_41619_()) {
            Swap.doEnchanting(slot, pos, player, hand);
        }
        enchStorage.wStorage.m_77762_();
    }

    public static void doEnchanting(int slot, BlockPos pos, ServerPlayer player, InteractionHand hand) {
        if (!player.m_21120_(hand).m_41619_()) {
            return;
        }
        if (slot < 1 || slot > 3) {
            return;
        }
        ImmersiveStorage storage = GetStorage.getEnchantingStorage((Player)player, pos);
        ItemStack toEnchantItem = storage.items[0].m_41777_();
        if (toEnchantItem.m_41619_()) {
            return;
        }
        int lapisInInventory = 0;
        for (int i = 0; i < player.m_150109_().f_35974_.size(); ++i) {
            if (player.m_150109_().m_8020_(i).m_41720_() != Items.f_42534_) continue;
            lapisInInventory += player.m_150109_().m_8020_(i).m_41613_();
        }
        if (lapisInInventory < slot && !player.m_150110_().f_35937_) {
            return;
        }
        EnchantmentMenu container = new EnchantmentMenu(-1, player.m_150109_(), ContainerLevelAccess.m_39289_((Level)player.f_19853_, (BlockPos)pos));
        container.m_182406_(1, 0, new ItemStack((ItemLike)Items.f_42534_, 64));
        container.m_182406_(0, 0, toEnchantItem);
        if (container.m_6366_((Player)player, slot - 1)) {
            int lapisToTake = slot;
            for (int i = 0; i < player.m_150109_().f_35974_.size(); ++i) {
                if (player.m_150109_().m_8020_(i).m_41720_() == Items.f_42534_) {
                    ItemStack stack = player.m_150109_().m_8020_(i);
                    while (!stack.m_41619_() && lapisToTake > 0) {
                        stack.m_41774_(1);
                        --lapisToTake;
                    }
                }
                if (lapisToTake == 0) break;
            }
            player.m_21008_(hand, container.m_38853_(0).m_7993_());
            storage.items[0] = ItemStack.f_41583_;
        }
    }

    public static void handleBackpackCraftingSwap(int slot, InteractionHand hand, ImmersiveStorage storage, ServerPlayer player, PlacementMode mode) {
        if (slot < 4) {
            ItemStack playerItem = player.m_21120_(hand);
            ItemStack tableItem = storage.items[slot];
            SwapResult result = Swap.getSwap(playerItem, tableItem, mode);
            storage.items[slot] = result.toOther;
            Swap.givePlayerItemSwap(result.toHand, playerItem, (Player)player, hand);
            Swap.placeLeftovers((Player)player, result.leftovers);
            storage.items[4] = Swap.getRecipeOutput(player, storage.items);
        } else {
            Swap.handleDoCraft(player, storage.items, null);
        }
        storage.wStorage.m_77762_();
    }

    public static void anvilSwap(int slot, InteractionHand hand, BlockPos pos, ServerPlayer player, PlacementMode mode) {
        Level level = player.f_19853_;
        boolean isReallyAnvil = level.m_8055_(pos).m_60734_() instanceof AnvilBlock;
        AnvilStorage storage = GetStorage.getAnvilStorage((Player)player, pos);
        if (slot != 2) {
            ItemStack playerItem = player.m_21120_(hand);
            ItemStack anvilItem = storage.items[slot];
            SwapResult result = Swap.getSwap(playerItem, anvilItem, mode);
            storage.items[slot] = result.toOther;
            Swap.givePlayerItemSwap(result.toHand, playerItem, (Player)player, hand);
            Swap.placeLeftovers((Player)player, result.leftovers);
            storage.items[2] = ItemStack.f_41583_;
            if (isReallyAnvil) {
                storage.xpLevels = 0;
            }
            if (!storage.items[0].m_41619_() && !storage.items[1].m_41619_()) {
                Pair<ItemStack, Integer> output = Swap.getAnvilOutput(storage.items[0], storage.items[1], isReallyAnvil, player);
                storage.items[2] = (ItemStack)output.getFirst();
                storage.xpLevels = (Integer)output.getSecond();
            }
        } else if (!storage.items[2].m_41619_()) {
            if (!player.m_21120_(hand).m_41619_()) {
                return;
            }
            Swap.handleAnvilCraft(storage, pos, player, hand);
        }
        storage.wStorage.m_77762_();
    }

    public static void handleAnvilCraft(AnvilStorage storage, BlockPos pos, ServerPlayer player, InteractionHand hand) {
        if (!player.m_21120_(hand).m_41619_()) {
            return;
        }
        ItemStack[] items = storage.items;
        ItemStack left = items[0];
        ItemStack mid = items[1];
        boolean isReallyAnvil = player.f_19853_.m_8055_(pos).m_60734_() instanceof AnvilBlock;
        boolean isSmithingTable = player.f_19853_.m_8055_(pos).m_60734_() instanceof SmithingTableBlock;
        if (!isReallyAnvil && !isSmithingTable) {
            return;
        }
        Pair<ItemStack, Integer> resAndCost = Swap.getAnvilOutput(left, mid, isReallyAnvil, player);
        if ((player.f_36078_ >= (Integer)resAndCost.getSecond() || player.m_150110_().f_35937_) && !((ItemStack)resAndCost.getFirst()).m_41619_()) {
            Object container = isReallyAnvil ? new AnvilMenu(-1, player.m_150109_(), ContainerLevelAccess.m_39289_((Level)player.f_19853_, (BlockPos)pos)) : new SmithingMenu(-1, player.m_150109_(), ContainerLevelAccess.m_39289_((Level)player.f_19853_, (BlockPos)pos));
            container.m_38853_(2).m_142406_((Player)player, (ItemStack)resAndCost.getFirst());
            if (!player.m_150110_().f_35937_) {
                player.m_6749_(-((Integer)resAndCost.getSecond()).intValue());
            }
            left.m_41774_(1);
            mid.m_41774_(1);
            items[2] = ItemStack.f_41583_;
            storage.xpLevels = 0;
            player.m_21008_(hand, (ItemStack)resAndCost.getFirst());
        }
    }

    public static void handleCraftingSwap(ServerPlayer player, int slot, InteractionHand hand, BlockPos tablePos, PlacementMode mode) {
        ImmersiveStorage storage = GetStorage.getCraftingStorage((Player)player, tablePos);
        BlockEntity blockEntity = player.f_19853_.m_7702_(tablePos);
        if (blockEntity instanceof Container) {
            Container table = (Container)blockEntity;
            playerItem = player.m_21120_(hand).m_41777_();
            ItemStack craftingItem = table.m_8020_(slot).m_41777_();
            if (slot < 9) {
                ItemStack output;
                SwapResult result = Swap.getSwap(playerItem, craftingItem, mode);
                Swap.givePlayerItemSwap(result.toHand, playerItem, (Player)player, hand);
                table.m_6836_(slot, result.toOther);
                Swap.placeLeftovers((Player)player, result.leftovers);
                ItemStack[] ins = new ItemStack[10];
                for (int i = 0; i <= 8; ++i) {
                    ins[i] = table.m_8020_(i);
                    storage.items[i] = ItemStack.f_41583_;
                }
                ins[9] = ItemStack.f_41583_;
                storage.items[9] = output = Swap.getRecipeOutput(player, ins);
            } else {
                int i;
                for (i = 0; i <= 8; ++i) {
                    storage.items[i] = table.m_8020_(i).m_41777_();
                }
                Swap.handleDoCraft(player, storage.items, tablePos);
                for (i = 0; i <= 8; ++i) {
                    table.m_6836_(i, storage.items[i]);
                    storage.items[i] = ItemStack.f_41583_;
                }
            }
        } else {
            if (slot < 9) {
                playerItem = player.m_21120_(hand);
                ItemStack craftingItem = storage.items[slot];
                SwapResult result = Swap.getSwap(playerItem, craftingItem, mode);
                storage.items[slot] = result.toOther;
                Swap.givePlayerItemSwap(result.toHand, playerItem, (Player)player, hand);
                Swap.placeLeftovers((Player)player, result.leftovers);
                storage.items[9] = Swap.getRecipeOutput(player, storage.items);
            } else {
                Swap.handleDoCraft(player, storage.items, tablePos);
            }
            storage.wStorage.m_77762_();
        }
    }

    public static ItemStack getRecipeOutput(ServerPlayer player, ItemStack[] stacksIn) {
        int invDim = stacksIn.length == 10 ? 3 : 2;
        CraftingContainer inv = new CraftingContainer((AbstractContainerMenu)new NullContainer(), invDim, invDim);
        for (int i = 0; i < stacksIn.length - 1; ++i) {
            inv.m_6836_(i, stacksIn[i]);
        }
        Optional res = player.m_20194_().m_129894_().m_44015_(RecipeType.f_44107_, (Container)inv, player.f_19853_);
        if (res.isPresent()) {
            return ((CraftingRecipe)res.get()).m_5874_((Container)inv);
        }
        return ItemStack.f_41583_;
    }

    public static void handleDoCraft(ServerPlayer player, ItemStack[] stacksIn, BlockPos tablePos) {
        boolean isBackpack = stacksIn.length == 5;
        int invDim = isBackpack ? 2 : 3;
        CraftingContainer inv = new CraftingContainer((AbstractContainerMenu)new NullContainer(), invDim, invDim);
        for (int i = 0; i < stacksIn.length - 1; ++i) {
            inv.m_6836_(i, stacksIn[i]);
        }
        ItemStack stackOut = Swap.getRecipeOutput(player, stacksIn);
        if (!stackOut.m_41619_()) {
            ItemStack newOutput;
            for (int i = 0; i < stacksIn.length - 1; ++i) {
                if (stacksIn[i].m_41720_().m_41470_()) {
                    if (stacksIn[i].m_41613_() == 1) {
                        stacksIn[i] = new ItemStack((ItemLike)stacksIn[i].m_41720_().m_41469_());
                        continue;
                    }
                    Swap.placeLeftovers((Player)player, new ItemStack((ItemLike)stacksIn[i].m_41720_().m_41469_()));
                    continue;
                }
                stacksIn[i].m_41774_(1);
            }
            stacksIn[stacksIn.length - 1] = newOutput = Swap.getRecipeOutput(player, stacksIn);
            ItemStack handStack = player.m_21120_(InteractionHand.MAIN_HAND);
            ItemStack toGive = ItemStack.f_41583_;
            if (!handStack.m_41619_() && Util.stacksEqualBesidesCount(stackOut, handStack)) {
                Util.ItemStackMergeResult itemRes = Util.mergeStacks(handStack, stackOut, true);
                player.m_21008_(InteractionHand.MAIN_HAND, itemRes.mergedInto);
                toGive = itemRes.mergedFrom;
            } else if (handStack.m_41619_()) {
                player.m_21008_(InteractionHand.MAIN_HAND, stackOut);
            } else {
                toGive = stackOut;
            }
            if (!toGive.m_41619_()) {
                BlockPos posBlock = tablePos != null ? tablePos.m_7494_() : player.m_142538_();
                Vec3 pos = Vec3.m_82512_((Vec3i)posBlock);
                ItemEntity entOut = new ItemEntity(player.f_19853_, pos.f_82479_, pos.f_82480_, pos.f_82481_, toGive);
                entOut.m_20334_(0.0, 0.0, 0.0);
                player.f_19853_.m_7967_((Entity)entOut);
            } else {
                player.f_19853_.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12019_, isBackpack ? SoundSource.PLAYERS : SoundSource.BLOCKS, 0.2f, ThreadLocalRandom.current().nextFloat() - ThreadLocalRandom.current().nextFloat() * 1.4f + 2.0f);
            }
        }
    }

    public static void handleInventorySwap(Player player, int slot, InteractionHand hand) {
        ItemStack handStack = player.m_21120_(hand).m_41777_();
        ItemStack invStack = player.m_150109_().m_8020_(slot).m_41777_();
        if (handStack.m_41619_() || invStack.m_41619_() || !Util.stacksEqualBesidesCount(handStack, invStack)) {
            player.m_21008_(hand, invStack);
            player.m_150109_().m_6836_(slot, handStack);
        } else {
            Util.ItemStackMergeResult res = Util.mergeStacks(invStack, handStack, false);
            player.m_21008_(hand, res.mergedFrom);
            player.m_150109_().m_6836_(slot, res.mergedInto);
        }
    }

    public static void handleFurnaceSwap(WorldlyContainer furnace, Player player, InteractionHand hand, int slot, PlacementMode mode) {
        ItemStack furnaceItem = furnace.m_8020_(slot).m_41777_();
        ItemStack playerItem = player.m_21120_(hand).m_41777_();
        if (slot != 2) {
            if (slot != 1 || furnace.m_7013_(1, playerItem) || playerItem.m_41619_()) {
                SwapResult result = Swap.getSwap(playerItem, furnaceItem, mode);
                Swap.givePlayerItemSwap(result.toHand, playerItem, player, hand);
                furnace.m_6836_(slot, result.toOther);
                Swap.placeLeftovers(player, result.leftovers);
            }
        } else if (playerItem.m_41619_()) {
            player.m_21008_(hand, furnaceItem);
            furnace.m_6836_(2, playerItem);
        } else if (Util.stacksEqualBesidesCount(furnaceItem, playerItem)) {
            Util.ItemStackMergeResult result = Util.mergeStacks(playerItem, furnaceItem, false);
            player.m_21008_(hand, result.mergedInto);
            furnace.m_6836_(slot, result.mergedFrom);
        }
        furnace.m_6596_();
    }

    public static void handleBrewingSwap(BrewingStandBlockEntity stand, Player player, InteractionHand hand, int slot, PlacementMode mode) {
        ItemStack standItem = stand.m_8020_(slot).m_41777_();
        ItemStack playerItem = player.m_21120_(hand).m_41777_();
        if (slot < 3) {
            if (!stand.m_7013_(slot, playerItem) && playerItem != ItemStack.f_41583_ && !(standItem.m_41720_() instanceof PotionItem)) {
                return;
            }
            player.m_21008_(hand, standItem);
            stand.m_6836_(slot, playerItem);
        } else {
            if (!stand.m_7013_(slot, playerItem) && playerItem != ItemStack.f_41583_) {
                return;
            }
            SwapResult result = Swap.getSwap(playerItem, standItem, mode);
            Swap.givePlayerItemSwap(result.toHand, playerItem, player, hand);
            stand.m_6836_(slot, result.toOther);
            Swap.placeLeftovers(player, result.leftovers);
        }
        stand.m_6596_();
    }

    public static void handleJukebox(JukeboxBlockEntity jukebox, ServerPlayer player, InteractionHand hand) {
        ItemStack playerItem = player.m_21120_(hand);
        if (jukebox.m_59524_() == ItemStack.f_41583_ && playerItem.m_41720_() instanceof RecordItem) {
            ((JukeboxBlock)Blocks.f_50131_).m_54269_((LevelAccessor)player.f_19853_, jukebox.m_58899_(), jukebox.m_58900_(), playerItem);
            player.f_19853_.m_5898_((Player)null, 1010, jukebox.m_58899_(), Item.m_41393_((Item)playerItem.m_41720_()));
            playerItem.m_41774_(1);
            player.m_36220_(Stats.f_12965_);
            jukebox.m_6596_();
        }
    }

    public static void handleChest(ChestBlockEntity chestIn, Player player, InteractionHand hand, int slot) {
        ChestBlockEntity chest;
        ChestBlockEntity chestBlockEntity = chest = slot > 26 ? Util.getOtherChest(chestIn) : chestIn;
        if (chest != null) {
            ItemStack chestItem = chest.m_8020_(slot %= 27).m_41777_();
            ItemStack playerItem = player.m_21120_(hand);
            if (playerItem.m_41619_() || chestItem.m_41619_() || !Util.stacksEqualBesidesCount(chestItem, playerItem)) {
                player.m_21008_(hand, chestItem);
                chest.m_6836_(slot, playerItem);
            } else {
                Util.ItemStackMergeResult result = Util.mergeStacks(chestItem, playerItem, false);
                player.m_21008_(hand, result.mergedFrom);
                chest.m_6836_(slot, result.mergedInto);
            }
            chest.m_6596_();
        }
    }

    public static void handleBarrel(BarrelBlockEntity barrel, Player player, InteractionHand hand, int slot) {
        ItemStack barrelItem = barrel.m_8020_(slot).m_41777_();
        ItemStack playerItem = player.m_21120_(hand);
        if (playerItem.m_41619_() || barrelItem.m_41619_() || !Util.stacksEqualBesidesCount(barrelItem, playerItem)) {
            player.m_21008_(hand, barrelItem);
            barrel.m_6836_(slot, playerItem);
        } else {
            Util.ItemStackMergeResult result = Util.mergeStacks(barrelItem, playerItem, false);
            player.m_21008_(hand, result.mergedFrom);
            barrel.m_6836_(slot, result.mergedInto);
        }
        barrel.m_6596_();
    }

    public static void handleHopper(HopperBlockEntity hopper, Player player, InteractionHand hand, int slot) {
        ItemStack hopperItem = hopper.m_8020_(slot).m_41777_();
        ItemStack playerItem = player.m_21120_(hand);
        if (playerItem.m_41619_() || hopperItem.m_41619_() || !Util.stacksEqualBesidesCount(hopperItem, playerItem)) {
            player.m_21008_(hand, hopperItem);
            hopper.m_6836_(slot, playerItem);
        } else {
            Util.ItemStackMergeResult result = Util.mergeStacks(hopperItem, playerItem, false);
            player.m_21008_(hand, result.mergedFrom);
            hopper.m_6836_(slot, result.mergedInto);
        }
        hopper.m_6596_();
    }

    public static void handleEnderChest(Player player, InteractionHand hand, int slot) {
        ItemStack chestItem = player.m_36327_().m_8020_(slot).m_41777_();
        ItemStack playerItem = player.m_21120_(hand);
        if (playerItem.m_41619_() || chestItem.m_41619_() || !Util.stacksEqualBesidesCount(chestItem, playerItem)) {
            player.m_21008_(hand, chestItem);
            player.m_36327_().m_6836_(slot, playerItem);
        } else {
            Util.ItemStackMergeResult result = Util.mergeStacks(chestItem, playerItem, false);
            player.m_21008_(hand, result.mergedFrom);
            player.m_36327_().m_6836_(slot, result.mergedInto);
        }
    }

    public static Pair<ItemStack, Integer> getAnvilOutput(ItemStack left, ItemStack mid, boolean isReallyAnvil, ServerPlayer player) {
        Object container = isReallyAnvil ? new AnvilMenu(-1, player.m_150109_()) : new SmithingMenu(-1, player.m_150109_());
        container.m_182406_(0, 0, left);
        container.m_182406_(1, 0, mid);
        container.m_6640_();
        ItemStack res = container.m_38853_(2).m_7993_();
        int level = 0;
        if (isReallyAnvil) {
            level = ((AnvilMenuMixin)container).getCost().m_6501_();
        }
        return new Pair((Object)res, (Object)level);
    }

    public static SwapResult getSwap(ItemStack handIn, ItemStack otherIn, PlacementMode mode) {
        ItemStack leftovers;
        ItemStack toHand;
        ItemStack toOther;
        int toPlace = switch (mode) {
            case PlacementMode.PLACE_ONE -> 1;
            case PlacementMode.PLACE_QUARTER -> (int)Math.max((double)handIn.m_41613_() / 4.0, 1.0);
            case PlacementMode.PLACE_HALF -> (int)Math.max((double)handIn.m_41613_() / 2.0, 1.0);
            case PlacementMode.PLACE_ALL -> handIn.m_41613_();
            default -> throw new IllegalArgumentException("Unhandled placement mode " + mode);
        };
        if (Util.stacksEqualBesidesCount(handIn, otherIn) && !handIn.m_41619_() && !otherIn.m_41619_()) {
            ItemStack handInCountAdjusted = handIn.m_41777_();
            handInCountAdjusted.m_41764_(toPlace);
            Util.ItemStackMergeResult mergeResult = Util.mergeStacks(otherIn.m_41777_(), handInCountAdjusted, false);
            toOther = mergeResult.mergedInto;
            toHand = handIn.m_41777_();
            toHand.m_41774_(toPlace);
            toHand.m_41769_(mergeResult.mergedFrom.m_41613_());
            leftovers = ItemStack.f_41583_;
        } else {
            if (handIn.m_41619_()) {
                return new SwapResult(otherIn.m_41777_(), ItemStack.f_41583_, ItemStack.f_41583_);
            }
            toOther = handIn.m_41777_();
            toOther.m_41764_(toPlace);
            toHand = handIn.m_41777_();
            toHand.m_41774_(toPlace);
            leftovers = otherIn.m_41777_();
        }
        return new SwapResult(toHand, toOther, leftovers);
    }

    public static void placeLeftovers(Player player, ItemStack leftovers) {
        if (!leftovers.m_41619_()) {
            ItemEntity item = new ItemEntity(player.f_19853_, player.m_20185_(), player.m_20186_(), player.m_20189_(), leftovers);
            player.f_19853_.m_7967_((Entity)item);
        }
    }

    public static void givePlayerItemSwap(ItemStack toPlayer, ItemStack fromPlayer, Player player, InteractionHand hand) {
        if (fromPlayer.m_41619_() && toPlayer.m_41741_() > 1) {
            Util.addStackToInventory(player, toPlayer);
        } else {
            player.m_21008_(hand, toPlayer);
        }
    }

    public static class SwapResult {
        public final ItemStack toHand;
        public final ItemStack toOther;
        public final ItemStack leftovers;

        public SwapResult(ItemStack toHand, ItemStack toOther, ItemStack leftovers) {
            this.toHand = toHand;
            this.toOther = toOther;
            this.leftovers = leftovers;
        }
    }
}

