/*
 * Decompiled with CFR 0.152.
 */
package com.hammy275.immersivemc.common.network.packet;

import com.hammy275.immersivemc.common.config.ActiveConfig;
import com.hammy275.immersivemc.common.util.Util;
import com.hammy275.immersivemc.server.data.AboutToThrowData;
import dev.architectury.networking.NetworkManager;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.FishingRodItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TridentItem;
import net.minecraft.world.phys.Vec3;

public class ThrowPacket {
    private final Vec3 velocity;
    private Vec3 dir;

    public ThrowPacket(Vec3 velocity, Vec3 dir) {
        this.velocity = velocity;
        this.dir = dir;
    }

    public static void encode(ThrowPacket packet, FriendlyByteBuf buffer) {
        buffer.writeDouble(packet.velocity.f_82479_).writeDouble(packet.velocity.f_82480_).writeDouble(packet.velocity.f_82481_).writeDouble(packet.dir.f_82479_).writeDouble(packet.dir.f_82480_).writeDouble(packet.dir.f_82481_);
    }

    public static ThrowPacket decode(FriendlyByteBuf buffer) {
        return new ThrowPacket(new Vec3(buffer.readDouble(), buffer.readDouble(), buffer.readDouble()), new Vec3(buffer.readDouble(), buffer.readDouble(), buffer.readDouble()));
    }

    public static void handle(ThrowPacket packet, Supplier<NetworkManager.PacketContext> ctx) {
        ctx.get().queue(() -> {
            ItemStack itemInHand;
            ServerPlayer player = ((NetworkManager.PacketContext)ctx.get()).getPlayer() instanceof ServerPlayer ? (ServerPlayer)((NetworkManager.PacketContext)ctx.get()).getPlayer() : null;
            packet.dir = packet.dir.m_82541_();
            if (player != null && ActiveConfig.useThrowing && Util.isThrowableItem((itemInHand = player.m_21120_(InteractionHand.MAIN_HAND)).m_41720_())) {
                if (itemInHand.m_41720_() instanceof FishingRodItem && player.f_36083_ != null) {
                    return;
                }
                AboutToThrowData.aboutToThrowMap.put(player.m_142081_(), new AboutToThrowData.ThrowRecord(packet.velocity, packet.dir));
                if (itemInHand.m_41720_() instanceof TridentItem) {
                    itemInHand.m_41720_().m_5551_(itemInHand, player.f_19853_, (LivingEntity)player, 71000);
                } else {
                    itemInHand.m_41720_().m_7203_(player.f_19853_, (Player)player, InteractionHand.MAIN_HAND);
                }
            }
        });
    }
}

