/*
 * Decompiled with CFR 0.152.
 */
package com.hammy275.immersivemc.common.network.packet;

import com.hammy275.immersivemc.client.SafeClientUtil;
import com.hammy275.immersivemc.common.config.ActiveConfig;
import com.hammy275.immersivemc.common.config.PlacementMode;
import com.hammy275.immersivemc.common.immersive.ImmersiveCheckers;
import com.hammy275.immersivemc.common.network.NetworkUtil;
import com.hammy275.immersivemc.server.swap.Swap;
import dev.architectury.networking.NetworkManager;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BarrelBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BrewingStandBlockEntity;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.entity.EnderChestBlockEntity;
import net.minecraft.world.level.block.entity.HopperBlockEntity;
import net.minecraft.world.level.block.entity.JukeboxBlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class SwapPacket {
    public final BlockPos block;
    public final int slot;
    public final InteractionHand hand;
    public PlacementMode placementMode = SafeClientUtil.getPlacementMode();

    public SwapPacket(BlockPos block, int slot, InteractionHand hand) {
        this.block = block;
        this.slot = slot;
        this.hand = hand;
    }

    public static void encode(SwapPacket packet, FriendlyByteBuf buffer) {
        buffer.m_130068_((Enum)packet.placementMode);
        buffer.m_130064_(packet.block);
        buffer.writeInt(packet.slot);
        buffer.writeInt(packet.hand == InteractionHand.MAIN_HAND ? 0 : 1);
    }

    public static SwapPacket decode(FriendlyByteBuf buffer) {
        PlacementMode mode = (PlacementMode)buffer.m_130066_(PlacementMode.class);
        SwapPacket packet = new SwapPacket(buffer.m_130135_(), buffer.readInt(), buffer.readInt() == 0 ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND);
        packet.placementMode = mode;
        return packet;
    }

    public static void handle(SwapPacket message, Supplier<NetworkManager.PacketContext> ctx) {
        ctx.get().queue(() -> {
            ServerPlayer player;
            ServerPlayer serverPlayer = player = ((NetworkManager.PacketContext)ctx.get()).getPlayer() instanceof ServerPlayer ? (ServerPlayer)((NetworkManager.PacketContext)ctx.get()).getPlayer() : null;
            if (NetworkUtil.safeToRun(message.block, player)) {
                BlockEntity tileEnt = player.f_19853_.m_7702_(message.block);
                BlockState state = player.f_19853_.m_8055_(message.block);
                if (ImmersiveCheckers.isFurnace(message.block, state, tileEnt, player.f_19853_) && ActiveConfig.useFurnaceImmersion) {
                    Swap.handleFurnaceSwap((WorldlyContainer)tileEnt, (Player)player, message.hand, message.slot, message.placementMode);
                } else if (ImmersiveCheckers.isBrewingStand(message.block, state, tileEnt, player.f_19853_) && ActiveConfig.useBrewingImmersion) {
                    BrewingStandBlockEntity stand = (BrewingStandBlockEntity)tileEnt;
                    Swap.handleBrewingSwap(stand, (Player)player, message.hand, message.slot, message.placementMode);
                } else if (ImmersiveCheckers.isJukebox(message.block, state, tileEnt, player.f_19853_) && ActiveConfig.useJukeboxImmersion) {
                    Swap.handleJukebox((JukeboxBlockEntity)tileEnt, player, message.hand);
                } else if (ImmersiveCheckers.isChest(message.block, state, tileEnt, player.f_19853_) && ActiveConfig.useChestImmersion) {
                    if (tileEnt instanceof ChestBlockEntity) {
                        ChestBlockEntity cbe = (ChestBlockEntity)tileEnt;
                        Swap.handleChest(cbe, (Player)player, message.hand, message.slot);
                    } else if (tileEnt instanceof EnderChestBlockEntity) {
                        Swap.handleEnderChest((Player)player, message.hand, message.slot);
                    }
                } else if (ImmersiveCheckers.isShulkerBox(message.block, state, tileEnt, player.f_19853_)) {
                    Swap.shulkerBoxSwap(player, message.slot, message.hand, message.block);
                } else if (ImmersiveCheckers.isBarrel(message.block, state, tileEnt, player.f_19853_)) {
                    Swap.handleBarrel((BarrelBlockEntity)tileEnt, (Player)player, message.hand, message.slot);
                } else if (ImmersiveCheckers.isHopper(message.block, state, tileEnt, player.f_19853_)) {
                    Swap.handleHopper((HopperBlockEntity)tileEnt, (Player)player, message.hand, message.slot);
                }
            }
        });
    }
}

