/*
 * Decompiled with CFR 0.152.
 */
package com.hammy275.immersivemc.common.network.packet;

import com.hammy275.immersivemc.client.immersive.Immersives;
import com.hammy275.immersivemc.client.immersive.info.CraftingInfo;
import com.hammy275.immersivemc.common.immersive.ImmersiveCheckers;
import com.hammy275.immersivemc.common.network.Network;
import com.hammy275.immersivemc.common.network.NetworkUtil;
import com.hammy275.immersivemc.server.storage.GetStorage;
import com.hammy275.immersivemc.server.swap.Swap;
import dev.architectury.networking.NetworkManager;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;

public class GetRecipePacket {
    public final BlockPos pos;
    public final ItemStack stack;

    public GetRecipePacket(BlockPos pos) {
        this(pos, null);
    }

    public GetRecipePacket(BlockPos pos, ItemStack stack) {
        this.pos = pos;
        this.stack = stack;
    }

    public boolean isClientToServer() {
        return this.stack == null;
    }

    public static void encode(GetRecipePacket packet, FriendlyByteBuf buffer) {
        buffer.m_130064_(packet.pos).writeBoolean(packet.isClientToServer());
        if (!packet.isClientToServer()) {
            buffer.m_130055_(packet.stack);
        }
    }

    public static GetRecipePacket decode(FriendlyByteBuf buffer) {
        return new GetRecipePacket(buffer.m_130135_(), buffer.readBoolean() ? null : buffer.m_130267_());
    }

    public static void handle(GetRecipePacket packet, Supplier<NetworkManager.PacketContext> ctx) {
        ctx.get().queue(() -> {
            BlockEntity patt2122$temp;
            ServerPlayer sender;
            ServerPlayer serverPlayer = sender = ((NetworkManager.PacketContext)ctx.get()).getPlayer() instanceof ServerPlayer ? (ServerPlayer)((NetworkManager.PacketContext)ctx.get()).getPlayer() : null;
            if (sender == null) {
                GetRecipePacket.handleClient(packet);
            } else if (NetworkUtil.safeToRun(packet.pos, sender) && (patt2122$temp = sender.f_19853_.m_7702_(packet.pos)) instanceof Container) {
                Container table = (Container)patt2122$temp;
                if (ImmersiveCheckers.isCraftingTable(packet.pos, sender.f_19853_.m_8055_(packet.pos), sender.f_19853_.m_7702_(packet.pos), sender.f_19853_)) {
                    ItemStack output;
                    ItemStack[] items = new ItemStack[10];
                    for (int i = 0; i <= 8; ++i) {
                        items[i] = table.m_8020_(i);
                    }
                    items[9] = ItemStack.f_41583_;
                    GetStorage.getCraftingStorage((Player)sender, (BlockPos)packet.pos).items[9] = output = Swap.getRecipeOutput(sender, items);
                    Network.INSTANCE.sendToPlayer(sender, (Object)new GetRecipePacket(packet.pos, output));
                }
            }
        });
    }

    public static void handleClient(GetRecipePacket packet) {
        for (CraftingInfo info : Immersives.immersiveCrafting.getTrackedObjects()) {
            if (!info.getBlockPosition().equals((Object)packet.pos)) continue;
            info.outputItem = packet.stack;
        }
    }
}

