/*
 * Decompiled with CFR 0.152.
 */
package com.hammy275.immersivemc.common.network.packet;

import com.hammy275.immersivemc.client.immersive.Immersives;
import com.hammy275.immersivemc.client.immersive.info.EnchantingInfo;
import com.hammy275.immersivemc.common.network.Network;
import com.hammy275.immersivemc.common.network.NetworkUtil;
import com.hammy275.immersivemc.common.storage.ImmersiveStorage;
import com.hammy275.immersivemc.server.storage.GetStorage;
import dev.architectury.networking.NetworkManager;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.EnchantmentMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.EnchantmentTableBlockEntity;

public class GetEnchantmentsPacket {
    public final BlockPos pos;
    public final int weakXPLevels;
    public final int weakEnchHint;
    public final int weakLevelHint;
    public final int midXPLevels;
    public final int midEnchHint;
    public final int midLevelHint;
    public final int strongXPLevels;
    public final int strongEnchHint;
    public final int strongLevelHint;

    public GetEnchantmentsPacket(BlockPos pos) {
        this.pos = pos;
        this.weakXPLevels = -999;
        this.weakEnchHint = -1;
        this.weakLevelHint = -1;
        this.midXPLevels = -1;
        this.midEnchHint = -1;
        this.midLevelHint = -1;
        this.strongXPLevels = -1;
        this.strongEnchHint = -1;
        this.strongLevelHint = -1;
    }

    public GetEnchantmentsPacket(int weakXPLevels, int weakEnchHint, int weakLevelHint, int midXPLevels, int midEnchHint, int midLevelHint, int strongXPLevels, int strongEnchHint, int strongLevelHint, BlockPos pos) {
        this.weakXPLevels = weakXPLevels;
        this.weakEnchHint = weakEnchHint;
        this.weakLevelHint = weakLevelHint;
        this.midXPLevels = midXPLevels;
        this.midEnchHint = midEnchHint;
        this.midLevelHint = midLevelHint;
        this.strongXPLevels = strongXPLevels;
        this.strongEnchHint = strongEnchHint;
        this.strongLevelHint = strongLevelHint;
        this.pos = pos;
    }

    public static void encode(GetEnchantmentsPacket packet, FriendlyByteBuf buffer) {
        buffer.writeBoolean(packet.weakXPLevels == -999);
        if (packet.weakXPLevels == -999) {
            buffer.m_130064_(packet.pos);
        } else {
            buffer.writeInt(packet.weakXPLevels);
            buffer.writeInt(packet.weakEnchHint);
            buffer.writeInt(packet.weakLevelHint);
            buffer.writeInt(packet.midXPLevels);
            buffer.writeInt(packet.midEnchHint);
            buffer.writeInt(packet.midLevelHint);
            buffer.writeInt(packet.strongXPLevels);
            buffer.writeInt(packet.strongEnchHint);
            buffer.writeInt(packet.strongLevelHint);
            buffer.m_130064_(packet.pos);
        }
    }

    public static GetEnchantmentsPacket decode(FriendlyByteBuf buffer) {
        if (buffer.readBoolean()) {
            return new GetEnchantmentsPacket(buffer.m_130135_());
        }
        return new GetEnchantmentsPacket(buffer.readInt(), buffer.readInt(), buffer.readInt(), buffer.readInt(), buffer.readInt(), buffer.readInt(), buffer.readInt(), buffer.readInt(), buffer.readInt(), buffer.m_130135_());
    }

    public static void handle(GetEnchantmentsPacket message, Supplier<NetworkManager.PacketContext> ctx) {
        ctx.get().queue(() -> {
            ServerPlayer player;
            ServerPlayer serverPlayer = player = ((NetworkManager.PacketContext)ctx.get()).getPlayer() instanceof ServerPlayer ? (ServerPlayer)((NetworkManager.PacketContext)ctx.get()).getPlayer() : null;
            if (player == null) {
                GetEnchantmentsPacket.handleClient(message);
            } else if (NetworkUtil.safeToRun(message.pos, player)) {
                BlockEntity tileEnt;
                ImmersiveStorage enchantStorage = GetStorage.getEnchantingStorage((Player)player, message.pos);
                if (enchantStorage.items[0] != null && !enchantStorage.items[0].m_41619_() && (tileEnt = player.f_19853_.m_7702_(message.pos)) instanceof EnchantmentTableBlockEntity) {
                    EnchantmentMenu container = new EnchantmentMenu(-1, player.m_150109_(), ContainerLevelAccess.m_39289_((Level)player.f_19853_, (BlockPos)message.pos));
                    container.m_182406_(1, 0, new ItemStack((ItemLike)Items.f_42534_, 64));
                    container.m_182406_(0, 0, enchantStorage.items[0]);
                    int[] xpLevels = container.f_39446_;
                    int[] descs = container.f_39447_;
                    int[] enchLevels = container.f_39448_;
                    Network.INSTANCE.sendToPlayer(player, (Object)new GetEnchantmentsPacket(xpLevels[0], descs[0], enchLevels[0], xpLevels[1], descs[1], enchLevels[1], xpLevels[2], descs[2], enchLevels[2], message.pos));
                }
            }
        });
    }

    protected static void handleClient(GetEnchantmentsPacket message) {
        for (EnchantingInfo info : Immersives.immersiveETable.getTrackedObjects()) {
            if (!info.getBlockPosition().equals((Object)message.pos)) continue;
            Enchantment ench = GetEnchantmentsPacket.getEnch(message.weakEnchHint);
            if (ench != null) {
                info.weakInfo.levelsNeeded = message.weakXPLevels;
                info.weakInfo.textPreview = GetEnchantmentsPacket.getDesc(ench, message.weakLevelHint);
            } else {
                info.weakInfo.textPreview = null;
            }
            ench = GetEnchantmentsPacket.getEnch(message.midEnchHint);
            if (ench != null) {
                info.midInfo.levelsNeeded = message.midXPLevels;
                info.midInfo.textPreview = GetEnchantmentsPacket.getDesc(ench, message.midLevelHint);
            } else {
                info.midInfo.textPreview = null;
            }
            ench = GetEnchantmentsPacket.getEnch(message.strongEnchHint);
            if (ench != null) {
                info.strongInfo.levelsNeeded = message.strongXPLevels;
                info.strongInfo.textPreview = GetEnchantmentsPacket.getDesc(ench, message.strongLevelHint);
                continue;
            }
            info.strongInfo.textPreview = null;
        }
    }

    protected static Enchantment getEnch(int id) {
        return Enchantment.m_44697_((int)id);
    }

    protected static TextComponent getDesc(Enchantment ench, int enchLevel) {
        return new TextComponent(ench.m_44700_(enchLevel).getString() + "...?");
    }
}

