/*
 * Decompiled with CFR 0.152.
 */
package com.hammy275.immersivemc.common.network.packet;

import com.hammy275.immersivemc.common.config.ActiveConfig;
import com.hammy275.immersivemc.common.config.ImmersiveMCConfig;
import com.hammy275.immersivemc.common.network.Network;
import com.hammy275.immersivemc.server.PlayerConfigs;
import dev.architectury.networking.NetworkManager;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.level.ServerPlayer;

public class ConfigSyncPacket {
    protected FriendlyByteBuf buffer;
    protected boolean kickMe = false;
    protected boolean isToServerConfigPacket = false;

    public ConfigSyncPacket() {
    }

    protected ConfigSyncPacket(boolean kickMe) {
        this.kickMe = true;
    }

    public static ConfigSyncPacket getKickMePacket() {
        return new ConfigSyncPacket(true);
    }

    public static ConfigSyncPacket getToServerConfigPacket() {
        ConfigSyncPacket packet = new ConfigSyncPacket();
        packet.isToServerConfigPacket = true;
        return packet;
    }

    public ConfigSyncPacket(FriendlyByteBuf configBuffer) {
        this.buffer = configBuffer;
    }

    public static void encode(ConfigSyncPacket packet, FriendlyByteBuf buffer) {
        buffer.writeBoolean(packet.kickMe);
        if (!packet.kickMe) {
            if (packet.isToServerConfigPacket) {
                ActiveConfig.encodeServerOnlyConfig(buffer);
            } else {
                ImmersiveMCConfig.encode(buffer);
            }
        }
    }

    public static ConfigSyncPacket decode(FriendlyByteBuf buffer) {
        if (buffer.readBoolean()) {
            return ConfigSyncPacket.getKickMePacket();
        }
        buffer.retain();
        return new ConfigSyncPacket(buffer);
    }

    public static void handle(ConfigSyncPacket message, Supplier<NetworkManager.PacketContext> ctx) {
        ctx.get().queue(() -> {
            ServerPlayer player;
            ServerPlayer serverPlayer = player = ((NetworkManager.PacketContext)ctx.get()).getPlayer() instanceof ServerPlayer ? (ServerPlayer)((NetworkManager.PacketContext)ctx.get()).getPlayer() : null;
            if (player == null) {
                ActiveConfig.loadConfigFromPacket(message.buffer);
                Network.INSTANCE.sendToServer((Object)ConfigSyncPacket.getToServerConfigPacket());
            } else if (message.kickMe) {
                ((ServerPlayer)((NetworkManager.PacketContext)ctx.get()).getPlayer()).f_8906_.m_9942_((Component)new TextComponent("The server is using a different version of ImmersiveMC than you!"));
            } else {
                PlayerConfigs.registerConfig(((NetworkManager.PacketContext)ctx.get()).getPlayer(), message.buffer);
            }
        });
    }
}

