/*
 * Decompiled with CFR 0.152.
 */
package com.hammy275.immersivemc.common.config;

import com.hammy275.immersivemc.common.config.PlacementGuideMode;
import com.hammy275.immersivemc.common.config.PlacementMode;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.common.ForgeConfigSpec;

public class ImmersiveMCConfig {
    public static final int CONFIG_VERSION = 4;
    public static final ForgeConfigSpec GENERAL_SPEC;
    public static ForgeConfigSpec.BooleanValue useAnvilImmersion;
    public static ForgeConfigSpec.BooleanValue useBrewingImmersion;
    public static ForgeConfigSpec.BooleanValue useChestImmersion;
    public static ForgeConfigSpec.BooleanValue useCraftingImmersion;
    public static ForgeConfigSpec.BooleanValue useFurnaceImmersion;
    public static ForgeConfigSpec.BooleanValue useJukeboxImmersion;
    public static ForgeConfigSpec.BooleanValue useRangedGrab;
    public static ForgeConfigSpec.BooleanValue useButton;
    public static ForgeConfigSpec.BooleanValue useETableImmersion;
    public static ForgeConfigSpec.BooleanValue useCampfireImmersion;
    public static ForgeConfigSpec.BooleanValue useLever;
    public static ForgeConfigSpec.BooleanValue useBackpack;
    public static ForgeConfigSpec.BooleanValue useRepeaterImmersion;
    public static ForgeConfigSpec.BooleanValue useDoorImmersion;
    public static ForgeConfigSpec.BooleanValue canPet;
    public static ForgeConfigSpec.BooleanValue useArmorImmersion;
    public static ForgeConfigSpec.BooleanValue canFeedAnimals;
    public static ForgeConfigSpec.BooleanValue useShulkerImmersion;
    public static ForgeConfigSpec.BooleanValue canPetAnyLiving;
    public static ForgeConfigSpec.BooleanValue immersiveShield;
    public static ForgeConfigSpec.IntValue rangedGrabRange;
    public static ForgeConfigSpec.BooleanValue useBeaconImmersion;
    public static ForgeConfigSpec.BooleanValue useBarrelImmersion;
    public static ForgeConfigSpec.BooleanValue useThrowing;
    public static ForgeConfigSpec.BooleanValue allowThrowingBeyondMax;
    public static ForgeConfigSpec.BooleanValue useHopperImmersion;
    public static ForgeConfigSpec.BooleanValue crouchBypassImmersion;
    public static ForgeConfigSpec.IntValue backpackColor;
    public static ForgeConfigSpec.BooleanValue rightClickChest;
    public static ForgeConfigSpec.BooleanValue autoCenterFurnace;
    public static ForgeConfigSpec.BooleanValue autoCenterBrewing;
    public static ForgeConfigSpec.BooleanValue useLowDetailBackpack;
    public static ForgeConfigSpec.IntValue placementGuideMode;
    public static ForgeConfigSpec.IntValue itemPlacementMode;
    public static ForgeConfigSpec.BooleanValue spinCraftingOutput;
    public static ForgeConfigSpec.BooleanValue rightClickInVR;
    public static ForgeConfigSpec.BooleanValue resourcePack3dCompat;
    public static ForgeConfigSpec.LongValue itemGuideColor;
    public static ForgeConfigSpec.LongValue itemGuideSelectedColor;
    public static ForgeConfigSpec.LongValue rangedGrabColor;
    public static ForgeConfigSpec.BooleanValue disableVanillaGUIs;
    public static ForgeConfigSpec.BooleanValue reachBehindBackpack;

    protected static void setupConfig(ForgeConfigSpec.Builder builder) {
        useAnvilImmersion = builder.comment("Whether immersives on anvils and smithing tables should be allowed").define("anvil_immersion", true);
        useBrewingImmersion = builder.comment("Whether immersives on brewing stands should be allowed").define("brewing_immersion", true);
        useChestImmersion = builder.comment("Whether immersives on all types of chests should be allowed. Unless users enable right_click_chest, this is VR only.").define("chest_immersion", true);
        useCraftingImmersion = builder.comment("Whether immersives on crafting tables should be allowed").define("crafting_immersion", true);
        useFurnaceImmersion = builder.comment("Whether immersives on furnaces should be allowed").define("furnace_immersion", true);
        useJukeboxImmersion = builder.comment("Whether immersives on jukeboxes should be allowed (VR only)").define("jukebox_immersion", true);
        useRangedGrab = builder.comment("Allow VR users to grab items at a distance.").define("ranged_grab", true);
        useButton = builder.comment("Whether VR users can physically push buttons").define("button_immersion", true);
        useETableImmersion = builder.comment("Whether immersives on Enchanting Tables should be allowed").define("enchant_table_immersion", true);
        useCampfireImmersion = builder.comment("Whether VR users can hold items above a campfire to cook them").define("campfire_immersion", true);
        useLever = builder.comment("Whether VR users can physically toggle levers").define("lever_immersion", true);
        useBackpack = builder.comment("Allow VR players to use a bag to manage their inventory").define("bag_inventory", true);
        useRepeaterImmersion = builder.comment("Whether VR users can adjust the delay of repeaters using their hands").define("repeater_immersion", true);
        useDoorImmersion = builder.comment("Whether VR users can open/close doors and fence gates using their hands").define("door_immersion", true);
        canPet = builder.comment("Whether VR users can pet animals they've tamed (or animals that are tamed for all once tamed, like horses)").define("can_pet", true);
        useArmorImmersion = builder.comment("Whether VR users can equip armor by placing the armor on them").define("armor_immersion", true);
        canFeedAnimals = builder.comment("Whether VR users can feed animals using both hands").define("feed_animals", true);
        useShulkerImmersion = builder.comment("Whether immersives on Shulker Boxes should be allowed").define("shulker_box_immersion", true);
        canPetAnyLiving = builder.comment("Whether VR players can pet any living entity instead of just pets that they're owners of. Requires 'can_pet' to be enabled!").define("can_pet_any_living", false);
        immersiveShield = builder.comment("Whether VR users can use a more immersive shield. They only need to hold a shield in the direction to block, no need to right click!").define("immersive_shield", true);
        rangedGrabRange = builder.comment("Range in blocks that VR players can pick up items using ranged grab. Set to -1 to use Minecraft's pick range.").defineInRange("ranged_grab_range", 8, -1, 12);
        useBeaconImmersion = builder.comment("Whether immersives on beacons should be allowed").define("beacon_immersion", true);
        useBarrelImmersion = builder.comment("Whether immersives on barrels should be allowed").define("barrel_immersion", true);
        useThrowing = builder.comment("Whether VR users can throw items based on the speed of their hand").define("use_throwing", true);
        allowThrowingBeyondMax = builder.comment("Whether VR throwing users can throw up to 5% beyond the velocity of non-VR users depending on how hard they throw").define("allow_throwing_beyond_max", true);
        useHopperImmersion = builder.comment("Whether immersives on hoppers should be allowed.").define("hopper_immersion", true);
        crouchBypassImmersion = builder.comment("Allow users to crouch + right-click to bypass immersives.").define("crouch_bypass_immersion", true);
        backpackColor = builder.comment("Color for the bag as a base-10 RGB number.").defineInRange("bag_color", 11901820, 0, 0xFFFFFF);
        rightClickChest = builder.comment("Allows for right-clicking chests to use their immersive. Works outside of VR!").define("right_click_chest", false);
        autoCenterFurnace = builder.comment("Makes the furnace immersive more centered instead of similar to the vanilla GUI").define("center_furnace", false);
        autoCenterBrewing = builder.comment("Makes the brewing stand more centered instead of similar to the vanilla GUI").define("center_brewing", false);
        useLowDetailBackpack = builder.comment("Use lower-detailed bag").define("low_detail_bag", false);
        placementGuideMode = builder.comment("The mode for the placement guide").defineInRange("placement_guide_mode", 0, 0, PlacementGuideMode.values().length - 1);
        itemPlacementMode = builder.comment("Integer representation for the mode to use when placing items using ImmersiveMC").defineInRange("placement_mode", 0, 0, PlacementMode.values().length - 1);
        spinCraftingOutput = builder.comment("Whether the item output of a crafting table should spin").define("spin_crafting_output", true);
        rightClickInVR = builder.comment("Allow right-clicking immersives in VR, like how NonVR users do.").define("right_click_in_vr", false);
        resourcePack3dCompat = builder.comment("Enables compatability for 3D resource packs like Classic 3D (16x)").define("resource_pack_3d_compat", false);
        itemGuideColor = builder.comment("Color for the item guides that help with item placement (aqua by default).").defineInRange("item_guide_color", 0x3300FFFFL, 0L, 0xFFFFFFFFL);
        itemGuideSelectedColor = builder.comment("Color for the item guides that help with item placement when hovered over (green by default).").defineInRange("item_guide_selected_color", 0x3300FF00L, 0L, 0xFFFFFFFFL);
        rangedGrabColor = builder.comment("Color for the particles shown when grabbing items from range (aqua by default).").defineInRange("ranged_grab_color", 0xFF00FFFFL, 0L, 0xFFFFFFFFL);
        disableVanillaGUIs = builder.comment("Disable vanilla GUIs when their respective immersive is enabled").define("disable_vanilla_interactions", false);
        reachBehindBackpack = builder.comment("Allow reaching behind you to grab your bag. Disables similar functionatliy from regular Vivecraft.").define("reach_behind_backpack", false);
    }

    public static void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(2).writeInt(4).writeBoolean(((Boolean)useAnvilImmersion.get()).booleanValue()).writeBoolean(((Boolean)useBrewingImmersion.get()).booleanValue()).writeBoolean(((Boolean)useChestImmersion.get()).booleanValue()).writeBoolean(((Boolean)useCraftingImmersion.get()).booleanValue()).writeBoolean(((Boolean)useFurnaceImmersion.get()).booleanValue()).writeBoolean(((Boolean)useJukeboxImmersion.get()).booleanValue()).writeBoolean(((Boolean)useRangedGrab.get()).booleanValue()).writeBoolean(((Boolean)useButton.get()).booleanValue()).writeBoolean(((Boolean)useETableImmersion.get()).booleanValue()).writeBoolean(((Boolean)useCampfireImmersion.get()).booleanValue()).writeBoolean(((Boolean)useLever.get()).booleanValue()).writeBoolean(((Boolean)useBackpack.get()).booleanValue()).writeBoolean(((Boolean)useRepeaterImmersion.get()).booleanValue()).writeBoolean(((Boolean)useDoorImmersion.get()).booleanValue()).writeBoolean(((Boolean)canPet.get()).booleanValue()).writeBoolean(((Boolean)useArmorImmersion.get()).booleanValue()).writeBoolean(((Boolean)canFeedAnimals.get()).booleanValue()).writeBoolean(((Boolean)useShulkerImmersion.get()).booleanValue()).writeBoolean(((Boolean)canPetAnyLiving.get()).booleanValue()).writeBoolean(((Boolean)immersiveShield.get()).booleanValue()).writeInt(((Integer)rangedGrabRange.get()).intValue()).writeBoolean(((Boolean)useBeaconImmersion.get()).booleanValue()).writeBoolean(((Boolean)useBarrelImmersion.get()).booleanValue()).writeBoolean(((Boolean)useThrowing.get()).booleanValue()).writeBoolean(((Boolean)allowThrowingBeyondMax.get()).booleanValue()).writeBoolean(((Boolean)useHopperImmersion.get()).booleanValue());
    }

    public static void resetToDefault() {
        useAnvilImmersion.set((Object)true);
        useBrewingImmersion.set((Object)true);
        useChestImmersion.set((Object)true);
        useCraftingImmersion.set((Object)true);
        useFurnaceImmersion.set((Object)true);
        useJukeboxImmersion.set((Object)true);
        useRangedGrab.set((Object)true);
        useButton.set((Object)true);
        useETableImmersion.set((Object)true);
        useCampfireImmersion.set((Object)true);
        useLever.set((Object)true);
        useBackpack.set((Object)true);
        useRepeaterImmersion.set((Object)true);
        useDoorImmersion.set((Object)true);
        canPet.set((Object)true);
        useArmorImmersion.set((Object)true);
        canFeedAnimals.set((Object)true);
        useShulkerImmersion.set((Object)true);
        canPetAnyLiving.set((Object)false);
        immersiveShield.set((Object)true);
        rangedGrabRange.set((Object)8);
        useBeaconImmersion.set((Object)true);
        useBarrelImmersion.set((Object)true);
        useThrowing.set((Object)true);
        allowThrowingBeyondMax.set((Object)true);
        useHopperImmersion.set((Object)true);
        crouchBypassImmersion.set((Object)true);
        backpackColor.set((Object)11901820);
        rightClickChest.set((Object)false);
        autoCenterFurnace.set((Object)false);
        autoCenterBrewing.set((Object)false);
        useLowDetailBackpack.set((Object)false);
        placementGuideMode.set((Object)0);
        itemPlacementMode.set((Object)0);
        spinCraftingOutput.set((Object)false);
        rightClickInVR.set((Object)false);
        resourcePack3dCompat.set((Object)false);
        itemGuideColor.set((Object)0x3300FFFFL);
        itemGuideSelectedColor.set((Object)0x3300FF00L);
        rangedGrabColor.set((Object)0xFF00FFFFL);
        disableVanillaGUIs.set((Object)false);
        reachBehindBackpack.set((Object)false);
    }

    static {
        ForgeConfigSpec.Builder configBuilder = new ForgeConfigSpec.Builder();
        ImmersiveMCConfig.setupConfig(configBuilder);
        GENERAL_SPEC = configBuilder.build();
    }
}

