/*
 * Decompiled with CFR 0.152.
 */
package com.hammy275.immersivemc.common.config;

import com.hammy275.immersivemc.ImmersiveMC;
import com.hammy275.immersivemc.common.config.ImmersiveMCConfig;
import com.hammy275.immersivemc.common.config.PlacementGuideMode;
import com.hammy275.immersivemc.common.config.PlacementMode;
import com.hammy275.immersivemc.common.network.Network;
import com.hammy275.immersivemc.common.network.packet.ConfigSyncPacket;
import com.hammy275.immersivemc.common.util.RGBA;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;

public class ActiveConfig {
    public static boolean useAnvilImmersion = false;
    public static boolean useBrewingImmersion = false;
    public static boolean useChestImmersion = false;
    public static boolean useCraftingImmersion = false;
    public static boolean useFurnaceImmersion = false;
    public static boolean useJukeboxImmersion = false;
    public static boolean useRangedGrab = false;
    public static boolean useButton = false;
    public static boolean useETableImmersion = false;
    public static boolean useCampfireImmersion = false;
    public static boolean useLever = false;
    public static boolean useBackpack = false;
    public static boolean useRepeaterImmersion = false;
    public static boolean useDoorImmersion = false;
    public static boolean canPet = false;
    public static boolean useArmorImmersion = false;
    public static boolean canFeedAnimals = false;
    public static boolean useShulkerImmersion = false;
    public static boolean canPetAnyLiving = false;
    public static boolean immersiveShield = false;
    public static int rangedGrabRange = 0;
    public static boolean useBeaconImmersion = false;
    public static boolean useBarrelImmersion = false;
    public static boolean useThrowing = false;
    public static boolean allowThrowingBeyondMax = false;
    public static boolean useHopperImmersion = false;
    public static boolean crouchBypassImmersion = false;
    public static int backpackColor = 11901820;
    public static boolean rightClickChest = false;
    public static boolean autoCenterFurnace = false;
    public static boolean autoCenterBrewing = false;
    public static boolean useLowDetailBackpack = false;
    public static PlacementGuideMode placementGuideMode = PlacementGuideMode.CUBE;
    public static PlacementMode placementMode = PlacementMode.PLACE_ONE;
    public static boolean spinCraftingOutput = true;
    public static boolean rightClickInVR = false;
    public static boolean resourcePack3dCompat = false;
    public static RGBA itemGuideColor = new RGBA(0x3300FFFFL);
    public static RGBA itemGuideSelectedColor = new RGBA(0x3300FF00L);
    public static RGBA rangedGrabColor = new RGBA(0xFF00FFFFL);
    public static boolean disableVanillaGUIs = false;
    public static boolean reachBehindBackpack = false;
    public static FriendlyByteBuf serverCopy = null;
    public static boolean clientForceServerReloadForLAN = false;

    public static void loadConfigFromPacket(FriendlyByteBuf buffer) {
        int serverConfigVersion;
        int serverNetworkVersion = buffer.readInt();
        if (serverNetworkVersion != 2) {
            Network.INSTANCE.sendToServer((Object)ConfigSyncPacket.getKickMePacket());
        }
        if ((serverConfigVersion = buffer.readInt()) != 4) {
            Network.INSTANCE.sendToServer((Object)ConfigSyncPacket.getKickMePacket());
        }
        serverCopy = new FriendlyByteBuf(buffer.copy());
        serverCopy.retain();
        ActiveConfig.loadFromByteBuffer(buffer);
        buffer.release();
        ImmersiveMC.LOGGER.debug("Loaded config from network: \n" + ActiveConfig.asString());
    }

    private static void loadFromByteBuffer(FriendlyByteBuf buffer) {
        ActiveConfig.loadConfigFromFile(true);
        useAnvilImmersion = buffer.readBoolean() && useAnvilImmersion;
        useBrewingImmersion = buffer.readBoolean() && useBrewingImmersion;
        useChestImmersion = buffer.readBoolean() && useChestImmersion;
        useCraftingImmersion = buffer.readBoolean() && useCraftingImmersion;
        useFurnaceImmersion = buffer.readBoolean() && useFurnaceImmersion;
        useJukeboxImmersion = buffer.readBoolean() && useJukeboxImmersion;
        useRangedGrab = buffer.readBoolean() && useRangedGrab;
        useButton = buffer.readBoolean() && useButton;
        useETableImmersion = buffer.readBoolean() && useETableImmersion;
        useCampfireImmersion = buffer.readBoolean() && useCampfireImmersion;
        useLever = buffer.readBoolean() && useLever;
        useBackpack = buffer.readBoolean() && useBackpack;
        useRepeaterImmersion = buffer.readBoolean() && useRepeaterImmersion;
        useDoorImmersion = buffer.readBoolean() && useDoorImmersion;
        canPet = buffer.readBoolean() && canPet;
        useArmorImmersion = buffer.readBoolean() && useArmorImmersion;
        canFeedAnimals = buffer.readBoolean() && canFeedAnimals;
        useShulkerImmersion = buffer.readBoolean() && useShulkerImmersion;
        canPetAnyLiving = buffer.readBoolean() && canPetAnyLiving;
        immersiveShield = buffer.readBoolean() && immersiveShield;
        rangedGrabRange = Math.min(buffer.readInt(), rangedGrabRange);
        useBeaconImmersion = buffer.readBoolean() && useBeaconImmersion;
        useBarrelImmersion = buffer.readBoolean() && useBarrelImmersion;
        useThrowing = buffer.readBoolean() && useThrowing;
        allowThrowingBeyondMax = buffer.readBoolean() && allowThrowingBeyondMax;
        useHopperImmersion = buffer.readBoolean() && useHopperImmersion;
    }

    public static void loadConfigFromFile() {
        ActiveConfig.loadConfigFromFile(false);
    }

    public static void loadConfigFromFile(boolean forceLoadServerSettings) {
        if (forceLoadServerSettings || Minecraft.m_91087_().f_91073_ == null) {
            useAnvilImmersion = (Boolean)ImmersiveMCConfig.useAnvilImmersion.get();
            useBrewingImmersion = (Boolean)ImmersiveMCConfig.useBrewingImmersion.get();
            useChestImmersion = (Boolean)ImmersiveMCConfig.useChestImmersion.get();
            useCraftingImmersion = (Boolean)ImmersiveMCConfig.useCraftingImmersion.get();
            useFurnaceImmersion = (Boolean)ImmersiveMCConfig.useFurnaceImmersion.get();
            useJukeboxImmersion = (Boolean)ImmersiveMCConfig.useJukeboxImmersion.get();
            useRangedGrab = (Boolean)ImmersiveMCConfig.useRangedGrab.get();
            useButton = (Boolean)ImmersiveMCConfig.useButton.get();
            useETableImmersion = (Boolean)ImmersiveMCConfig.useETableImmersion.get();
            useCampfireImmersion = (Boolean)ImmersiveMCConfig.useCampfireImmersion.get();
            useLever = (Boolean)ImmersiveMCConfig.useLever.get();
            useBackpack = (Boolean)ImmersiveMCConfig.useBackpack.get();
            useRepeaterImmersion = (Boolean)ImmersiveMCConfig.useRepeaterImmersion.get();
            useDoorImmersion = (Boolean)ImmersiveMCConfig.useDoorImmersion.get();
            canPet = (Boolean)ImmersiveMCConfig.canPet.get();
            useArmorImmersion = (Boolean)ImmersiveMCConfig.useArmorImmersion.get();
            canFeedAnimals = (Boolean)ImmersiveMCConfig.canFeedAnimals.get();
            useShulkerImmersion = (Boolean)ImmersiveMCConfig.useShulkerImmersion.get();
            canPetAnyLiving = (Boolean)ImmersiveMCConfig.canPetAnyLiving.get();
            immersiveShield = (Boolean)ImmersiveMCConfig.immersiveShield.get();
            rangedGrabRange = (Integer)ImmersiveMCConfig.rangedGrabRange.get();
            useBeaconImmersion = (Boolean)ImmersiveMCConfig.useBeaconImmersion.get();
            useBarrelImmersion = (Boolean)ImmersiveMCConfig.useBarrelImmersion.get();
            useThrowing = (Boolean)ImmersiveMCConfig.useThrowing.get();
            allowThrowingBeyondMax = (Boolean)ImmersiveMCConfig.allowThrowingBeyondMax.get();
            useHopperImmersion = (Boolean)ImmersiveMCConfig.useHopperImmersion.get();
        } else {
            ImmersiveMC.LOGGER.debug("Not re-loading immersive options since we're in a world!");
        }
        crouchBypassImmersion = (Boolean)ImmersiveMCConfig.crouchBypassImmersion.get();
        backpackColor = (Integer)ImmersiveMCConfig.backpackColor.get();
        rightClickChest = (Boolean)ImmersiveMCConfig.rightClickChest.get();
        autoCenterFurnace = (Boolean)ImmersiveMCConfig.autoCenterFurnace.get();
        autoCenterBrewing = (Boolean)ImmersiveMCConfig.autoCenterBrewing.get();
        useLowDetailBackpack = (Boolean)ImmersiveMCConfig.useLowDetailBackpack.get();
        placementGuideMode = PlacementGuideMode.values()[(Integer)ImmersiveMCConfig.placementGuideMode.get()];
        placementMode = PlacementMode.fromInt((Integer)ImmersiveMCConfig.itemPlacementMode.get());
        spinCraftingOutput = (Boolean)ImmersiveMCConfig.spinCraftingOutput.get();
        rightClickInVR = (Boolean)ImmersiveMCConfig.rightClickInVR.get();
        resourcePack3dCompat = (Boolean)ImmersiveMCConfig.resourcePack3dCompat.get();
        itemGuideColor = new RGBA((Long)ImmersiveMCConfig.itemGuideColor.get());
        itemGuideSelectedColor = new RGBA((Long)ImmersiveMCConfig.itemGuideSelectedColor.get());
        rangedGrabColor = new RGBA((Long)ImmersiveMCConfig.rangedGrabColor.get());
        disableVanillaGUIs = (Boolean)ImmersiveMCConfig.disableVanillaGUIs.get();
        reachBehindBackpack = (Boolean)ImmersiveMCConfig.reachBehindBackpack.get();
        ImmersiveMC.LOGGER.debug("Loaded config from file: \n" + ActiveConfig.asString());
    }

    public static void loadOffConfig() {
        useAnvilImmersion = false;
        useBrewingImmersion = false;
        useChestImmersion = false;
        useCraftingImmersion = false;
        useFurnaceImmersion = false;
        useJukeboxImmersion = false;
        useRangedGrab = false;
        useButton = false;
        useETableImmersion = false;
        useCampfireImmersion = false;
        useLever = false;
        useBackpack = false;
        useRepeaterImmersion = false;
        useDoorImmersion = false;
        canPet = false;
        useArmorImmersion = false;
        canFeedAnimals = false;
        useShulkerImmersion = false;
        canPetAnyLiving = false;
        immersiveShield = false;
        rangedGrabRange = 0;
        useBeaconImmersion = false;
        crouchBypassImmersion = false;
        useBarrelImmersion = false;
        useThrowing = false;
        allowThrowingBeyondMax = false;
        useHopperImmersion = false;
        ImmersiveMC.LOGGER.debug("Loaded 'disabled' config: \n" + ActiveConfig.asString());
    }

    public static FriendlyByteBuf encodeServerOnlyConfig(FriendlyByteBuf buffer) {
        buffer.writeBoolean(useButton).writeBoolean(useCampfireImmersion).writeBoolean(useLever).writeBoolean(useRangedGrab).writeBoolean(useDoorImmersion).writeBoolean(canPet).writeBoolean(useArmorImmersion).writeBoolean(canFeedAnimals).writeBoolean(canPetAnyLiving).writeInt(rangedGrabRange).writeBoolean(crouchBypassImmersion);
        return buffer;
    }

    public static String asString() {
        String stringOut = "Use anvil immersion: " + useAnvilImmersion + "\nUse brewing immersion: " + useBrewingImmersion + "\nUse chest immersion: " + useChestImmersion + "\nUse crafting immersion: " + useCraftingImmersion + "\nUse furnace immersion: " + useFurnaceImmersion + "\nUse jukebox immersion: " + useJukeboxImmersion + "\nUse ranged grab: " + useRangedGrab + "\nUse button: " + useButton + "\nUse enchanting table: " + useETableImmersion + "\nUse campfire immersion: " + useCampfireImmersion + "\nUse lever: " + useLever + "\nUse backpack: " + useBackpack + "\nBackpack color: " + backpackColor + "\nUse right click chest: " + rightClickChest + "\nUse repeater immersion: " + useRepeaterImmersion + "\nAuto-center furnace: " + autoCenterFurnace + "\nAuto-center brewing: " + autoCenterBrewing + "\nUse low detailed bag: " + useLowDetailBackpack + "\nPlacement Guide mode: " + placementGuideMode + "\nPlacement mode: " + placementMode + "\nUse door immersion: " + useDoorImmersion + "\nSpin crafting output: " + spinCraftingOutput + "\nCan pet: " + canPet + "\nUse armor immersion: " + useArmorImmersion + "\nCan feed animals: " + canFeedAnimals + "\nUse Shulker Box Immersion: " + useShulkerImmersion + "\nCan pet any living: " + canPetAnyLiving + "\nUse immersive shield: " + immersiveShield + "\nRanged grab range: " + rangedGrabRange + "\nRight click in VR: " + rightClickInVR + "\n3D resource pack compatability: " + resourcePack3dCompat + "\nUse beacon immersion: " + useBeaconImmersion + "\nCrouch bypass immersion: " + crouchBypassImmersion + "\nUse barrel immersion: " + useBarrelImmersion + "\nUse throwing: " + useThrowing + "\nAllow throwing beyond max: " + allowThrowingBeyondMax + "\nItem Guide Color: " + itemGuideColor + "\nItem Guide Selected Color: " + itemGuideSelectedColor + "\nRanged Grab Color: " + rangedGrabColor + "\nUse Hopper Immersion: " + useHopperImmersion + "\nDisable Vanilla GUIs: " + disableVanillaGUIs + "\nReach Behind Backpack: " + reachBehindBackpack;
        return stringOut;
    }

    public static void reloadAfterServer() {
        if (serverCopy != null) {
            int oldIndex = serverCopy.readerIndex();
            ActiveConfig.loadFromByteBuffer(serverCopy);
            serverCopy.readerIndex(oldIndex);
            ImmersiveMC.LOGGER.debug("Reloaded config while in-game: \n" + ActiveConfig.asString());
            Network.INSTANCE.sendToServer((Object)ConfigSyncPacket.getToServerConfigPacket());
            clientForceServerReloadForLAN = true;
        }
    }
}

