/*
 * Decompiled with CFR 0.152.
 */
package com.hammy275.immersivemc.client.immersive.info;

import com.hammy275.immersivemc.client.immersive.info.AbstractBlockEntityImmersiveInfo;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class ChestInfo
extends AbstractBlockEntityImmersiveInfo<BlockEntity> {
    protected AABB[] hitboxes = new AABB[54];
    public BlockEntity other = null;
    public Direction forward = null;
    public boolean failRender = false;
    protected int rowNum = 0;
    public boolean isOpen = false;
    public double lastY0;
    public double lastY1;
    public AABB[] openCloseHitboxes = new AABB[]{null, null};
    public Vec3[] openClosePositions = new Vec3[]{null, null};
    public int openCloseCooldown = 0;
    public boolean isTFCChest;

    public ChestInfo(BlockEntity tileEntity, int ticksToExist, BlockEntity other) {
        super(tileEntity, ticksToExist, 53);
        this.other = other;
        this.isTFCChest = tileEntity.getClass().getName().startsWith("net.dries007.tfc");
    }

    public void nextRow() {
        this.rowNum = this.getNextRow(this.rowNum);
    }

    public int getNextRow(int rowIn) {
        int rowMax;
        int n = rowMax = this.isTFCChest ? 1 : 2;
        if (++rowIn > rowMax) {
            return 0;
        }
        return rowIn;
    }

    public int getRowNum() {
        return this.rowNum;
    }

    @Override
    public void setInputSlots() {
        this.inputHitboxes = this.isOpen ? this.hitboxes : new AABB[0];
    }

    @Override
    public AABB getHitbox(int slot) {
        return this.hitboxes[slot];
    }

    @Override
    public AABB[] getAllHitboxes() {
        return this.hitboxes;
    }

    @Override
    public void setHitbox(int slot, AABB hitbox) {
        this.hitboxes[slot] = hitbox;
    }

    @Override
    public boolean hasHitboxes() {
        return this.hitboxes[8] != null || this.hitboxes[17] != null || this.hitboxes[26] != null;
    }

    @Override
    public boolean hasItems() {
        boolean otherChest;
        boolean mainChest;
        if (this.isTFCChest) {
            mainChest = this.items[17] != null;
            otherChest = this.other == null || this.items[44] != null;
        } else {
            mainChest = this.items[26] != null;
            otherChest = this.other == null || this.items[53] != null;
        }
        return mainChest && otherChest;
    }
}

