/*
 * Decompiled with CFR 0.152.
 */
package com.hammy275.immersivemc.client.immersive.info;

import com.hammy275.immersivemc.client.immersive.info.AbstractWorldStorageInfo;
import com.hammy275.immersivemc.client.immersive.info.InfoTriggerHitboxes;
import java.util.Arrays;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class BeaconInfo
extends AbstractWorldStorageInfo
implements InfoTriggerHitboxes {
    public boolean regenSelected = false;
    public int effectSelected = -1;
    public Direction lastPlayerDir = null;
    public AABB[] triggerBoxes = new AABB[8];
    public Vec3 effectSelectedDisplayPos = null;
    public boolean areaAboveIsAir = false;

    public BeaconInfo(BlockPos pos) {
        super(pos, 1200, 0);
    }

    @Override
    public void setInputSlots() {
        this.inputHitboxes = Arrays.copyOfRange(this.hitboxes, 0, 1);
    }

    @Override
    public boolean readyToRender() {
        return super.readyToRender() && this.lastPlayerDir != null && this.triggerBoxes[1] != null && this.effectSelectedDisplayPos != null && this.areaAboveIsAir;
    }

    @Override
    public AABB getTriggerHitbox(int hitboxNum) {
        return this.triggerBoxes[hitboxNum];
    }

    @Override
    public AABB[] getTriggerHitboxes() {
        return this.triggerBoxes;
    }

    @Override
    public int getVRControllerNum() {
        return 0;
    }

    public boolean isReadyForConfirmExceptPayment() {
        return this.effectSelected > -1;
    }

    public boolean isReadyForConfirm() {
        return this.isReadyForConfirmExceptPayment() && this.items[0] != null && this.items[0].m_204117_(ItemTags.f_13164_);
    }

    public int getEffectId() {
        switch (this.effectSelected) {
            case 0: {
                return Registry.f_122823_.m_7447_((Object)MobEffects.f_19596_);
            }
            case 1: {
                return Registry.f_122823_.m_7447_((Object)MobEffects.f_19598_);
            }
            case 2: {
                return Registry.f_122823_.m_7447_((Object)MobEffects.f_19606_);
            }
            case 3: {
                return Registry.f_122823_.m_7447_((Object)MobEffects.f_19603_);
            }
            case 4: {
                return Registry.f_122823_.m_7447_((Object)MobEffects.f_19600_);
            }
        }
        return -1;
    }
}

