/*
 * Decompiled with CFR 0.152.
 */
package com.hammy275.immersivemc.client.immersive.info;

import com.hammy275.immersivemc.client.immersive.info.AbstractBlockEntityImmersiveInfo;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.entity.BarrelBlockEntity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class BarrelInfo
extends AbstractBlockEntityImmersiveInfo<BarrelBlockEntity> {
    public int rowNum = 0;
    public boolean isOpen = false;
    protected AABB[] hitboxes = new AABB[27];
    public boolean updateHitboxes = false;
    public Direction forward = null;
    public AABB pullHitbox = null;
    public Vec3[] lastControllerPos = new Vec3[2];
    public Vec3 lastPlayerPos = null;
    public int placeItemCooldown = 0;

    public BarrelInfo(BarrelBlockEntity tileEntity) {
        super(tileEntity, Integer.MAX_VALUE, 26);
    }

    public void nextRow() {
        this.rowNum = this.getNextRow(this.rowNum);
        this.updateHitboxes = true;
    }

    public int getNextRow(int rowIn) {
        if (++rowIn > 2) {
            return 0;
        }
        return rowIn;
    }

    public int getRowNum() {
        return this.rowNum;
    }

    @Override
    public void setInputSlots() {
        this.inputHitboxes = this.isOpen ? this.hitboxes : new AABB[0];
    }

    @Override
    public AABB getHitbox(int slot) {
        return this.hitboxes[slot];
    }

    @Override
    public AABB[] getAllHitboxes() {
        return this.hitboxes;
    }

    @Override
    public void setHitbox(int slot, AABB hitbox) {
        this.hitboxes[slot] = hitbox;
    }

    @Override
    public boolean readyToRender() {
        return super.readyToRender() && this.forward != null;
    }

    @Override
    public boolean hasPositions() {
        return this.positions[8] != null || this.positions[17] != null || this.positions[26] != null;
    }

    @Override
    public boolean hasHitboxes() {
        return this.hitboxes[8] != null || this.hitboxes[17] != null || this.hitboxes[26] != null;
    }
}

