/*
 * Decompiled with CFR 0.152.
 */
package com.hammy275.immersivemc.client.immersive.info;

import com.hammy275.immersivemc.client.immersive.info.AbstractImmersiveInfo;
import com.mojang.math.Vector3f;
import java.util.Arrays;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class BackpackInfo
extends AbstractImmersiveInfo {
    protected final Vec3[] positions = new Vec3[32];
    protected final AABB[] hitboxes = new AABB[32];
    public Vec3 handPos = Vec3.f_82478_;
    public Vec3 lookVec = Vec3.f_82478_;
    public Vec3 renderPos = Vec3.f_82478_;
    public Vec3 centerTopPos = Vec3.f_82478_;
    public Vec3 downVec = Vec3.f_82478_;
    public float handPitch = 0.0f;
    public float handYaw = 0.0f;
    public Vec3 backVec = Vec3.f_82478_;
    public Vector3f rgb = new Vector3f(0.0f, 0.0f, 0.0f);
    public int topRow = 0;
    public ItemStack[] craftingInput = new ItemStack[]{ItemStack.f_41583_, ItemStack.f_41583_, ItemStack.f_41583_, ItemStack.f_41583_};
    public ItemStack craftingOutput = ItemStack.f_41583_;

    public BackpackInfo() {
        super(Integer.MAX_VALUE);
    }

    @Override
    public void setInputSlots() {
        this.inputHitboxes = Arrays.copyOfRange(this.hitboxes, 0, 31);
    }

    @Override
    public AABB getHitbox(int slot) {
        return this.hitboxes[slot];
    }

    @Override
    public AABB[] getAllHitboxes() {
        return this.hitboxes;
    }

    @Override
    public void setHitbox(int slot, AABB hitbox) {
        this.hitboxes[slot] = hitbox;
    }

    @Override
    public boolean hasHitboxes() {
        return this.hitboxes[26] != null;
    }

    @Override
    public Vec3 getPosition(int slot) {
        return this.positions[slot];
    }

    @Override
    public Vec3[] getAllPositions() {
        return this.positions;
    }

    @Override
    public void setPosition(int slot, Vec3 position) {
        this.positions[slot] = position;
    }

    @Override
    public boolean hasPositions() {
        return this.positions[26] != null;
    }

    @Override
    public boolean readyToRender() {
        return this.hasPositions() && this.hasHitboxes();
    }

    @Override
    public BlockPos getBlockPosition() {
        return Minecraft.m_91087_().f_91074_.m_142538_();
    }

    public void gotoNextRow() {
        if (++this.topRow > 2) {
            this.topRow = 0;
        }
    }

    public int getMidRow() {
        int midRow = this.topRow + 1;
        if (midRow > 2) {
            return 0;
        }
        return midRow;
    }

    public int getBotRow() {
        int botRow = this.getMidRow() + 1;
        if (botRow > 2) {
            return 0;
        }
        return botRow;
    }
}

