/*
 * Decompiled with CFR 0.152.
 */
package com.hammy275.immersivemc.client.immersive.info;

import com.hammy275.immersivemc.client.immersive.info.AbstractImmersiveInfo;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;

public abstract class AbstractBlockEntityImmersiveInfo<T extends BlockEntity>
extends AbstractImmersiveInfo {
    protected T tileEntity;
    protected Vec3[] positions;
    public ItemStack[] items;
    public final int maxSlotIndex;
    protected final BlockPos pos;

    public AbstractBlockEntityImmersiveInfo(T tileEntity, int ticksToExist, int maxSlotIndex) {
        super(ticksToExist);
        this.tileEntity = tileEntity;
        this.positions = new Vec3[maxSlotIndex + 1];
        this.maxSlotIndex = maxSlotIndex;
        this.items = new ItemStack[maxSlotIndex + 1];
        this.pos = this.tileEntity.m_58899_();
    }

    public T getBlockEntity() {
        return this.tileEntity;
    }

    @Override
    public Vec3 getPosition(int slot) {
        return this.positions[slot];
    }

    @Override
    public Vec3[] getAllPositions() {
        return this.positions;
    }

    @Override
    public void setPosition(int slot, Vec3 position) {
        this.positions[slot] = position;
    }

    @Override
    public boolean hasPositions() {
        return this.positions[0] != null;
    }

    @Override
    public boolean readyToRender() {
        return this.hasHitboxes() && this.hasPositions() && this.hasItems();
    }

    @Override
    public BlockPos getBlockPosition() {
        return this.pos;
    }

    public boolean hasItems() {
        return this.items[this.maxSlotIndex] != null;
    }
}

