/*
 * Decompiled with CFR 0.152.
 */
package com.hammy275.immersivemc.client.immersive;

import com.hammy275.immersivemc.client.immersive.AbstractBlockEntityImmersive;
import com.hammy275.immersivemc.client.immersive.AbstractImmersive;
import com.hammy275.immersivemc.client.immersive.Immersives;
import com.hammy275.immersivemc.client.immersive.info.AbstractImmersiveInfo;
import com.hammy275.immersivemc.client.immersive.info.ShulkerInfo;
import com.hammy275.immersivemc.common.config.ActiveConfig;
import com.hammy275.immersivemc.common.immersive.ImmersiveCheckers;
import com.hammy275.immersivemc.common.network.Network;
import com.hammy275.immersivemc.common.network.packet.ChestShulkerOpenPacket;
import com.hammy275.immersivemc.common.network.packet.SwapPacket;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.ShulkerBoxBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ShulkerBoxBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class ImmersiveShulker
extends AbstractBlockEntityImmersive<ShulkerBoxBlockEntity, ShulkerInfo> {
    public ImmersiveShulker() {
        super(4);
    }

    @Override
    public ShulkerInfo getNewInfo(BlockEntity tileEnt) {
        return new ShulkerInfo((ShulkerBoxBlockEntity)tileEnt, 300);
    }

    @Override
    public int getTickTime() {
        return 300;
    }

    @Override
    public boolean shouldRender(ShulkerInfo info, boolean isInVR) {
        return info.readyToRender() && info.isOpen;
    }

    @Override
    protected void render(ShulkerInfo info, PoseStack stack, boolean isInVR) {
        float itemSize = 0.2f / (float)info.getItemTransitionCountdown();
        for (int i = 0; i < 27; ++i) {
            float renderSize = info.slotHovered == i ? itemSize * 1.25f : itemSize;
            this.renderItem(info.items[i], stack, info.getPosition(i), renderSize, info.viewForwardDir, info.upDownRender, info.getHitbox(i), true, -1, info.light);
        }
    }

    @Override
    public boolean enabledInConfig() {
        return ActiveConfig.useShulkerImmersion;
    }

    @Override
    public boolean shouldTrack(BlockPos pos, BlockState state, BlockEntity tileEntity, Level level) {
        return ImmersiveCheckers.isShulkerBox(pos, state, tileEntity, level);
    }

    @Override
    public AbstractImmersive<? extends AbstractImmersiveInfo> getSingleton() {
        return Immersives.immersiveShulker;
    }

    @Override
    public boolean shouldBlockClickIfEnabled(AbstractImmersiveInfo info) {
        return true;
    }

    @Override
    protected void initInfo(ShulkerInfo info) {
        this.setHitboxes(info);
    }

    public void setHitboxes(ShulkerInfo info) {
        int i;
        Vec3[] positions;
        BlockEntity shulker = Minecraft.m_91087_().f_91073_.m_7702_(info.getBlockPosition());
        Direction forward = (Direction)shulker.m_58900_().m_61143_((Property)ShulkerBoxBlock.f_56183_);
        Vec3 forwardVec = new Vec3((double)forward.m_122436_().m_123341_(), (double)forward.m_122436_().m_123342_(), (double)forward.m_122436_().m_123343_());
        info.upDownRender = null;
        if (forward == Direction.DOWN || forward == Direction.UP) {
            positions = this.get3x3VerticalGrid(info.getBlockPosition(), 0.15);
            for (i = 0; i < positions.length; ++i) {
                positions[i] = positions[i].m_82549_(forwardVec.m_82490_(0.25));
            }
            info.viewForwardDir = this.getForwardFromPlayer((Player)Minecraft.m_91087_().f_91074_);
        } else {
            Direction left = forward.m_122428_();
            Vec3 leftVec = new Vec3((double)left.m_122436_().m_123341_(), (double)left.m_122436_().m_123342_(), (double)left.m_122436_().m_123343_());
            Vec3 centerPos = Vec3.m_82512_((Vec3i)info.getBlockPosition());
            Vec3 leftPos = centerPos.m_82549_(leftVec.m_82490_(0.5));
            Vec3 rightPos = centerPos.m_82549_(leftVec.m_82490_(-0.5));
            Vec3 topPos = centerPos.m_82520_(0.0, 0.5, 0.0);
            Vec3 botPos = centerPos.m_82520_(0.0, -0.5, 0.0);
            Vec3 playerPos = Minecraft.m_91087_().f_91074_.m_146892_();
            double leftDist = playerPos.m_82557_(leftPos);
            double rightDist = playerPos.m_82557_(rightPos);
            double topDist = playerPos.m_82557_(topPos);
            double botDist = playerPos.m_82557_(botPos);
            double min = Math.min(leftDist, rightDist);
            min = Math.min(min, topDist);
            if ((min = Math.min(min, botDist)) == leftDist) {
                positions = this.get3x3VerticalGrid(info.getBlockPosition(), 0.15, forward.m_122428_());
                for (i = 0; i < positions.length; ++i) {
                    positions[i] = positions[i].m_82549_(forwardVec.m_82490_(0.25));
                }
                info.viewForwardDir = left;
            } else if (min == rightDist) {
                positions = this.get3x3VerticalGrid(info.getBlockPosition(), 0.15, forward.m_122427_());
                for (i = 0; i < positions.length; ++i) {
                    positions[i] = positions[i].m_82549_(forwardVec.m_82490_(0.25));
                }
                info.viewForwardDir = left.m_122424_();
            } else if (min == topDist) {
                positions = this.get3x3HorizontalGrid(info.getBlockPosition(), 0.15, forward, false);
                for (i = 0; i < positions.length; ++i) {
                    positions[i] = positions[i].m_82549_(forwardVec.m_82490_(0.25));
                }
                info.viewForwardDir = this.getForwardFromPlayer((Player)Minecraft.m_91087_().f_91074_);
                info.upDownRender = Direction.UP;
            } else {
                positions = this.get3x3HorizontalGrid(info.getBlockPosition(), 0.15, forward, false);
                for (i = 0; i < positions.length; ++i) {
                    positions[i] = positions[i].m_82520_(0.0, -1.0, 0.0).m_82549_(forwardVec.m_82490_(0.25));
                }
                info.viewForwardDir = this.getForwardFromPlayer((Player)Minecraft.m_91087_().f_91074_);
                info.upDownRender = Direction.DOWN;
            }
        }
        for (i = 0; i < 27; ++i) {
            info.setHitbox(i, null);
            info.setPosition(i, null);
        }
        for (i = 0; i < 9; ++i) {
            info.setHitbox(i + info.getRowNum() * 9, this.createHitbox(positions[i], 0.075f));
            info.setPosition(i + info.getRowNum() * 9, positions[i]);
        }
    }

    @Override
    public void handleRightClick(AbstractImmersiveInfo info, Player player, int closest, InteractionHand hand) {
        if (((ShulkerInfo)info).isOpen) {
            Network.INSTANCE.sendToServer((Object)new SwapPacket(info.getBlockPosition(), closest, hand));
        }
    }

    @Override
    protected void doTick(ShulkerInfo info, boolean isInVR) {
        super.doTick(info, isInVR);
        this.setHitboxes(info);
    }

    @Override
    public BlockPos getLightPos(ShulkerInfo info) {
        return info.getBlockPosition().m_142300_(info.viewForwardDir);
    }

    public static void openShulkerBox(ShulkerInfo info) {
        info.isOpen = !info.isOpen;
        Network.INSTANCE.sendToServer((Object)new ChestShulkerOpenPacket(info.getBlockPosition(), info.isOpen));
        if (!info.isOpen) {
            info.remove();
        }
    }

    @Override
    public boolean hitboxesAvailable(AbstractImmersiveInfo info) {
        return ((ShulkerInfo)info).isOpen;
    }
}

