/*
 * Decompiled with CFR 0.152.
 */
package com.hammy275.immersivemc.client.immersive;

import com.hammy275.immersivemc.client.immersive.AbstractBlockEntityImmersive;
import com.hammy275.immersivemc.client.immersive.AbstractImmersive;
import com.hammy275.immersivemc.client.immersive.Immersives;
import com.hammy275.immersivemc.client.immersive.info.AbstractImmersiveInfo;
import com.hammy275.immersivemc.client.immersive.info.HopperInfo;
import com.hammy275.immersivemc.common.config.ActiveConfig;
import com.hammy275.immersivemc.common.immersive.ImmersiveCheckers;
import com.hammy275.immersivemc.common.network.Network;
import com.hammy275.immersivemc.common.network.packet.SwapPacket;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.HopperBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class ImmersiveHopper
extends AbstractBlockEntityImmersive<HopperBlockEntity, HopperInfo> {
    public ImmersiveHopper() {
        super(2);
    }

    protected void setHitboxes(HopperInfo info) {
        Vec3[] positions;
        Direction forward;
        Direction forwardUnmodified = forward = this.getForwardFromPlayer((Player)Minecraft.m_91087_().f_91074_);
        if (this.isAboveHopper(info.getBlockPosition(), Minecraft.m_91087_().f_91074_.m_20182_())) {
            forward = Direction.UP;
            Vec3[] positionsRaw = this.get3x3HorizontalGrid(info.getBlockPosition(), 0.1875, forwardUnmodified, false);
            positions = new Vec3[]{positionsRaw[1], positionsRaw[3], positionsRaw[4], positionsRaw[5], positionsRaw[7]};
        } else {
            Vec3 leftUnscaled = Vec3.m_82528_((Vec3i)this.getLeftOfDirection(forward).m_122436_());
            Vec3 forwardBotLeft = this.getDirectlyInFront(forward, info.getBlockPosition());
            Vec3 center = forwardBotLeft.m_82520_(0.0, 0.8749999970197677, 0.0).m_82549_(leftUnscaled.m_82490_(0.5));
            Vec3 rightScaled = leftUnscaled.m_82490_(-1.0).m_82490_((double)0.165f);
            Vec3 leftScaled = rightScaled.m_82490_(-1.0);
            positions = new Vec3[]{center.m_82549_(rightScaled).m_82549_(rightScaled), center.m_82549_(rightScaled), center, center.m_82549_(leftScaled), center.m_82549_(leftScaled).m_82549_(leftScaled)};
        }
        for (int i = 0; i < positions.length; ++i) {
            info.setPosition(i, positions[i]);
            info.setHitbox(i, AABB.m_165882_((Vec3)positions[i], (double)0.15f, (double)0.15f, (double)0.15f));
        }
        info.lastDirectionForBoxPos = forward;
        info.lastDirectionForBoxRot = forwardUnmodified;
    }

    @Override
    protected void doTick(HopperInfo info, boolean isInVR) {
        Direction forwardForBoxPos;
        super.doTick(info, isInVR);
        Direction forwardForBoxRot = forwardForBoxPos = this.getForwardFromPlayer((Player)Minecraft.m_91087_().f_91074_);
        if (this.isAboveHopper(info.getBlockPosition(), Minecraft.m_91087_().f_91074_.m_20182_())) {
            forwardForBoxPos = Direction.UP;
        }
        if (forwardForBoxPos != info.lastDirectionForBoxPos || forwardForBoxRot != info.lastDirectionForBoxRot) {
            this.setHitboxes(info);
        }
    }

    @Override
    public BlockPos getLightPos(HopperInfo info) {
        return info.getBlockPosition().m_142300_(info.lastDirectionForBoxPos);
    }

    @Override
    public HopperInfo getNewInfo(BlockEntity tileEnt) {
        return new HopperInfo((HopperBlockEntity)tileEnt);
    }

    @Override
    public int getTickTime() {
        return 100;
    }

    @Override
    public boolean shouldRender(HopperInfo info, boolean isInVR) {
        return info.readyToRender();
    }

    @Override
    protected void render(HopperInfo info, PoseStack stack, boolean isInVR) {
        float itemSize = 0.15f / (float)info.getItemTransitionCountdown();
        for (int i = 0; i <= 4; ++i) {
            float renderSize = info.slotHovered == i ? itemSize * 1.25f : itemSize;
            Direction neswDir = info.lastDirectionForBoxPos == Direction.UP || info.lastDirectionForBoxPos == Direction.DOWN ? this.getForwardFromPlayer((Player)Minecraft.m_91087_().f_91074_) : info.lastDirectionForBoxPos;
            this.renderItem(info.items[i], stack, info.getPosition(i), renderSize, neswDir, info.lastDirectionForBoxPos, info.getHitbox(i), true, -1, info.light);
        }
    }

    @Override
    public boolean enabledInConfig() {
        return ActiveConfig.useHopperImmersion;
    }

    @Override
    public boolean shouldTrack(BlockPos pos, BlockState state, BlockEntity tileEntity, Level level) {
        return ImmersiveCheckers.isHopper(pos, state, tileEntity, level);
    }

    @Override
    public AbstractImmersive<? extends AbstractImmersiveInfo> getSingleton() {
        return Immersives.immersiveHopper;
    }

    @Override
    public boolean shouldBlockClickIfEnabled(AbstractImmersiveInfo info) {
        return true;
    }

    @Override
    protected void initInfo(HopperInfo info) {
        this.setHitboxes(info);
    }

    @Override
    public void handleRightClick(AbstractImmersiveInfo info, Player player, int closest, InteractionHand hand) {
        Network.INSTANCE.sendToServer((Object)new SwapPacket(info.getBlockPosition(), closest, hand));
    }

    public boolean isAboveHopper(BlockPos hopperPos, Vec3 playerPos) {
        return playerPos.f_82480_ >= (double)hopperPos.m_7494_().m_123342_() || playerPos.m_82557_(Vec3.m_82512_((Vec3i)hopperPos)) < 0.25 && playerPos.f_82480_ >= (double)hopperPos.m_123342_() + 0.625;
    }
}

